/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModPotions;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModPotionRecipes {
    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        ItemStack water = ModPotionRecipes.potion(Potions.f_43599_);
        ItemStack shock = ModPotionRecipes.potion((Potion)ModPotions.SHOCK.get());
        ItemStack strongShock = ModPotionRecipes.potion((Potion)ModPotions.STRONG_SHOCK.get());
        ItemStack longShock = ModPotionRecipes.potion((Potion)ModPotions.LONG_SHOCK.get());
        event.enqueueWork(() -> {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{water}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151041_}), shock));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{shock}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_}), strongShock));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{shock}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), longShock));
        });
    }

    private static ItemStack potion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)potion);
    }

    public static class PotionRecipe
    extends BrewingRecipe {
        private final Ingredient input;
        private final Ingredient ingredient;

        public PotionRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
            super(input, ingredient, output);
            this.input = input;
            this.ingredient = ingredient;
        }

        public boolean isInput(@NotNull ItemStack stack) {
            ItemStack[] matchingStacks = this.input.m_43908_();
            return matchingStacks.length == 0 ? stack.m_41619_() : Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack));
        }

        public boolean isIngredient(ItemStack ingredient) {
            ItemStack[] matchingStacks = this.ingredient.m_43908_();
            return matchingStacks.length == 0 ? ingredient.m_41619_() : Arrays.stream(matchingStacks).anyMatch(itemstack -> ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)ingredient));
        }
    }
}

