/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.functional;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class FourthTimesCharm
extends Perk {
    public FourthTimesCharm() {
        super("fourth_times_charm", Perk.Type.FUNCTIONAL);
    }

    @Override
    public void tick(GunData data, PerkInstance instance, @Nullable Entity entity) {
        data.perk.reduceCooldown(this, "FourthTimesCharmTick");
        CompoundTag tag = data.perk.getTag(this);
        int count = tag.m_128451_("FourthTimesCharmCount");
        if (count >= 4) {
            tag.m_128473_("FourthTimesCharmTick");
            tag.m_128473_("FourthTimesCharmCount");
            int mag = data.compute().magazine;
            if (mag > 0) {
                data.ammo.set(Math.min(mag, data.ammo.get() + 2));
            } else {
                data.virtualAmmo.add(2);
            }
        }
    }

    @Override
    public void onHurtEntity(float damage, GunData data, PerkInstance instance, Entity target, DamageSource source) {
        super.onHurtEntity(damage, data, instance, target, source);
        Entity entity = source.m_7640_();
        if (entity instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            float bypassArmorRate = projectile.getBypassArmorRate();
            if (bypassArmorRate >= 1.0f && source.m_276093_(ModDamageTypes.GUN_FIRE_HEADSHOT_ABSOLUTE)) {
                this.handleFourthTimesCharm(data, instance);
            } else if (source.m_276093_(ModDamageTypes.GUN_FIRE_HEADSHOT)) {
                this.handleFourthTimesCharm(data, instance);
            }
        }
    }

    public void handleFourthTimesCharm(GunData data, PerkInstance instance) {
        int fourthTimesCharmTick = data.perk.getTag(this).m_128451_("FourthTimesCharmTick");
        if (fourthTimesCharmTick <= 0) {
            data.perk.getTag(this).m_128405_("FourthTimesCharmTick", 40 + 10 * instance.level());
            data.perk.getTag(this).m_128405_("FourthTimesCharmCount", 1);
        } else {
            int count = data.perk.getTag(this).m_128451_("FourthTimesCharmCount");
            if (count < 4) {
                data.perk.getTag(this).m_128405_("FourthTimesCharmCount", Math.min(4, count + 1));
            }
        }
    }
}

