/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.ammo;

import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.world.entity.Entity;

public class PhasePenetratingBullet
extends AmmoPerk {
    public PhasePenetratingBullet() {
        super(new AmmoPerk.Builder("phase_penetrating_bullet", Perk.Type.AMMO).damageRate(0.2f).speedRate(1.5).rgb(255, 255, 255));
    }

    @Override
    public DefaultGunData computeProperties(GunData gunData, DefaultGunData rawData) {
        rawData.damage *= 0.2 + 0.04 * (double)gunData.perk.getLevel(this);
        return super.computeProperties(gunData, rawData);
    }

    @Override
    public void modifyProjectile(GunData data, PerkInstance instance, Entity entity) {
        super.modifyProjectile(data, instance, entity);
        if (!(entity instanceof ProjectileEntity)) {
            return;
        }
        ProjectileEntity projectile = (ProjectileEntity)entity;
        projectile.setPenetrating(true);
    }
}

