/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class VehicleFireMessage {
    @Nullable
    private final UUID uuid;
    @Nullable
    private final Vector3f targetPos;

    public VehicleFireMessage(@Nullable UUID uuid) {
        this.uuid = uuid;
        this.targetPos = null;
    }

    public VehicleFireMessage(@Nullable UUID uuid, @Nullable Vector3f targetPos) {
        this.uuid = uuid;
        this.targetPos = targetPos;
    }

    public static VehicleFireMessage decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_236860_(FriendlyByteBuf::m_130259_).orElse(null);
        boolean flag = buffer.readBoolean();
        if (flag) {
            return new VehicleFireMessage(uuid, buffer.m_269394_());
        }
        return new VehicleFireMessage(uuid);
    }

    public static void encode(VehicleFireMessage message, FriendlyByteBuf buffer) {
        buffer.m_236835_(Optional.ofNullable(message.uuid), FriendlyByteBuf::m_130077_);
        boolean flag = message.targetPos != null;
        buffer.writeBoolean(flag);
        if (flag) {
            buffer.m_269582_(message.targetPos);
        }
    }

    public static void handler(VehicleFireMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity patt1891$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt1891$temp = player.m_20202_()) instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)patt1891$temp;
                if (message.targetPos != null) {
                    vehicle.vehicleShoot((LivingEntity)player, message.uuid, new Vec3(message.targetPos));
                } else {
                    vehicle.vehicleShoot((LivingEntity)player, message.uuid, null);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

