/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientSetMotionMessage;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PlayerStopRidingMessage {
    private final boolean ejection;

    public PlayerStopRidingMessage(boolean ejection) {
        this.ejection = ejection;
    }

    public static PlayerStopRidingMessage decode(FriendlyByteBuf buffer) {
        return new PlayerStopRidingMessage(buffer.readBoolean());
    }

    public static void encode(PlayerStopRidingMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.ejection);
    }

    public static void handler(PlayerStopRidingMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Entity patt1807$temp = player.m_20202_();
            if (patt1807$temp instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)patt1807$temp;
                if (message.ejection) {
                    Vec3 vec = vehicle.getEjectionMovement((LivingEntity)player, vehicle.getTagSeatIndex((Entity)player));
                    Vec3 pos = vehicle.getEjectionPosition((LivingEntity)player, vehicle.getTagSeatIndex((Entity)player));
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.MEDIUM_ROCKET_FIRE.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
                    Level patt2288$temp = player.m_9236_();
                    if (patt2288$temp instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt2288$temp;
                        for (int p = 0; p < 8; ++p) {
                            Vec3 pPos = player.m_20182_().m_82549_(vec.m_82490_((double)p * 0.5));
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, 10, 0.5, 0.5, 0.5, 0.05, true);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123744_, pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, 20, 0.5, 0.5, 0.5, 0.05, true);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, pPos.f_82479_, pPos.f_82480_, pPos.f_82481_, 15, 0.5, 0.5, 0.5, 0.05, true);
                        }
                    }
                    Mod.queueServerWork(1, () -> NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientSetMotionMessage(vec, pos)));
                    player.m_8127_();
                    player.m_6862_(false);
                } else {
                    player.m_8127_();
                    player.m_6862_(false);
                }
                player.m_147207_(new MobEffectInstance((MobEffect)ModMobEffects.STRIKE_PROTECTION.get(), 10, 0, false, false), (Entity)player);
            }
        });
        context.setPacketHandled(true);
    }
}

