/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.client.screens.FuMO25ScreenHelper;
import com.atsuishio.superbwarfare.client.screens.VehicleAssemblingScreen;
import com.atsuishio.superbwarfare.config.client.KillMessageConfig;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.KillMessageHandler;
import com.atsuishio.superbwarfare.menu.EnergyMenu;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientSetMotionMessage;
import com.atsuishio.superbwarfare.network.message.receive.ContainerDataMessage;
import com.atsuishio.superbwarfare.network.message.receive.FinishAssemblingVehicleMessage;
import com.atsuishio.superbwarfare.network.message.receive.RadarMenuOpenMessage;
import com.atsuishio.superbwarfare.network.message.receive.SoundClientMessage;
import com.atsuishio.superbwarfare.network.message.receive.TDMSyncMessage;
import com.atsuishio.superbwarfare.tools.LivingKillRecord;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandler {
    public static void handleLivingKillMessage(LivingEntity attacker, Entity target, boolean headshot, ResourceKey<DamageType> damageType, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            if (KillMessageHandler.QUEUE.size() >= (Integer)KillMessageConfig.KILL_MESSAGE_COUNT.get()) {
                KillMessageHandler.QUEUE.poll();
            }
            KillMessageHandler.QUEUE.offer(new LivingKillRecord(attacker, target, attacker.m_21205_(), headshot, damageType));
        }
    }

    public static void handleClientIndicatorMessage(ClientIndicatorMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            switch (message.type) {
                case 1: {
                    CrossHairOverlay.headIndicator = message.value;
                    break;
                }
                case 2: {
                    CrossHairOverlay.killIndicator = message.value;
                    break;
                }
                case 3: {
                    CrossHairOverlay.vehicleIndicator = message.value;
                    break;
                }
                default: {
                    CrossHairOverlay.hitIndicator = message.value;
                }
            }
        }
    }

    public static void handleContainerDataMessage(int containerId, List<ContainerDataMessage.Pair> data, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91074_.f_36096_.f_38840_ == containerId) {
                data.forEach(p -> ((EnergyMenu)mc.f_91074_.f_36096_).setData(p.id, p.data));
            }
        }
    }

    public static void handleRadarMenuOpen(RadarMenuOpenMessage message, Supplier<NetworkEvent.Context> ctx) {
        FuMO25ScreenHelper.resetEntities();
        FuMO25ScreenHelper.pos = message.pos;
    }

    public static void handleRadarMenuClose() {
        FuMO25ScreenHelper.resetEntities();
        FuMO25ScreenHelper.pos = null;
    }

    public static void handleResetCameraType(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            Minecraft.m_91087_().f_91066_.m_92157_(Objects.requireNonNullElse(ClientEventHandler.lastCameraType, CameraType.FIRST_PERSON));
        }
    }

    public static void handleClientSyncMotion(ClientMotionSyncMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(message.id);
            if (entity != null) {
                entity.m_6001_((double)message.x, (double)message.y, (double)message.z);
            }
        }
    }

    public static void handleClientTacticalSprintSync(boolean flag, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            MiscConfig.ALLOW_TACTICAL_SPRINT.set((Object)flag);
            MiscConfig.ALLOW_TACTICAL_SPRINT.save();
        }
    }

    public static void handleClientSetMotion(ClientSetMotionMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                player.m_6034_(message.position().f_82479_, message.position().f_82480_, message.position().f_82481_);
                player.m_20334_(message.motion().f_82479_, message.motion().f_82480_, message.motion().f_82481_);
            }
        }
    }

    public static void handleFinishAssemblingVehicleMessage(FinishAssemblingVehicleMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return;
            }
            if (player.f_36096_.f_38840_ != message.containerId()) {
                return;
            }
            Screen screen = minecraft.f_91080_;
            if (screen instanceof VehicleAssemblingScreen) {
                VehicleAssemblingScreen screen2 = (VehicleAssemblingScreen)screen;
                screen2.finishAssembling();
            }
        }
    }

    public static void handleTDMSyncMessage(TDMSyncMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            ClientEventHandler.tdmSavedData = message.data();
        }
    }

    public static void handleSoundClient(SoundClientMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (player.m_20148_().equals(message.sender()) && (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle)) {
                return;
            }
            SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)message.location());
            double distance = player.m_20182_().m_82554_(new Vec3(message.x(), message.y(), message.z()));
            int time = (int)(distance / 17.0);
            if (time == 0) {
                player.m_9236_().m_6263_((Player)player, message.x(), message.y(), message.z(), sound, SoundSource.BLOCKS, message.radius(), message.pitch());
            } else {
                Mod.queueClientWork(time, () -> ClientPacketHandler.lambda$handleSoundClient$1((Player)player, message, sound));
            }
        }
    }

    private static /* synthetic */ void lambda$handleSoundClient$1(Player player, SoundClientMessage message, SoundEvent sound) {
        player.m_9236_().m_6263_(player, message.x(), message.y(), message.z(), sound, SoundSource.BLOCKS, message.radius(), message.pitch());
    }
}

