/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProjectileUtil.class})
public class ProjectileUtilMixin {
    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;F)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEntityHitResult(Level pLevel, Entity pProjectile, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, float pInflationAmount, CallbackInfoReturnable<EntityHitResult> cir) {
        for (Entity entity : pLevel.m_6249_(pProjectile, pBoundingBox.m_82400_(8.0), pFilter)) {
            Projectile projectile;
            OBBEntity obbEntity;
            Vector3d startVec = OBB.vec3ToVector3d(pStartVec);
            if (!(entity instanceof OBBEntity) || (obbEntity = (OBBEntity)entity).enableAABB() || pProjectile instanceof Projectile && ((projectile = (Projectile)pProjectile).m_19749_() == entity || entity.m_20197_().contains(projectile.m_19749_()))) continue;
            List<OBB> obbList = obbEntity.getOBBs();
            for (OBB obb : obbList) {
                Vector3d vec;
                double d1;
                obb = obb.inflate(entity.m_6143_() * 2.0f);
                Optional<Vector3d> optional = obb.clip(OBB.vec3ToVector3d(pStartVec), OBB.vec3ToVector3d(pEndVec));
                double pDistance = pStartVec.m_82557_(pEndVec);
                if (obb.contains(pStartVec)) {
                    if (!(pDistance >= 0.0)) continue;
                    EntityHitResult hitResult = new EntityHitResult(entity, OBB.vector3dToVec3(optional.orElse(startVec)));
                    OBBHitter acc = OBBHitter.getInstance(pProjectile);
                    acc.sbw$setCurrentHitPart(obb.part());
                    cir.setReturnValue((Object)hitResult);
                    if (pLevel instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)pLevel;
                        if (pProjectile.m_20184_().m_82556_() > 0.01 && pProjectile instanceof Projectile) {
                            Vec3 hitPos = hitResult.m_82450_();
                            pLevel.m_5594_(null, BlockPos.m_274446_((Position)hitPos), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.2, false);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.01, false);
                        }
                    }
                    return;
                }
                if (!optional.isPresent() || !((d1 = pStartVec.m_82557_(OBB.vector3dToVec3(vec = new Vector3d((Vector3dc)optional.get())))) < pDistance) && pDistance != 0.0) continue;
                EntityHitResult hitResult = new EntityHitResult(entity, OBB.vector3dToVec3(vec));
                OBBHitter acc = OBBHitter.getInstance(pProjectile);
                acc.sbw$setCurrentHitPart(obb.part());
                cir.setReturnValue((Object)hitResult);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)pLevel;
                    if (pProjectile.m_20184_().m_82556_() > 0.01 && pProjectile instanceof Projectile) {
                        Vec3 hitPos = hitResult.m_82450_();
                        pLevel.m_5594_(null, BlockPos.m_274446_((Position)hitPos), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.2, false);
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.01, false);
                    }
                }
                return;
            }
        }
    }

    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEntityHitResult(Entity pShooter, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, double pDistance, CallbackInfoReturnable<EntityHitResult> cir) {
        Level level = pShooter.m_9236_();
        List entities = level.m_6249_(pShooter, pBoundingBox.m_82400_(8.0), pFilter);
        Vector3d startVec = OBB.vec3ToVector3d(pStartVec);
        for (Entity entity : entities) {
            OBBEntity obbEntity;
            if (!(entity instanceof OBBEntity) || (obbEntity = (OBBEntity)entity).enableAABB() || entity.m_20197_().contains(pShooter)) continue;
            List<OBB> obbList = obbEntity.getOBBs();
            for (OBB obb : obbList) {
                Vector3d vec;
                double d1;
                obb = obb.inflate(entity.m_6143_() * 2.0f);
                Optional<Vector3d> optional = obb.clip(OBB.vec3ToVector3d(pStartVec), OBB.vec3ToVector3d(pEndVec));
                if (obb.contains(pStartVec)) {
                    if (!(pDistance >= 0.0)) continue;
                    cir.setReturnValue((Object)new EntityHitResult(entity, OBB.vector3dToVec3(optional.orElse(startVec))));
                    return;
                }
                if (!optional.isPresent() || !((d1 = pStartVec.m_82557_(OBB.vector3dToVec3(vec = new Vector3d((Vector3dc)optional.get())))) < pDistance) && pDistance != 0.0) continue;
                if (entity.m_20201_() == pShooter.m_20201_() && !entity.canRiderInteract()) {
                    if (pDistance != 0.0) continue;
                    cir.setReturnValue((Object)new EntityHitResult(entity, OBB.vector3dToVec3(vec)));
                    return;
                }
                cir.setReturnValue((Object)new EntityHitResult(entity, OBB.vector3dToVec3(vec)));
                return;
            }
        }
    }
}

