/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.SoundInfo;
import com.atsuishio.superbwarfare.entity.projectile.MortarShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.Monitor;
import com.atsuishio.superbwarfare.item.common.ammo.MortarShell;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MortarEntity
extends ArtilleryEntity {
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> TARGET_PITCH = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> TARGET_YAW = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> INTELLIGENT = SynchedEntityData.m_135353_(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private LivingEntity shooter = null;

    public MortarEntity(EntityType<MortarEntity> type, Level level) {
        super(type, level);
    }

    public MortarEntity(Level level, float yRot) {
        super((EntityType)ModEntities.MORTAR.get(), level);
        this.m_146922_(yRot);
        this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(yRot));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INTELLIGENT, (Object)false);
        this.f_19804_.m_135372_(TARGET_PITCH, (Object)Float.valueOf(-70.0f));
        this.f_19804_.m_135372_(TARGET_YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135372_(FIRE_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("TargetPitch", ((Float)this.f_19804_.m_135370_(TARGET_PITCH)).floatValue());
        compound.m_128350_("TargetYaw", ((Float)this.f_19804_.m_135370_(TARGET_YAW)).floatValue());
        compound.m_128379_("Intelligent", ((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TargetPitch")) {
            this.f_19804_.m_135381_(TARGET_PITCH, (Object)Float.valueOf(compound.m_128457_("TargetPitch")));
        }
        if (compound.m_128441_("TargetYaw")) {
            this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(compound.m_128457_("TargetYaw")));
        }
        if (compound.m_128441_("Intelligent")) {
            this.f_19804_.m_135381_(INTELLIGENT, (Object)compound.m_128471_("Intelligent"));
        }
    }

    @Override
    public void vehicleShoot(@Nullable LivingEntity living, String weaponName) {
        Level level;
        if (!(((ItemStack)this.items.get(0)).m_41720_() instanceof MortarShell)) {
            return;
        }
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return;
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) != 0) {
            return;
        }
        SoundInfo soundInfo = gunData.compute().soundInfo;
        this.shooter = living;
        this.f_19804_.m_135381_(FIRE_TIME, (Object)25);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundInfo.vehicleReload, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3P, this.m_20182_(), (float)(0.25 * gunData.compute().soundRadius), this.f_19796_.m_188501_() * 0.1f + 1.0f, null);
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3PFar, this.m_20182_(), (float)gunData.compute().soundRadius, this.f_19796_.m_188501_() * 0.1f + 1.0f, null);
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        InteractionResult result = super.m_6096_(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41720_() instanceof Monitor && !((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
            this.f_19804_.m_135381_(INTELLIGENT, (Object)true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (!player.m_7500_()) {
                mainHandItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.m_204117_(ModTags.Items.TOOLS_CROWBAR)) {
            if (((ItemStack)this.items.get(0)).m_41720_() instanceof MortarShell && (Integer)this.f_19804_.m_135370_(FIRE_TIME) == 0 && this.m_9236_() instanceof ServerLevel) {
                this.vehicleShoot((LivingEntity)player, "Main");
            }
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.m_41720_() instanceof MortarShell && !player.m_6144_() && (Integer)this.f_19804_.m_135370_(FIRE_TIME) == 0 && ((ItemStack)this.items.get(0)).m_41619_()) {
            this.items.set(0, (Object)mainHandItem.m_255036_(1));
            if (!player.m_7500_()) {
                mainHandItem.m_41774_(1);
            }
            this.vehicleShoot((LivingEntity)player, "Main");
            return InteractionResult.SUCCESS;
        }
        if (player.m_21205_().m_41720_() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.m_21205_(), (Entity)player, "Main");
        }
        if (player.m_21206_().m_41720_() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.m_21206_(), (Entity)player, "Main");
        }
        if (player.m_6144_()) {
            this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(player.m_146908_()));
        }
        return InteractionResult.FAIL;
    }

    @Override
    @NotNull
    public List<ItemStack> getRetrieveItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
        if (((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
            list.add(new ItemStack((ItemLike)ModItems.MONITOR.get()));
        }
        if (this.items.get(0) != ItemStack.f_41583_) {
            list.add((ItemStack)this.items.get(0));
        }
        return list;
    }

    protected float m_6380_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return 0.2f;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(FIRE_TIME) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) == 5 && ((ItemStack)this.items.get(0)).m_41720_() instanceof MortarShell) {
            Level level = this.m_9236_();
            GunData gunData = this.getGunData("Main");
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (gunData != null) {
                    MortarShellEntity entityToSpawn = MortarShell.createShell(this.shooter, level, (ItemStack)this.items.get(0), this.getProjectileGravity("Main"), (float)gunData.compute().damage, (float)gunData.compute().explosionDamage, (float)gunData.compute().explosionRadius);
                    entityToSpawn.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
                    entityToSpawn.m_6686_(this.m_20154_().f_82479_, this.m_20154_().f_82480_, this.m_20154_().f_82481_, this.getProjectileVelocity("Main"), this.getProjectileSpread("Main"));
                    level.m_7967_((Entity)entityToSpawn);
                    ParticleTool.spawnMediumCannonMuzzleParticles(this.m_20154_(), new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_()).m_82549_(this.m_20154_().m_82490_(1.5)), server, this);
                    this.m_6211_();
                    if (((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
                        this.resetTarget("Main");
                    }
                    gunData.shakePlayers(this);
                }
            }
        }
    }

    @Override
    public void setTarget(ItemStack stack, Entity entity, String weaponName) {
        double targetX = stack.m_41784_().m_128459_("TargetX");
        double targetY = stack.m_41784_().m_128459_("TargetY") - 1.0;
        double targetZ = stack.m_41784_().m_128459_("TargetZ");
        boolean canAim = true;
        this.f_19804_.m_135381_(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
        this.f_19804_.m_135381_(DEPRESSED, (Object)stack.m_41784_().m_128471_("IsDepressed"));
        this.f_19804_.m_135381_(RADIUS, (Object)stack.m_41784_().m_128451_("Radius"));
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        Vec3 launchVector2 = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.f_19804_.m_135370_(DEPRESSED) == false);
        MutableComponent component = Component.m_237113_((String)"");
        MutableComponent location = Component.m_237110_((String)"tips.superbwarfare.mortar.position", (Object[])new Object[]{this.m_5446_()}).m_7220_((Component)Component.m_237113_((String)(" X:" + FormatTool.format0D(this.m_20185_()) + " Y:" + FormatTool.format0D(this.m_20186_()) + " Z:" + FormatTool.format0D(this.m_20189_()) + " ")));
        float angle = this.m_146909_();
        if (launchVector == null || launchVector2 == null) {
            canAim = false;
            component = Component.m_237115_((String)"tips.superbwarfare.mortar.out_of_range");
        } else {
            angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
            float angle2 = (float)(-VehicleVecUtils.getXRotFromVector(launchVector2));
            if (angle < -this.getTurretMaxPitch() || angle > -this.getTurretMinPitch()) {
                if (angle2 > -this.getTurretMaxPitch() && angle2 < -this.getTurretMinPitch()) {
                    component = Component.m_237115_((String)"tips.superbwarfare.ballistics.warn2");
                    canAim = false;
                } else {
                    component = Component.m_237110_((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{this.m_5446_()});
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)location.m_6881_().m_7220_((Component)component).m_130940_(ChatFormatting.RED), false);
                    }
                    return;
                }
            }
            if (angle < -this.getTurretMaxPitch()) {
                component = Component.m_237115_((String)"tips.superbwarfare.ballistics.warn");
                canAim = false;
            }
        }
        if (canAim) {
            this.look(randomPos);
            this.f_19804_.m_135381_(TARGET_PITCH, (Object)Float.valueOf(angle));
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)location.m_6881_().m_7220_((Component)component).m_130940_(ChatFormatting.RED), false);
        }
    }

    @Override
    public void resetTarget(String weaponName) {
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.f_19804_.m_135370_(TARGET_POS)), (Integer)this.f_19804_.m_135370_(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.m_146892_(), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.f_19804_.m_135370_(DEPRESSED));
        this.look(randomPos);
        if (launchVector == null) {
            return;
        }
        float angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
        if (angle > -this.getTurretMaxPitch() && angle < -this.getTurretMinPitch()) {
            this.f_19804_.m_135381_(TARGET_PITCH, (Object)Float.valueOf(angle));
        }
    }

    public void look(Vec3 pTarget) {
        Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.m_90377_((Entity)this);
        double d0 = (pTarget.f_82479_ - vec3.f_82479_) * 0.2;
        double d2 = (pTarget.f_82481_ - vec3.f_82481_) * 0.2;
        this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
    }

    @Override
    public void travel() {
        float diffY = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(TARGET_YAW)).floatValue() - this.m_146908_()));
        float diffX = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(TARGET_PITCH)).floatValue() - this.m_146909_()));
        this.m_146922_(this.m_146908_() + Mth.m_14036_((float)(0.5f * diffY), (float)-20.0f, (float)20.0f));
        this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + Mth.m_14036_((float)(0.5f * diffX), (float)-20.0f, (float)20.0f)), (float)-89.0f, (float)-20.0f));
    }

    private PlayState movementPredicate(AnimationState<MortarEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.idle"));
    }

    @Override
    public void destroy() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            level2.m_254849_(null, x, y, z, 0.0f, Level.ExplosionInteraction.NONE);
            ItemEntity mortar = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
            mortar.m_32010_(10);
            level2.m_7967_((Entity)mortar);
            if (((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
                ItemEntity monitor = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MONITOR.get()));
                monitor.m_32010_(10);
                level2.m_7967_((Entity)monitor);
            }
        }
        super.destroy();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public void m_6596_() {
        if (!((Boolean)this.f_19804_.m_135370_(INTELLIGENT)).booleanValue()) {
            this.vehicleShoot(null, "Main");
        }
    }

    @Override
    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get());
    }

    @Override
    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        return super.m_7013_(slot, stack) && (Integer)this.f_19804_.m_135370_(FIRE_TIME) == 0 && stack.m_41720_() instanceof MortarShell;
    }

    @Override
    public boolean canBind() {
        return (Boolean)this.f_19804_.m_135370_(INTELLIGENT);
    }
}

