/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.MissileProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SwarmDroneEntity
extends MissileProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float randomFloat;

    public SwarmDroneEntity(EntityType<? extends SwarmDroneEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.explosionDamage = 80.0f;
        this.explosionRadius = 5.0f;
        this.randomFloat = this.f_19796_.m_188501_();
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        SwarmDroneEntity swarmDrone;
        Entity entity = source.m_7640_();
        if (entity instanceof SwarmDroneEntity && (swarmDrone = (SwarmDroneEntity)entity).m_19749_() == this.m_19749_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.SWARM_DRONE.get();
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        LivingEntity living;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof SwarmDroneEntity) {
            return;
        }
        if (this.m_19749_() != null && this.m_19749_().m_20202_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        Entity entity2 = this.m_19749_();
        if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
        }
    }

    @Override
    public void m_8119_() {
        Entity e2;
        super.m_8119_();
        Entity entity = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, 32.0, 90.0);
        for (Entity e2 : decoy) {
            if (!e2.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || this.distracted) continue;
            this.f_19804_.m_135381_(TARGET_UUID, (Object)e2.m_20149_());
            this.distracted = true;
            break;
        }
        if (this.f_19797_ == 1 && !this.m_9236_().m_5776_() && (e2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)e2;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.f_19854_, this.f_19855_, this.f_19856_, 15, 0.8, 0.8, 0.8, 0.01, true);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.f_19854_, this.f_19855_, this.f_19856_, 10, 0.8, 0.8, 0.8, 0.01, true);
        }
        if (this.f_19797_ > 10 && this.m_19749_() != null) {
            Vec3 targetPos;
            Entity shooter = this.m_19749_();
            if (this.guideType == 0 && entity != null) {
                Vec3 targetVec = new Vec3(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
                this.targetPos = targetPos = entity.m_146892_().m_82549_(targetVec);
            } else if (this.targetPos != null) {
                targetPos = this.targetPos;
            } else {
                BlockHitResult result = shooter.m_9236_().m_45547_(new ClipContext(shooter.m_146892_(), shooter.m_146892_().m_82549_(shooter.m_20154_().m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, shooter));
                targetPos = result.m_82450_();
            }
            if (this.f_19797_ % 5 == 0) {
                this.randomFloat = 2.0f * (this.f_19796_.m_188501_() - 0.5f);
            }
            double dis = this.m_20182_().m_82505_(shooter.m_20182_()).m_165924_();
            double dis2 = this.m_20182_().m_82557_(targetPos);
            double disShooter = shooter.m_20182_().m_82505_(targetPos).m_165924_();
            double randomPos = (double)Mth.m_14089_((float)((float)Mth.m_14008_((double)(dis / disShooter), (double)0.0, (double)1.0) * 1.5f * (float)Math.PI)) * dis * 4.0 * (double)this.randomFloat;
            Vec3 toVec = this.m_20182_().m_82505_(targetPos).m_82549_(new Vec3(-randomPos, (double)Mth.m_14154_((float)((float)randomPos)) * 0.02, randomPos).m_82490_(1.0 - Mth.m_14008_((double)(0.02 * (double)(this.f_19797_ - 20)), (double)0.0, (double)1.0))).m_82541_();
            this.turn(toVec, 90.0f);
            this.m_20256_(this.m_20184_().m_82549_(this.m_20182_().m_82505_(targetPos).m_82541_().m_82490_(0.1)));
            if (dis2 < 1.0) {
                if (this.m_9236_() instanceof ServerLevel) {
                    this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
                }
                this.m_146870_();
            }
            this.m_20256_(this.m_20184_().m_82542_(0.55, 0.55, 0.55));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.97, 0.97, 0.97));
        }
        if (this.f_19797_ > 13) {
            this.m_20256_(this.m_20184_().m_82549_(this.m_20154_()));
        }
        if (this.f_19797_ > 300 || this.m_20069_() || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeMissileExplode(ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.explosionDamage, this.explosionRadius);
            }
            this.m_146870_();
        }
    }

    public void causeMissileExplode(@Nullable DamageSource source, float damage, float radius) {
        new CustomExplosion.Builder((Entity)this).damageSource(source).damage(damage).radius(radius).damageMultiplier(1.25f).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
        this.m_146870_();
    }

    private PlayState movementPredicate(AnimationState<SwarmDroneEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.sd.fly"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.DRONE_ENGINE.get();
    }

    @Override
    public float getVolume() {
        return 0.6f;
    }

    @Override
    public float getMaxHealth() {
        return 4.0f;
    }

    public void setRotate(Vec3 vec3) {
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(-Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(-Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    @Override
    public void m_6686_(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
    }
}

