/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarShellEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int life = 600;
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.damage = 60.0f;
        this.explosionDamage = 100.0f;
        this.explosionRadius = 8.0f;
    }

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, double x, double y, double z, Level level, float gravity) {
        super(type, x, y, z, level);
        this.f_19811_ = true;
        this.damage = 60.0f;
        this.explosionDamage = 100.0f;
        this.explosionRadius = 8.0f;
        this.gravity = gravity;
    }

    public MortarShellEntity(LivingEntity entity, Level level, float damage, float explosionDamage, float explosionRadius) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MORTAR_SHELL.get()), (Entity)entity, level);
        this.f_19811_ = true;
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
    }

    public void setEffectsFromItem(ItemStack pStack) {
        if (pStack.m_150930_((Item)ModItems.POTION_MORTAR_SHELL.get())) {
            this.potion = PotionUtils.m_43579_((ItemStack)pStack);
            List collection = PotionUtils.m_43571_((ItemStack)pStack);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
        } else if (pStack.m_150930_((Item)ModItems.MORTAR_SHELL.get())) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Life", this.life);
        if (this.potion != Potions.f_43598_) {
            pCompound.m_128359_("Potion", ((Comparable)((Object)Objects.requireNonNullElse(ForgeRegistries.POTIONS.getKey((Object)this.potion), "empty"))).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            pCompound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.life = pCompound.m_128441_("Life") ? pCompound.m_128451_("Life") : 600;
        if (pCompound.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)pCompound);
        }
        this.effects.addAll(PotionUtils.m_43573_((CompoundTag)pCompound));
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.MORTAR_SHELL.get();
    }

    @Override
    public void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (this.f_19797_ > 1) {
            Entity entity = entityHitResult.m_82443_();
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeExplode(entityHitResult.m_82450_());
                this.createAreaCloud(this.m_9236_(), entityHitResult.m_82450_());
            }
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        Block block;
        float hardness;
        super.m_8060_(blockHitResult);
        BlockPos resultPos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        if (this.m_9236_() instanceof ServerLevel && ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue() && (hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_()) != -1.0f) {
            this.m_9236_().m_46961_(resultPos, true);
        }
        if ((block = state.m_60734_()) instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.m_49712_(this.m_9236_(), resultPos, blockHitResult.m_82434_());
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_() instanceof ServerLevel && this.f_19797_ > 1) {
            this.causeExplode(blockHitResult.m_82450_());
            this.createAreaCloud(this.m_9236_(), blockHitResult.m_82450_());
        }
        this.m_146870_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.mediumTrail();
        if (this.f_19797_ > this.life || this.m_20069_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                this.causeExplode(this.m_20182_());
                this.createAreaCloud(this.m_9236_(), this.m_20182_());
            }
            this.m_146870_();
        }
    }

    @Override
    public CustomExplosion.Builder buildExplosion(Vec3 vec3) {
        return super.buildExplosion(vec3).damageMultiplier(1.25f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void createAreaCloud(Level level, Vec3 pos) {
        if (this.potion == Potions.f_43598_) {
            return;
        }
        AreaEffectCloud cloud = new AreaEffectCloud(level, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        cloud.m_19722_(this.potion);
        cloud.m_19734_((int)this.explosionDamage);
        cloud.m_19712_(this.explosionRadius);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            cloud.m_19718_(living);
        }
        level.m_7967_((Entity)cloud);
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.06f;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }
}

