/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.MissileProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Kh39Entity
extends MissileProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Kh39Entity(EntityType<? extends Kh39Entity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.damage = 1100.0f;
        this.explosionDamage = 180.0f;
        this.explosionRadius = 12.0f;
        this.distracted = false;
        this.durability = 25;
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.LARGE_ANTI_GROUND_MISSILE.get();
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_(null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            this.causeExplode(result.m_82450_());
            this.m_146870_();
        }
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.m_82425_();
            float hardness = this.m_9236_().m_8055_(resultPos).m_60734_().m_155943_();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.m_82450_());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((Kh39Entity)this).m_146870_());
                    }
                    if (((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                        this.m_9236_().m_46961_(resultPos, true);
                    }
                }
            } else {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.m_82450_());
                this.m_146870_();
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.largeTrail();
        Entity entity = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, 32.0, 90.0);
        for (Entity e : decoy) {
            if (!e.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || this.distracted) continue;
            this.f_19804_.m_135381_(TARGET_UUID, (Object)e.m_20149_());
            this.distracted = true;
            break;
        }
        Vec3 toVec = this.m_20154_();
        if (this.guideType == 0) {
            if (!((String)this.f_19804_.m_135370_(TARGET_UUID)).equals("none") && entity != null && this.m_9236_() instanceof ServerLevel) {
                double dis;
                if ((!entity.m_20197_().isEmpty() || entity instanceof VehicleEntity) && entity.f_19797_ % (int)Math.max((double)(0.04 * (double)this.m_20270_(entity)), (double)2.0) == 0) {
                    entity.m_9236_().m_5594_(null, entity.m_20097_(), entity instanceof Pig ? SoundEvents.f_12235_ : (SoundEvent)ModSounds.MISSILE_WARNING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                double height = (dis = entity.m_20182_().m_82505_(this.m_20182_()).m_165924_()) > 30.0 ? 0.4 * (dis - 30.0) : 0.0;
                Vec3 targetPos = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)(entity instanceof EnderDragon ? -2 : 0) + height, entity.m_20189_());
                toVec = RangeTool.calculateFiringSolution(this.m_20182_(), targetPos, entity.m_20184_(), this.m_20184_().m_82553_(), 0.0);
            }
        } else if (this.m_9236_() instanceof ServerLevel) {
            double dis = this.targetPos.m_82505_(this.m_20182_()).m_165924_();
            double height = dis > 30.0 ? 0.4 * (dis - 30.0) : 0.0;
            Vec3 targetPos = this.targetPos.m_82520_(0.0, height, 0.0);
            toVec = RangeTool.calculateFiringSolution(this.m_20182_(), targetPos, Vec3.f_82478_, this.m_20184_().m_82553_(), 0.0);
        }
        if (this.f_19797_ > 8) {
            boolean lostTarget;
            this.m_20256_(this.m_20184_().m_82490_(0.05).m_82549_(this.m_20154_().m_82490_(8.0)));
            this.m_20256_(this.m_20184_().m_82542_(0.85, 0.85, 0.85));
            boolean bl = lostTarget = VectorTool.calculateAngle(this.m_20154_(), toVec) > 170.0;
            if (!lostTarget) {
                this.turn(toVec, Mth.m_14036_((float)((float)(this.f_19797_ - 8) * 0.5f), (float)0.0f, (float)15.0f));
            }
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.06, 0.0));
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.f_19797_ == 8) {
            Level level;
            this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)this.m_20182_()), (SoundEvent)ModSounds.MISSILE_START.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, this.f_19854_, this.f_19855_, this.f_19856_, 15, 0.8, 0.8, 0.8, 0.01, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123777_, this.f_19854_, this.f_19855_, this.f_19856_, 10, 0.8, 0.8, 0.8, 0.01, true);
            }
        }
        if (this.f_19797_ > 600 || this.m_20069_() || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            if (this.m_9236_() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode(this, ModDamageTypes.causeCustomExplosionDamage(this.m_9236_().m_9598_(), (Entity)this, this.m_19749_()), (Entity)this, this.explosionDamage, this.explosionRadius, 1.0f);
            }
            this.m_146870_();
        }
        this.destroyBlock();
    }

    private PlayState movementPredicate(AnimationState<Kh39Entity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    @Override
    public float m_7139_() {
        return this.f_19797_ < 8 ? 0.15f : super.m_7139_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.7f;
    }

    @Override
    public float getMaxHealth() {
        return 70.0f;
    }
}

