/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.goal;

import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.mob_guns.MobGunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.MillisTimer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class GunShootGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final MobGunData data;
    private int aimTime = 0;
    private final MillisTimer shootTimer = new MillisTimer();

    public GunShootGoal(T mob, MobGunData data) {
        this.mob = mob;
        this.data = data;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && this.mob.m_21205_().m_41720_() instanceof GunItem && this.data.getGunData() != null && (this.data.getGunData().countBackupAmmo((Entity)this.mob) > 0 || this.data.getGunData().hasEnoughAmmoToShoot((Entity)this.mob));
    }

    public boolean m_8045_() {
        return !(!this.m_8036_() && this.mob.m_21573_().m_26571_() || !(this.mob.m_21205_().m_41720_() instanceof GunItem) || this.data.getGunData() == null || this.data.getGunData().countBackupAmmo((Entity)this.mob) <= 0 && !this.data.getGunData().hasEnoughAmmoToShoot((Entity)this.mob));
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean canSeeTarget = this.mob.m_21574_().m_148306_((Entity)target);
        this.aimTime = canSeeTarget ? Math.min(this.data.aimTime(), this.aimTime + 1) : (this.data.clearAimTimeWhenLostSight() ? 0 : --this.aimTime);
        this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
        if (distance > this.data.shootDistance()) {
            this.mob.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.mob.m_21573_().m_26573_();
        }
        GunData gunData = GunData.from(this.mob.m_21205_());
        gunData.tick((Entity)this.mob, true);
        if (gunData.shouldStartReloading((Entity)this.mob)) {
            gunData.startReload();
        }
        if (gunData.shouldStartBolt()) {
            gunData.startBolt();
        }
        if (gunData.canShoot((Entity)this.mob) && this.aimTime >= this.data.aimTime()) {
            double rps = (double)gunData.compute().rpm / 60.0;
            long cooldown = Math.round(1000.0 / rps);
            FireMode fireMode = gunData.selectedFireModeInfo().mode;
            if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST && gunData.burstAmount.get() == 0) {
                cooldown += this.data.semiFireInterval();
            }
            if (!this.shootTimer.started()) {
                this.shootTimer.start();
                this.shootTimer.setProgress(cooldown + 1L);
            }
            if (this.shootTimer.getProgress() >= cooldown) {
                long newProgress = this.shootTimer.getProgress();
                do {
                    gunData.shoot((Entity)this.mob, this.data.spread(), this.data.zoom(), target.m_20148_());
                } while ((newProgress -= cooldown) - cooldown > 0L);
                this.shootTimer.setProgress(newProgress);
            }
        } else {
            this.shootTimer.stop();
        }
    }
}

