/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.PropertyModifier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class JsonPropertyModifier<DATA extends DefaultDataSupplier<DEFAULT_DATA>, DEFAULT_DATA>
implements PropertyModifier<DATA, DEFAULT_DATA> {
    private JsonObject obj;
    private String str;

    public void update(JsonObject object) {
        this.obj = object;
        this.str = null;
    }

    public void update(String string) {
        if (string == null || string.isEmpty() || string.equals(this.str)) {
            return;
        }
        this.str = string;
        try {
            this.update((JsonObject)DataLoader.GSON.fromJson(string, JsonObject.class));
        }
        catch (Exception exception) {
            Mod.LOGGER.error("Failed to parse string prop modifier: {}", (Object)string, (Object)exception);
        }
    }

    @Override
    public DEFAULT_DATA computeProperties(DATA data, DEFAULT_DATA rawData) {
        if (this.obj == null || this.obj.size() == 0) {
            return rawData;
        }
        JsonObject dataJson = DataLoader.GSON.toJsonTree(rawData).getAsJsonObject();
        for (Map.Entry entry : this.obj.entrySet()) {
            dataJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return (DEFAULT_DATA)DataLoader.GSON.fromJson((JsonElement)dataJson, rawData.getClass());
    }
}

