/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.sound;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class VehicleSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final VehicleEntity mobileVehicle;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public VehicleSoundInstance(SoundEvent sound, Minecraft client, VehicleEntity mobileVehicle) {
        super(sound, SoundSource.AMBIENT, mobileVehicle.m_20193_().m_213780_());
        this.client = client;
        this.mobileVehicle = mobileVehicle;
        this.f_119578_ = true;
        this.f_119579_ = 0;
    }

    protected abstract boolean canPlay(VehicleEntity var1);

    protected abstract float getPitch(VehicleEntity var1);

    protected abstract float getVolume(VehicleEntity var1);

    public void m_7788_() {
        DroneEntity drone;
        LocalPlayer player = this.client.f_91074_;
        if (this.mobileVehicle.m_213877_() || player == null) {
            this.m_119609_();
            return;
        }
        if (!this.canPlay(this.mobileVehicle)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.m_119609_();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.f_119573_ = this.getVolume(this.mobileVehicle) * (float)this.fade;
        this.f_119575_ = this.mobileVehicle.m_20185_();
        this.f_119576_ = this.mobileVehicle.m_20186_();
        this.f_119577_ = this.mobileVehicle.m_20189_();
        this.f_119574_ = this.getPitch(this.mobileVehicle);
        if (player.m_20202_() != this.mobileVehicle) {
            double distance = this.mobileVehicle.m_20182_().m_82546_(player.m_20182_()).m_82553_();
            this.f_119574_ += (float)(0.16 * Math.atan(this.lastDistance - distance));
            this.lastDistance = distance;
        } else {
            this.lastDistance = 0.0;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && this.mobileVehicle == (drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone")))) {
            this.f_119574_ = 1.0f;
        }
    }

    public static class SwimSound
    extends VehicleSoundInstance {
        public SwimSound(VehicleEntity mobileVehicle) {
            super((SoundEvent)ModSounds.VEHICLE_SWIM.get(), Minecraft.m_91087_(), mobileVehicle);
        }

        @Override
        protected boolean canPlay(VehicleEntity mobileVehicle) {
            return mobileVehicle.engineRunning() && mobileVehicle.m_20069_();
        }

        @Override
        protected float getPitch(VehicleEntity mobileVehicle) {
            return 1.0f;
        }

        @Override
        protected float getVolume(VehicleEntity mobileVehicle) {
            return (float)Mth.m_14139_((double)Mth.m_14008_((double)(mobileVehicle.m_20184_().m_165924_() * (mobileVehicle.m_20069_() ? 1.2 : 0.0)), (double)0.0, (double)0.6f), (double)0.0, (double)0.6f);
        }
    }

    public static class TrackSound
    extends VehicleSoundInstance {
        public TrackSound(VehicleEntity mobileVehicle) {
            super((SoundEvent)ModSounds.TRACK_VEHICLE_STEP.get(), Minecraft.m_91087_(), mobileVehicle);
        }

        @Override
        protected boolean canPlay(VehicleEntity mobileVehicle) {
            return mobileVehicle.engineRunning();
        }

        @Override
        protected float getPitch(VehicleEntity mobileVehicle) {
            return 1.0f;
        }

        @Override
        protected float getVolume(VehicleEntity mobileVehicle) {
            return (float)Mth.m_14139_((double)Mth.m_14008_((double)mobileVehicle.m_20184_().m_82553_(), (double)0.0, (double)0.3f), (double)0.0, (double)0.3f) * (mobileVehicle.m_20096_() ? 1.0f : 0.5f);
        }
    }

    public static class EngineSound
    extends VehicleSoundInstance {
        public EngineSound(VehicleEntity mobileVehicle) {
            super(mobileVehicle.getEngineSound(), Minecraft.m_91087_(), mobileVehicle);
        }

        @Override
        protected boolean canPlay(VehicleEntity mobileVehicle) {
            return mobileVehicle.engineRunning();
        }

        @Override
        protected float getPitch(VehicleEntity mobileVehicle) {
            return 1.0f;
        }

        @Override
        protected float getVolume(VehicleEntity mobileVehicle) {
            return mobileVehicle.getEngineSoundVolume();
        }
    }
}

