/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.sound;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class HornSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final VehicleEntity entity;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public HornSoundInstance(SoundEvent sound, Minecraft client, VehicleEntity entity) {
        super(sound, SoundSource.PLAYERS, entity.m_20193_().m_213780_());
        this.client = client;
        this.entity = entity;
        this.f_119578_ = true;
        this.f_119579_ = 0;
    }

    protected abstract boolean canPlay(VehicleEntity var1);

    protected abstract float getPitch(VehicleEntity var1);

    protected abstract float getVolume(VehicleEntity var1);

    public void m_7788_() {
        LocalPlayer player = this.client.f_91074_;
        if (this.entity.m_213877_() || player == null) {
            this.m_119609_();
            return;
        }
        if (!this.canPlay(this.entity)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.m_119609_();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.f_119573_ = this.getVolume(this.entity) * (float)this.fade;
        this.f_119575_ = this.entity.m_20185_();
        this.f_119576_ = this.entity.m_20186_();
        this.f_119577_ = this.entity.m_20189_();
        this.f_119574_ = this.getPitch(this.entity);
        if (player.m_20202_() != this.entity) {
            double distance = this.entity.m_20182_().m_82546_(player.m_20182_()).m_82553_();
            this.f_119574_ += (float)(0.1 * Math.atan(this.lastDistance - distance));
            this.lastDistance = distance;
        } else {
            this.lastDistance = 0.0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VehicleHornSound
    extends HornSoundInstance {
        public VehicleHornSound(VehicleEntity entity) {
            super(entity.getHornSound(), Minecraft.m_91087_(), entity);
        }

        @Override
        protected boolean canPlay(VehicleEntity entity) {
            return entity.hornWorking();
        }

        @Override
        protected float getPitch(VehicleEntity entity) {
            return 1.0f;
        }

        @Override
        protected float getVolume(VehicleEntity entity) {
            return ((Float)entity.m_20088_().m_135370_(VehicleEntity.HORN_VOLUME)).floatValue();
        }
    }
}

