/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public abstract class VehicleRenderer<T extends VehicleEntity>
extends GeoEntityRenderer<T> {
    public VehicleRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> model) {
        super(renderManager, model);
    }

    public RenderType getRenderType(T vehicle, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)vehicle));
    }

    public void preRender(PoseStack poseStack, T vehicle, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, vehicle, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(@NotNull T entityIn, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        this.vehicleAxis(entityIn, poseStack, entityYaw, partialTicks);
        super.m_7392_(entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        this.renderCustomPart(entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.m_85849_();
    }

    public void vehicleAxis(T entityIn, PoseStack poseStack, float entityYaw, float partialTicks) {
        Vec3 root = new Vec3(0.0, ((VehicleEntity)entityIn).getRotateOffsetHeight(), 0.0);
        poseStack.m_272245_(Axis.f_252436_.m_252977_(-entityYaw), (float)root.f_82479_, (float)root.f_82480_, (float)root.f_82481_);
        poseStack.m_272245_(Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((VehicleEntity)entityIn).f_19860_, (float)entityIn.m_146909_())), (float)root.f_82479_, (float)root.f_82480_, (float)root.f_82481_);
        poseStack.m_272245_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((VehicleEntity)entityIn).prevRoll, (float)((VehicleEntity)entityIn).getRoll())), (float)root.f_82479_, (float)root.f_82480_, (float)root.f_82481_);
    }

    public void renderCustomPart(T entityIn, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
    }

    public boolean shouldRender(T vehicle, @NotNull Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        if (!vehicle.m_6000_(pCamX, pCamY, pCamZ)) {
            return false;
        }
        if (((VehicleEntity)vehicle).f_19811_) {
            return true;
        }
        AABB aabb = vehicle.m_6921_().m_82400_(5.0);
        if (aabb.m_82392_() || aabb.m_82309_() == 0.0) {
            aabb = new AABB(vehicle.m_20185_() - 8.0, vehicle.m_20186_() - 6.0, vehicle.m_20189_() - 8.0, vehicle.m_20185_() + 8.0, vehicle.m_20186_() + 6.0, vehicle.m_20189_() + 8.0);
        }
        return pCamera.m_113029_(aabb);
    }
}

