/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.entity.AbstractLaserEntityRenderer;
import com.atsuishio.superbwarfare.entity.projectile.LaserEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class LaserEntityRenderer
extends AbstractLaserEntityRenderer<LaserEntity> {
    private boolean playerView;
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    public static final ResourceLocation TEXTURE = Mod.loc("textures/entity/temp_laser.png");

    public LaserEntityRenderer(EntityRendererProvider.Context context) {
        super(context, 0.8f, 0.6f);
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull LaserEntity entity) {
        return TEXTURE;
    }

    @Override
    public void render(LaserEntity beam, float entityYaw, float delta, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        this.playerView = beam.caster instanceof Player && Minecraft.m_91087_().f_91074_ == beam.caster && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        super.render(beam, entityYaw, delta, matrixStackIn, bufferIn, packedLightIn);
    }

    @Override
    protected void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn, boolean inGround) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        float size = 0.25f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        this.drawVertex(matrix4f, matrix3f, builder, -size, -size, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -size, size, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, size, size, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, size, -size, 0.0f, maxU, minV, packedLightIn);
    }

    @Override
    protected void renderStart(LaserEntity laser, int frame, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        if (this.playerView) {
            return;
        }
        super.renderStart(laser, frame, matrixStackIn, builder, delta, packedLightIn);
    }

    @Override
    protected void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        float offset = this.playerView ? -1.0f : 0.0f;
        float size = 0.2f;
        this.drawVertex(matrix4f, matrix3f, builder, -size, offset, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -size, length, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, size, length, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, size, offset, 0.0f, maxU, minV, packedLightIn);
    }
}

