/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay.weapon;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleMainWeaponHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class LandVehicleHud {
    public static final String ID = "@Land";
    private static final ResourceLocation COMPASS = Mod.loc("textures/overlay/vehicle/base/compass.png");
    private static final ResourceLocation ROLL_IND = Mod.loc("textures/overlay/vehicle/helicopter/roll_ind.png");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/vehicle/land/tv_frame.png");
    private static final ResourceLocation LINE = Mod.loc("textures/overlay/vehicle/land/line.png");
    private static final ResourceLocation BARREL = Mod.loc("textures/overlay/vehicle/land/line.png");
    private static final ResourceLocation BODY = Mod.loc("textures/overlay/vehicle/land/body.png");
    private static final ResourceLocation LEFT_WHEEL = Mod.loc("textures/overlay/vehicle/land/left_wheel.png");
    private static final ResourceLocation RIGHT_WHEEL = Mod.loc("textures/overlay/vehicle/land/right_wheel.png");
    private static final ResourceLocation ENGINE = Mod.loc("textures/overlay/vehicle/land/engine.png");
    public static float lerpRecoil;

    public static void render(VehicleEntity vehicle, Player player, ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        if (vehicle.getSeatIndex((Entity)player) != vehicle.computed().turretControllerIndex) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        Vec3 viewVec = new Vec3(camera.m_253058_());
        int color = vehicle.getHudColor();
        poseStack.m_85836_();
        float recoil = Mth.m_14179_((float)partialTick, (float)((float)vehicle.recoilShakeO), (float)((float)vehicle.getRecoilShake()));
        lerpRecoil = Mth.m_14179_((float)(0.1f * partialTick), (float)lerpRecoil, (float)(recoil * (float)(2.0 * (Math.random() - 0.5))));
        poseStack.m_252880_(lerpRecoil * 6.0f + (float)screenWidth * 0.025f * recoil, recoil * 3.0f + (float)screenHeight * 0.025f * recoil, 0.0f);
        poseStack.m_85841_(1.0f - recoil * 0.05f, 1.0f - recoil * 0.05f, 1.0f);
        poseStack.m_272245_(Axis.f_252403_.m_252977_(-0.3f * ClientEventHandler.cameraRoll + 2.5f * lerpRecoil), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
            int addW = screenWidth / screenHeight * 48;
            int addH = screenWidth / screenHeight * 27;
            RenderHelper.preciseBlit(guiGraphics, FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, screenWidth + addW, screenHeight + addH, screenWidth + addW, screenHeight + addH);
            RenderHelper.blit(poseStack, LINE, (float)screenWidth / 2.0f - 64.0f, (float)(screenHeight - 56), 0.0f, 0.0f, 128.0f, 1.0f, 128.0f, 1.0f, color);
            RenderHelper.blit(poseStack, COMPASS, (float)screenWidth / 2.0f - 128.0f, 10.0f, 128.0f + 1.4222223f * player.m_146908_(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f, color);
            RenderHelper.blit(poseStack, ROLL_IND, (float)screenWidth / 2.0f - 8.0f, 30.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
            int turretHeal = (int)(100.0f - 100.0f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.TURRET_HEALTH)).floatValue() / vehicle.getTurretMaxHealth());
            RenderHelper.blit(poseStack, BARREL, (float)screenWidth / 2.0f + 112.0f, (float)(screenHeight - 71), 0.0f, 0.0f, 1.0f, 16.0f, 1.0f, 16.0f, MathTool.getGradientColor(color, 0xFF0000, turretHeal, 2));
            poseStack.m_85836_();
            poseStack.m_272245_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTick, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot())), (float)screenWidth / 2.0f + 112.0f, (float)(screenHeight - 56), 0.0f);
            int bodyHeal = (int)(100.0f - 100.0f * vehicle.getHealth() / vehicle.getMaxHealth());
            RenderHelper.blit(poseStack, BODY, (float)screenWidth / 2.0f + 96.0f, (float)(screenHeight - 72), 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, bodyHeal, 2));
            int leftWheelHeal = (int)(100.0f - 100.0f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.L_WHEEL_HEALTH)).floatValue() / vehicle.getWheelMaxHealth());
            RenderHelper.blit(poseStack, LEFT_WHEEL, (float)screenWidth / 2.0f + 96.0f, (float)(screenHeight - 72), 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, leftWheelHeal, 2));
            int rightWheelHeal = (int)(100.0f - 100.0f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.R_WHEEL_HEALTH)).floatValue() / vehicle.getWheelMaxHealth());
            RenderHelper.blit(poseStack, RIGHT_WHEEL, (float)screenWidth / 2.0f + 96.0f, (float)(screenHeight - 72), 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, rightWheelHeal, 2));
            int engineHeal = (int)(100.0f - 100.0f * ((Float)vehicle.m_20088_().m_135370_(VehicleEntity.MAIN_ENGINE_HEALTH)).floatValue() / vehicle.getEngineMaxHealth());
            RenderHelper.blit(poseStack, ENGINE, (float)screenWidth / 2.0f + 96.0f, (float)(screenHeight - 72), 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, engineHeal, 2));
            poseStack.m_85849_();
            guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(vehicle.m_20184_().m_82526_(vehicle.m_20252_(partialTick)) * 72.0, " km/h")), screenWidth / 2 + 160, screenHeight / 2 - 48, color, false);
            VehicleMainWeaponHudOverlay.renderEnergyInfo(vehicle, guiGraphics, screenWidth, screenHeight, mc.f_91062_);
            boolean lookAtEntity = false;
            BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(player.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 hitPos = result.m_82450_();
            double blockRange = player.m_20299_(1.0f).m_82554_(hitPos);
            double entityRange = 0.0;
            Entity lookingEntity = TraceTool.camerafFindLookingEntity(player, cameraPos, viewVec, 512.0);
            if (lookingEntity != null) {
                lookAtEntity = true;
                entityRange = player.m_20270_(lookingEntity);
            }
            if (lookAtEntity) {
                width = Minecraft.m_91087_().f_91062_.m_92895_(FormatTool.format0D(entityRange, " m"));
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(entityRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
            } else if (blockRange > 500.0) {
                width = Minecraft.m_91087_().f_91062_.m_92895_("---m");
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"---m"), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
            } else {
                width = Minecraft.m_91087_().f_91062_.m_92895_(FormatTool.format0D(blockRange, " m"));
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(blockRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
            }
            int heal = (int)(100.0f - 100.0f * vehicle.getHealth() / vehicle.getMaxHealth());
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(100 - heal)), screenWidth / 2 - 165, screenHeight / 2 - 46, MathTool.getGradientColor(color, 0xFF0000, bodyHeal, 2), false);
            if (vehicle.hasDecoy() && player == vehicle.m_146895_()) {
                if (vehicle.getDecoyState().equals("READY")) {
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.smoke.ready").m_7220_((Component)Component.m_237113_((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().m_84875_().getString() + "]"))), screenWidth / 2 - 165, screenHeight / 2 - 36, color, false);
                } else {
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.smoke.reloading"), screenWidth / 2 - 165, screenHeight / 2 - 36, 0xFF0000, false);
                }
            }
            VehicleMainWeaponHudOverlay.renderWeaponInfoFirst(guiGraphics, vehicle, player, vehicle.getGunData((Entity)player), mc.f_91062_, screenWidth, screenHeight, color);
        }
        poseStack.m_85849_();
    }
}

