/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimableEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class VehicleTeamOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_vehicle_team";

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        boolean outOfRange;
        Entity decoy;
        if (!((Boolean)DisplayConfig.VEHICLE_INFO.get()).booleanValue()) {
            return;
        }
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        Vec3 viewVec = new Vec3(camera.m_253058_());
        PoseStack poseStack = guiGraphics.m_280168_();
        ItemStack stack = player.m_21205_();
        boolean lookAtEntity = false;
        double entityRange = 0.0;
        Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, cameraPos, viewVec, ((Integer)VehicleConfig.VEHICLE_INFO_DISPLAY_DISTANCE.get()).intValue());
        Entity entity = player.m_20202_();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            lookingEntity = vehicle.getPlayerLookAtEntityOnVehicle((Entity)player, 512.0, partialTick);
            viewVec = vehicle.getViewVec((Entity)player, partialTick);
        }
        if ((decoy = TraceTool.findLookDecoy((Player)player, cameraPos, viewVec, 512.0)) != null && decoy.m_6095_().m_204039_(ModTags.EntityTypes.DECOY)) {
            return;
        }
        if (lookingEntity instanceof SmokeDecoyEntity) {
            return;
        }
        if (lookingEntity != null) {
            lookAtEntity = true;
            entityRange = player.m_20270_(lookingEntity);
        }
        boolean usingDrone = stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked");
        boolean bl = outOfRange = entityRange > (double)((Integer)VehicleConfig.VEHICLE_INFO_DISPLAY_DISTANCE.get()).intValue();
        if (lookAtEntity && lookingEntity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)lookingEntity;
            if (!usingDrone && !outOfRange) {
                Font font;
                if (entityRange > (double)((Integer)VehicleConfig.VEHICLE_INFO_DISPLAY_DISTANCE.get()).intValue()) {
                    return;
                }
                Vec3 pos = VectorTool.lerpGetEntityBoundingBoxCenter(lookingEntity, partialTick).m_82549_(new Vec3(0.0, (double)(lookingEntity.m_20206_() / 2.0f) + 0.5, 0.0));
                Vec3 centerPos = VectorTool.lerpGetEntityBoundingBoxCenter(lookingEntity, partialTick);
                if (VectorUtil.canSee(pos)) {
                    Object info;
                    Vec3 point = VectorUtil.worldToScreen(pos);
                    float x = (float)point.f_82479_;
                    float y = (float)point.f_82480_;
                    poseStack.m_85836_();
                    poseStack.m_252880_(x, y - 12.0f, 0.0f);
                    float size = (float)Mth.m_14008_((double)(50.0 / VectorUtil.fov * (double)0.9f * Math.max((512.0 - entityRange) / 512.0, 0.1)), (double)0.4, (double)1.0);
                    poseStack.m_85841_(size, size, size);
                    font = gui.getMinecraft().f_91062_;
                    int color = -1;
                    if (vehicle instanceof DroneEntity) {
                        DroneEntity drone = (DroneEntity)vehicle;
                        Player controller = EntityFindUtil.findPlayer(drone.m_9236_(), (String)drone.m_20088_().m_135370_(DroneEntity.CONTROLLER));
                        if (controller != null) {
                            color = controller.m_19876_();
                            team = player.m_5647_();
                            if (team instanceof PlayerTeam) {
                                playerTeam = (PlayerTeam)team;
                                String info2 = vehicle.m_5446_().getString() + " " + controller.m_5446_().getString() + (String)(controller.m_5647_() == null ? "" : " <" + playerTeam.m_83364_().getString() + ">");
                                guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)info2), -font.m_92895_(info2) / 2, -13, color, false);
                            }
                        } else {
                            info = lookingEntity.m_5446_().getString();
                            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)info), -font.m_92895_((String)info) / 2, -13, color, false);
                        }
                    } else if (vehicle instanceof OwnableEntity) {
                        OwnableEntity ownableEntity = (OwnableEntity)vehicle;
                        info = ownableEntity.m_269323_();
                        if (info instanceof Player) {
                            player1 = (Player)info;
                            color = player1.m_19876_();
                            team = player.m_5647_();
                            if (team instanceof PlayerTeam) {
                                playerTeam = (PlayerTeam)team;
                                String info3 = vehicle.m_5446_().getString() + " " + player1.m_5446_().getString() + (String)(player1.m_5647_() == null ? "" : " <" + playerTeam.m_83364_().getString() + ">");
                                guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)info3), -font.m_92895_(info3) / 2, -13, color, false);
                            }
                        } else {
                            info = lookingEntity.m_5446_().getString();
                            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)info), -font.m_92895_((String)info) / 2, -13, color, false);
                        }
                    } else if (vehicle.getMaxPassengers() > 0 && (info = vehicle.m_146895_()) instanceof Player) {
                        player1 = (Player)info;
                        color = player1.m_19876_();
                        team = player.m_5647_();
                        if (team instanceof PlayerTeam) {
                            playerTeam = (PlayerTeam)team;
                            String info4 = vehicle.m_5446_().getString() + " " + player1.m_5446_().getString() + (String)(player1.m_5647_() == null ? "" : " <" + playerTeam.m_83364_().getString() + ">");
                            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)info4), -font.m_92895_(info4) / 2, -13, color, false);
                        }
                    } else {
                        info = vehicle.m_5446_().getString();
                        guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)info), -font.m_92895_((String)info) / 2, -13, color, false);
                    }
                    String range = FormatTool.format1D(entityRange, "M");
                    int argb = 0xFF000000 | color;
                    guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)range), -font.m_92895_(range) / 2, 7, color, false);
                    RenderHelper.fill(guiGraphics, RenderType.m_286086_(), -40.5f, -2.0f, 40.5f, 2.0f, 0.0f, Integer.MIN_VALUE);
                    RenderHelper.fill(guiGraphics, RenderType.m_286086_(), -41.5f, -3.0f, -40.5f, 3.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.m_286086_(), -40.5f, -3.0f, 40.5f, -2.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.m_286086_(), -40.5f, 2.0f, 40.5f, 3.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.m_286086_(), 40.5f, -3.0f, 41.5f, 3.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.m_286086_(), -40.0f, -1.5f, -40.0f + 80.0f * (vehicle.getHealth() / vehicle.getMaxHealth()), 1.5f, 0.0f, argb);
                    poseStack.m_85849_();
                }
                if (vehicle instanceof AutoAimableEntity) {
                    AutoAimableEntity autoAimableEntity = (AutoAimableEntity)vehicle;
                    if (VectorUtil.canSee(centerPos) && player.m_20270_((Entity)autoAimableEntity) < 4.0f) {
                        Vec3 point = VectorUtil.worldToScreen(centerPos);
                        float x = (float)point.f_82479_;
                        float y = (float)point.f_82480_;
                        poseStack.m_85836_();
                        poseStack.m_252880_(x, y - 12.0f, 0.0f);
                        font = gui.getMinecraft().f_91062_;
                        LivingEntity entity2 = autoAimableEntity.m_269323_();
                        if (entity2 != null) {
                            int color = autoAimableEntity.m_269323_().m_19876_();
                            boolean active = (Boolean)autoAimableEntity.m_20088_().m_135370_(AutoAimableEntity.ACTIVE);
                            String info = active ? "tips.superbwarfare.auto_aimable_entity.active" : "tips.superbwarfare.auto_aimable_entity.inactive";
                            MutableComponent component = Component.m_237115_((String)info);
                            guiGraphics.m_280614_(font, (Component)component, -font.m_92852_((FormattedText)component) / 2, -5, color, false);
                            MutableComponent ownerInfo = Component.m_237113_((String)("[" + entity2.m_5446_().getString() + "]"));
                            guiGraphics.m_280614_(font, (Component)ownerInfo, -font.m_92852_((FormattedText)ownerInfo) / 2, 5, color, false);
                        }
                        poseStack.m_85849_();
                    }
                }
            }
        }
    }
}

