/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.compat.realcamera.RealCameraCompatHolder;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.Ah6Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.resource.gun.GunResource;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class CrossHairOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_cross_hair";
    public static final String CROSSHAIR_EMPTY = "@Empty";
    public static final String CROSSHAIR_CUSTOM = "@Custom";
    public static final String CROSSHAIR_GUN_DEFAULT = "@GunDefault";
    public static final String CROSSHAIR_GUN_REPAIR_TOOL = "@GunRepairTool";
    public static final String CROSSHAIR_GUN_BOCEK = "@GunBocek";
    public static final String CROSSHAIR_GUN_GRENADE = "@GunGrenade";
    private static final ResourceLocation REX = Mod.loc("textures/overlay/crosshair/rex.png");
    private static final ResourceLocation REX_HORIZONTAL = Mod.loc("textures/overlay/crosshair/rex_horizontal.png");
    private static final ResourceLocation REX_VERTICAL = Mod.loc("textures/overlay/crosshair/rex_vertical.png");
    private static final ResourceLocation POINT = Mod.loc("textures/overlay/crosshair/point.png");
    private static final ResourceLocation SHOTGUN = Mod.loc("textures/overlay/crosshair/rex_circle.png");
    private static final ResourceLocation HIT_MARKER = Mod.loc("textures/overlay/crosshair/hit_marker.png");
    private static final ResourceLocation HIT_MARKER_VEHICLE = Mod.loc("textures/overlay/crosshair/hit_marker_vehicle.png");
    private static final ResourceLocation HEADSHOT_MARKER = Mod.loc("textures/overlay/crosshair/headshot_marker.png");
    private static final ResourceLocation KILL_MARKER_1 = Mod.loc("textures/overlay/crosshair/kill_marker_1.png");
    private static final ResourceLocation KILL_MARKER_2 = Mod.loc("textures/overlay/crosshair/kill_marker_2.png");
    private static final ResourceLocation KILL_MARKER_3 = Mod.loc("textures/overlay/crosshair/kill_marker_3.png");
    private static final ResourceLocation KILL_MARKER_4 = Mod.loc("textures/overlay/crosshair/kill_marker_4.png");
    public static int hitIndicator = 0;
    public static int headIndicator = 0;
    public static int killIndicator = 0;
    public static int vehicleIndicator = 0;
    private static float scopeScale = 1.0f;
    public static float gunRot;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Ah6Entity ah6Entity;
        Entity entity;
        VehicleEntity vehicle;
        Entity entity2;
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (ClientEventHandler.isEditing) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem) || (entity2 = player.m_20202_()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity2).banHand((LivingEntity)player)) {
            return;
        }
        GunData data = GunData.from(stack);
        String crosshair = data.compute().crosshair;
        if (crosshair.equals(CROSSHAIR_EMPTY) || crosshair.equals(CROSSHAIR_CUSTOM)) {
            return;
        }
        double spread = ClientEventHandler.gunSpread + 1.0 * ClientEventHandler.firePos;
        float deltaFrame = Minecraft.m_91087_().m_91297_();
        float moveX = 0.0f;
        float moveY = 0.0f;
        if (((Boolean)DisplayConfig.FLOAT_CROSS_HAIR.get()).booleanValue() && player.m_20202_() == null) {
            moveX = (float)(-6.0 * ClientEventHandler.turnRot[1] - (double)(player.m_20142_() ? 10 : 6) * ClientEventHandler.movePosX);
            moveY = (float)(-6.0 * ClientEventHandler.turnRot[0] + (double)(6.0f * (float)ClientEventHandler.velocityY) - (double)(player.m_20142_() ? 10 : 6) * ClientEventHandler.movePosY - 0.25 * ClientEventHandler.firePos);
            if (RealCameraCompatHolder.hasMod()) {
                moveX = RealCameraCompatHolder.getCompatMoveX(moveX);
                moveY = RealCameraCompatHolder.getCompatMoveY(moveY);
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        scopeScale = (float)Mth.m_14139_((double)(0.5f * deltaFrame), (double)scopeScale, (double)(1.0 + 1.5 * spread));
        float minLength = Math.min(screenWidth, screenHeight);
        float scaledMinLength = Math.min((float)screenWidth / minLength, (float)screenHeight / minLength) * 0.012f * scopeScale;
        float finLength = Mth.m_14143_((float)(minLength * scaledMinLength));
        float finPosX = ((float)screenWidth - finLength) / 2.0f + moveX;
        float finPosY = ((float)screenHeight - finLength) / 2.0f + moveY;
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            switch (crosshair) {
                case "@GunDefault": {
                    CrossHairOverlay.renderGunDefaultCrosshair(guiGraphics, stack, (Player)player, screenWidth, screenHeight, moveX, moveY, finPosX, finPosY, finLength, spread);
                    break;
                }
                case "@GunRepairTool": {
                    CrossHairOverlay.renderRepairToolCrosshair(guiGraphics, data, (Player)player, screenWidth, screenHeight, moveX, moveY);
                    break;
                }
                case "@GunBocek": {
                    CrossHairOverlay.renderBocekCrosshair(guiGraphics, data, (Player)player, screenWidth, screenHeight, moveX, moveY, finPosX, finPosY, finLength, spread);
                    break;
                }
                case "@GunGrenade": {
                    CrossHairOverlay.renderGrenadeCrosshair(guiGraphics, stack, screenWidth, screenHeight);
                }
            }
        }
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK && (ClientEventHandler.zoomTime > 0.0 || ClientEventHandler.bowPullPos > 0.0)) {
            CrossHairOverlay.renderGunDefaultCrosshair(guiGraphics, stack, (Player)player, screenWidth, screenHeight, moveX, moveY, finPosX, finPosY, finLength, spread);
        }
        if (((Boolean)DisplayConfig.KILL_INDICATION.get()).booleanValue() && (!((entity = player.m_20202_()) instanceof Ah6Entity) || (ah6Entity = (Ah6Entity)entity).m_146895_() != player)) {
            CrossHairOverlay.renderKillIndicatorDynamic(guiGraphics, screenWidth, screenHeight, moveX, moveY);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void normalCrossHair(GuiGraphics guiGraphics, int w, int h, double spread, float moveX, float moveY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_272245_(Axis.f_252403_.m_252977_(-gunRot * 57.295776f), (float)w / 2.0f + moveX, (float)h / 2.0f + moveY, 0.0f);
        RenderHelper.preciseBlit(guiGraphics, REX_HORIZONTAL, (float)((double)((float)w / 2.0f - 13.5f) - (double)2.8f * spread) + moveX, (float)h / 2.0f - 7.5f + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        RenderHelper.preciseBlit(guiGraphics, REX_HORIZONTAL, (float)((double)((float)w / 2.0f - 2.5f) + (double)2.8f * spread) + moveX, (float)h / 2.0f - 7.5f + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        RenderHelper.preciseBlit(guiGraphics, REX_VERTICAL, (float)w / 2.0f - 7.5f + moveX, (float)((double)((float)h / 2.0f - 2.5f) + (double)2.8f * spread) + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        RenderHelper.preciseBlit(guiGraphics, REX_VERTICAL, (float)w / 2.0f - 7.5f + moveX, (float)((double)((float)h / 2.0f - 13.5f) - (double)2.8f * spread) + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        poseStack.m_85849_();
    }

    public static void shotgunCrossHair(GuiGraphics guiGraphics, float finPosX, float finPosY, float finLength) {
        RenderHelper.preciseBlit(guiGraphics, SHOTGUN, finPosX, finPosY, 0.0f, 0.0f, finLength, finLength, finLength, finLength);
    }

    public static void renderGunDefaultCrosshair(GuiGraphics guiGraphics, ItemStack stack, Player player, int screenWidth, int screenHeight, float moveX, float moveY, float finPosX, float finPosY, float finLength, double spread) {
        GunData data = GunData.from(stack);
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON && ClientEventHandler.zoomTime > 0.8 && GunResource.compute((ItemStack)stack).hideCrosshairWhenZoom) {
            return;
        }
        RenderHelper.preciseBlit(guiGraphics, POINT, (float)screenWidth / 2.0f - 7.5f + moveX, (float)screenHeight / 2.0f - 7.5f + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        if (!player.m_20142_() || ClientEventHandler.noSprintTicks > 0.0f) {
            if (data.compute().projectileAmount > 1) {
                CrossHairOverlay.shotgunCrossHair(guiGraphics, finPosX, finPosY, finLength);
            } else {
                CrossHairOverlay.normalCrossHair(guiGraphics, screenWidth, screenHeight, spread, moveX, moveY);
            }
        }
    }

    public static void renderRepairToolCrosshair(GuiGraphics guiGraphics, GunData data, Player player, int screenWidth, int screenHeight, float moveX, float moveY) {
        int range = data.compute().range;
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, range);
        float health = 0.0f;
        if (lookingEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)lookingEntity;
            health = living.m_21223_() / living.m_21233_();
        } else if (lookingEntity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)lookingEntity;
            health = vehicle.getHealth() / vehicle.getMaxHealth();
        }
        RenderHelper.preciseBlit(guiGraphics, POINT, (float)screenWidth / 2.0f - 7.5f + moveX, (float)screenHeight / 2.0f - 7.5f + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        if (health > 0.0f) {
            RenderHelper.renderCircularRing(guiGraphics, (float)screenWidth / 2.0f + moveX, (float)screenHeight / 2.0f + moveY, 0.035f, 0.028f, new float[]{0.0f, 0.0f, 0.0f, 0.4f}, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, health, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void renderBocekCrosshair(GuiGraphics guiGraphics, GunData data, Player player, int screenWidth, int screenHeight, float moveX, float moveY, float finPosX, float finPosY, float finLength, double spread) {
        if (ClientEventHandler.zoomPos >= 0.7) {
            return;
        }
        Perk perk = data.perk.get(Perk.Type.AMMO);
        RenderHelper.preciseBlit(guiGraphics, POINT, (float)screenWidth / 2.0f - 7.5f + moveX, (float)screenHeight / 2.0f - 7.5f + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        if (player.m_20142_() && !(ClientEventHandler.noSprintTicks > 0.0f)) {
            if (!(ClientEventHandler.bowPullPos > 0.0)) return;
        }
        if (!(ClientEventHandler.zoomTime < 0.1)) {
            CrossHairOverlay.normalCrossHair(guiGraphics, screenWidth, screenHeight, spread, moveX, moveY);
            return;
        }
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                CrossHairOverlay.normalCrossHair(guiGraphics, screenWidth, screenHeight, spread, moveX, moveY);
                return;
            }
        }
        CrossHairOverlay.shotgunCrossHair(guiGraphics, finPosX, finPosY, finLength);
    }

    public static void renderGrenadeCrosshair(GuiGraphics guiGraphics, ItemStack stack, int screenWidth, int screenHeight) {
        if (ClientEventHandler.zoomTime > 0.8 && GunResource.compute((ItemStack)stack).hideCrosshairWhenZoom) {
            return;
        }
        guiGraphics.m_280163_(REX, screenWidth / 2 - 16, screenHeight / 2 - 16, 0.0f, 0.0f, 32, 32, 32, 32);
    }

    private static void renderKillIndicatorDynamic(GuiGraphics guiGraphics, int w, int h, float moveX, float moveY) {
        float posX = (float)w / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float posY = (float)h / 2.0f - 7.5f + (float)(2.0 * (Math.random() - 0.5));
        float rate = (float)(40 - killIndicator * 5) / 5.5f;
        if (hitIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HIT_MARKER, posX + moveX, posY + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (vehicleIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HIT_MARKER_VEHICLE, posX + moveX, posY + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (headIndicator > 0) {
            RenderHelper.preciseBlit(guiGraphics, HEADSHOT_MARKER, posX + moveX, posY + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
        if (killIndicator > 0) {
            float posX1 = (float)w / 2.0f - 7.5f - 2.0f + rate + moveX;
            float posY1 = (float)h / 2.0f - 7.5f - 2.0f + rate + moveY;
            float posX2 = (float)w / 2.0f - 7.5f + 2.0f - rate + moveX;
            float posY2 = (float)h / 2.0f - 7.5f + 2.0f - rate + moveY;
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_1, posX1, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_2, posX2, posY1, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_3, posX1, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, KILL_MARKER_4, posX2, posY2, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
        }
    }

    public static void handleRenderDamageIndicator() {
        headIndicator = Math.max(0, headIndicator - 1);
        hitIndicator = Math.max(0, hitIndicator - 1);
        killIndicator = Math.max(0, killIndicator - 1);
        vehicleIndicator = Math.max(0, vehicleIndicator - 1);
    }
}

