/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class RenderHelper {
    private static long GUI_RENDER_TIMESTAMP = -1L;

    public static void markGuiRenderTimestamp() {
        GUI_RENDER_TIMESTAMP = System.currentTimeMillis();
    }

    public static boolean isInGui() {
        return System.currentTimeMillis() - GUI_RENDER_TIMESTAMP < 100L;
    }

    public static void preciseBlit(GuiGraphics gui, ResourceLocation pAtlasLocation, float pX, float pY, float pUOffset, float pVOffset, float pWidth, float pHeight, float pTextureWidth, float pTextureHeight) {
        RenderHelper.preciseBlit(gui, pAtlasLocation, pX, pY, 0.0f, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight);
    }

    public static void preciseBlit(GuiGraphics gui, ResourceLocation pAtlasLocation, float pX, float pY, float pBlitOffset, float pUOffset, float pVOffset, float pWidth, float pHeight, float pTextureWidth, float pTextureHeight) {
        float pX2 = pX + pWidth;
        float pY2 = pY + pHeight;
        float pMinU = pUOffset / pTextureWidth;
        float pMaxU = (pUOffset + pWidth) / pTextureWidth;
        float pMinV = pVOffset / pTextureHeight;
        float pMaxV = (pVOffset + pHeight) / pTextureHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = gui.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, pX, pY, pBlitOffset).m_7421_(pMinU, pMinV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX, pY2, pBlitOffset).m_7421_(pMinU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY2, pBlitOffset).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, pX2, pY, pBlitOffset).m_7421_(pMaxU, pMinV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void blit(PoseStack pose, ResourceLocation pAtlasLocation, float pX, float pY, float pUOffset, float pVOffset, float pWidth, float pHeight, float pTextureWidth, float pTextureHeight, int color) {
        RenderHelper.blit(pose, pAtlasLocation, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight, color);
    }

    public static void blit(PoseStack pose, ResourceLocation pAtlasLocation, float pX, float pY, float pWidth, float pHeight, float pUOffset, float pVOffset, float pUWidth, float pVHeight, float pTextureWidth, float pTextureHeight, int color) {
        RenderHelper.blit(pose, pAtlasLocation, pX, pX + pWidth, pY, pY + pHeight, 0.0f, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight, color);
    }

    public static void blit(PoseStack pose, ResourceLocation pAtlasLocation, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pUWidth, float pVHeight, float pUOffset, float pVOffset, float pTextureWidth, float pTextureHeight, int color) {
        RenderHelper.innerBlit(pose, pAtlasLocation, pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / pTextureWidth, (pUOffset + pUWidth) / pTextureWidth, (pVOffset + 0.0f) / pTextureHeight, (pVOffset + pVHeight) / pTextureHeight, color);
    }

    public static void blit(PoseStack pose, ResourceLocation pAtlasLocation, float pX, float pY, float pUOffset, float pVOffset, float pWidth, float pHeight, float pTextureWidth, float pTextureHeight, float alpha, boolean opposite) {
        RenderHelper.blit(pose, pAtlasLocation, pX, pY, pWidth, pHeight, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight, alpha, opposite);
    }

    public static void blit(PoseStack pose, ResourceLocation pAtlasLocation, float pX, float pY, float pUOffset, float pVOffset, float pWidth, float pHeight, float pTextureWidth, float pTextureHeight, float alpha) {
        RenderHelper.blit(pose, pAtlasLocation, pX, pY, pUOffset, pVOffset, pWidth, pHeight, pTextureWidth, pTextureHeight, alpha, false);
    }

    public static void blit(PoseStack pose, ResourceLocation pAtlasLocation, float pX, float pY, float pWidth, float pHeight, float pUOffset, float pVOffset, float pUWidth, float pVHeight, float pTextureWidth, float pTextureHeight, float alpha, boolean opposite) {
        RenderHelper.blit(pose, pAtlasLocation, pX, pX + pWidth, pY, pY + pHeight, 0.0f, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight, alpha, opposite);
    }

    public static void blit(PoseStack pose, ResourceLocation pAtlasLocation, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pUWidth, float pVHeight, float pUOffset, float pVOffset, float pTextureWidth, float pTextureHeight, float alpha, boolean opposite) {
        RenderHelper.innerBlit(pose, pAtlasLocation, pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / pTextureWidth, (pUOffset + pUWidth) / pTextureWidth, (pVOffset + 0.0f) / pTextureHeight, (pVOffset + pVHeight) / pTextureHeight, alpha, opposite);
    }

    private static void innerBlit(PoseStack pose, ResourceLocation pAtlasLocation, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, int color) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::m_172814_);
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        RenderHelper.vertexC(pX1, pX2, pY1, pY2, pBlitOffset, pMinU, pMaxU, pMinV, pMaxV, color, matrix4f, bufferbuilder);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private static void innerBlit(PoseStack pose, ResourceLocation pAtlasLocation, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, float alpha, boolean opposite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        if (opposite) {
            RenderHelper.vertex(pX1, pX2, pY1, pY2, pBlitOffset, pMaxU, pMinU, pMinV, pMaxV, alpha, matrix4f, bufferbuilder);
        } else {
            RenderHelper.vertex(pX1, pX2, pY1, pY2, pBlitOffset, pMinU, pMaxU, pMinV, pMaxV, alpha, matrix4f, bufferbuilder);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    private static void vertex(float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, float alpha, Matrix4f matrix4f, BufferBuilder bufferBuilder) {
        bufferBuilder.m_252986_(matrix4f, pX1, pY1, pBlitOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(pMinU, pMinV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, pX1, pY2, pBlitOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(pMinU, pMaxV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, pX2, pY2, pBlitOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, pX2, pY1, pBlitOffset).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(pMaxU, pMinV).m_5752_();
    }

    private static void vertexC(float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV, int color, Matrix4f matrix4f, BufferBuilder bufferBuilder) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        bufferBuilder.m_252986_(matrix4f, pX1, pY1, pBlitOffset).m_85950_(r, g, b, 1.0f).m_7421_(pMinU, pMinV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, pX1, pY2, pBlitOffset).m_85950_(r, g, b, 1.0f).m_7421_(pMinU, pMaxV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, pX2, pY2, pBlitOffset).m_85950_(r, g, b, 1.0f).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, pX2, pY1, pBlitOffset).m_85950_(r, g, b, 1.0f).m_7421_(pMaxU, pMinV).m_5752_();
    }

    public static void fill(GuiGraphics guiGraphics, RenderType pRenderType, float pMinX, float pMinY, float pMaxX, float pMaxY, float pZ, int pColor) {
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        if (pMinX < pMaxX) {
            float i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            float j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        float f3 = (float)FastColor.ARGB32.m_13655_((int)pColor) / 255.0f;
        float f = (float)FastColor.ARGB32.m_13665_((int)pColor) / 255.0f;
        float f1 = (float)FastColor.ARGB32.m_13667_((int)pColor) / 255.0f;
        float f2 = (float)FastColor.ARGB32.m_13669_((int)pColor) / 255.0f;
        VertexConsumer vertexconsumer = guiGraphics.m_280091_().m_6299_(pRenderType);
        vertexconsumer.m_252986_(matrix4f, pMinX, pMinY, pZ).m_85950_(f, f1, f2, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, pMinX, pMaxY, pZ).m_85950_(f, f1, f2, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, pMaxX, pMaxY, pZ).m_85950_(f, f1, f2, f3).m_5752_();
        vertexconsumer.m_252986_(matrix4f, pMaxX, pMinY, pZ).m_85950_(f, f1, f2, f3).m_5752_();
        guiGraphics.m_280262_();
    }

    public static void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, Component pText, float scale, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor) {
        int borderWidth;
        int width = pFont.m_92852_((FormattedText)pText);
        if (width > (borderWidth = pMaxX - pMinX)) {
            int l = width - borderWidth;
            double rate = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * rate / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            pGuiGraphics.m_280588_((int)((float)pMinX * scale), (int)((float)pMinY * scale), (int)((float)pMaxX * scale), (int)((float)pMaxY * scale));
            pGuiGraphics.m_280430_(pFont, pText, pMinX - (int)d3, pMinY, pColor);
            pGuiGraphics.m_280618_();
        } else {
            pGuiGraphics.m_280430_(pFont, pText, pMinX, pMinY, pColor);
        }
    }

    public static void renderCircularRing(GuiGraphics guiGraphics, float centerX, float centerY, float outerRadius, float innerRadius, float[] backgroundColor, float[] progressColor, float progress, boolean useRate) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172808_);
        poseStack.m_272245_(Axis.f_252403_.m_252977_(-90.0f), centerX, centerY, 0.0f);
        Window window = Minecraft.m_91087_().m_91268_();
        float scale = useRate ? (float)Math.min(window.m_85445_(), window.m_85446_()) : 1.0f;
        RenderHelper.drawCircularRing(poseStack, centerX, centerY, outerRadius * scale, innerRadius * scale, backgroundColor, 1.0f);
        RenderHelper.drawCircularRing(poseStack, centerX, centerY, outerRadius * scale, innerRadius * scale, progressColor, progress);
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    public static void drawCircularRing(PoseStack poseStack, float centerX, float centerY, float outerRadius, float innerRadius, float[] color, float progressAngle) {
        poseStack.m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float angleStep = (float)Math.PI / 90;
        float maxAngle = (float)(Math.PI * 2 * (double)progressAngle);
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85814_);
        int i = 0;
        while ((float)i <= 180.0f * progressAngle) {
            float angle = (float)i * angleStep;
            if (angle > maxAngle) {
                angle = maxAngle;
            }
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float outerX = centerX + outerRadius * cos;
            float outerY = centerY + outerRadius * sin;
            buffer.m_252986_(matrix, outerX, outerY, 0.0f).m_5752_();
            float innerX = centerX + innerRadius * cos;
            float innerY = centerY + innerRadius * sin;
            buffer.m_252986_(matrix, innerX, innerY, 0.0f).m_5752_();
            if (angle >= maxAngle) break;
            ++i;
        }
        tesselator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }
}

