/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.animation.AnimationCurves;
import com.atsuishio.superbwarfare.client.decorator.ContainerItemDecorator;
import com.atsuishio.superbwarfare.client.decorator.LuckyContainerItemDecorator;
import com.atsuishio.superbwarfare.client.model.curio.ParachuteModel;
import com.atsuishio.superbwarfare.client.overlay.AmmoBarOverlay;
import com.atsuishio.superbwarfare.client.overlay.AmmoCountOverlay;
import com.atsuishio.superbwarfare.client.overlay.ArmorPlateOverlay;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.client.overlay.DroneHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.HandsomeFrameOverlay;
import com.atsuishio.superbwarfare.client.overlay.HeatBarOverlay;
import com.atsuishio.superbwarfare.client.overlay.IFFOverlay;
import com.atsuishio.superbwarfare.client.overlay.IglaHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.ItemRendererFixOverlay;
import com.atsuishio.superbwarfare.client.overlay.JavelinHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.KillMessageOverlay;
import com.atsuishio.superbwarfare.client.overlay.MortarInfoOverlay;
import com.atsuishio.superbwarfare.client.overlay.RedTriangleOverlay;
import com.atsuishio.superbwarfare.client.overlay.SpyglassRangeOverlay;
import com.atsuishio.superbwarfare.client.overlay.StaminaOverlay;
import com.atsuishio.superbwarfare.client.overlay.TowOverlay;
import com.atsuishio.superbwarfare.client.overlay.Type63InfoOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleCrosshairOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleMainWeaponHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleTeamOverlay;
import com.atsuishio.superbwarfare.client.renderer.block.ChargingStationBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.ContainerBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.FuMO25BlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.LuckyContainerBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.SmallContainerBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.VehicleAssemblingTableBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.curio.ParachuteRenderer;
import com.atsuishio.superbwarfare.client.tooltip.ClientBocekImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientCellImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientChargingStationImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientDogTagImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientGunImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientSentinelImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.BocekImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.CellImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.ChargingStationImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.DogTagImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.SentinelImageComponent;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRenderHandler {
    public static Vec3 bulletRenderOffset = null;

    public static void transformVirtualRenderPosition(PoseStack stack, Projectile projectile, float partialTick) {
        if (bulletRenderOffset == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || projectile.m_19749_() == null || !player.m_20148_().equals(projectile.m_19749_().m_20148_())) {
            return;
        }
        double rate = 1.0 - AnimationCurves.EASE_OUT_CIRC.apply(Math.min(1.0, (double)((float)projectile.f_19797_ + partialTick) / 5.0));
        Vec3 offset = bulletRenderOffset.m_82546_(projectile.m_20182_()).m_82542_(rate, rate, rate);
        stack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    @SubscribeEvent
    public static void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(GunImageComponent.class, ClientGunImageTooltip::new);
        event.register(BocekImageComponent.class, ClientBocekImageTooltip::new);
        event.register(CellImageComponent.class, ClientCellImageTooltip::new);
        event.register(SentinelImageComponent.class, ClientSentinelImageTooltip::new);
        event.register(ChargingStationImageComponent.class, ClientChargingStationImageTooltip::new);
        event.register(DogTagImageComponent.class, ClientDogTagImageTooltip::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.CONTAINER.get(), context -> new ContainerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.FUMO_25.get(), context -> new FuMO25BlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.CHARGING_STATION.get(), context -> new ChargingStationBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SMALL_CONTAINER.get(), context -> new SmallContainerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.LUCKY_CONTAINER.get(), context -> new LuckyContainerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.VEHICLE_ASSEMBLING_TABLE.get(), context -> new VehicleAssemblingTableBlockEntityRenderer());
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("superbwarfare_kill_message", (IGuiOverlay)new KillMessageOverlay());
        event.registerBelow(Mod.loc("superbwarfare_kill_message"), "superbwarfare_armor_plate", (IGuiOverlay)new ArmorPlateOverlay());
        event.registerBelow(Mod.loc("superbwarfare_armor_plate"), "superbwarfare_ammo_bar", (IGuiOverlay)new AmmoBarOverlay());
        event.registerBelow(Mod.loc("superbwarfare_ammo_bar"), "superbwarfare_iff", (IGuiOverlay)new IFFOverlay());
        event.registerBelow(Mod.loc("superbwarfare_iff"), "superbwarfare_vehicle_team", (IGuiOverlay)new VehicleTeamOverlay());
        event.registerBelow(Mod.loc("superbwarfare_vehicle_team"), "superbwarfare_javelin_hud", (IGuiOverlay)new JavelinHudOverlay());
        event.registerBelow(Mod.loc("superbwarfare_javelin_hud"), "superbwarfare_igla_9k38_hud", (IGuiOverlay)new IglaHudOverlay());
        event.registerBelow(Mod.loc("superbwarfare_igla_9k38_hud"), "superbwarfare_vehicle_hud", (IGuiOverlay)new VehicleHudOverlay());
        event.registerBelow(Mod.loc("superbwarfare_vehicle_hud"), "superbwarfare_vehicle_main_weapon_hud", (IGuiOverlay)new VehicleMainWeaponHudOverlay());
        event.registerBelow(Mod.loc("superbwarfare_vehicle_main_weapon_hud"), "superbwarfare_vehicle_crosshair", (IGuiOverlay)new VehicleCrosshairOverlay());
        event.registerBelowAll("superbwarfare_stamina", (IGuiOverlay)new StaminaOverlay());
        event.registerBelowAll("superbwarfare_ammo_count", (IGuiOverlay)new AmmoCountOverlay());
        event.registerBelowAll("superbwarfare_item_renderer_fix", (IGuiOverlay)new ItemRendererFixOverlay());
        event.registerBelowAll("superbwarfare_cross_hair", (IGuiOverlay)new CrossHairOverlay());
        event.registerBelowAll("superbwarfare_heat_bar", (IGuiOverlay)new HeatBarOverlay());
        event.registerBelowAll("superbwarfare_drone_hud", (IGuiOverlay)new DroneHudOverlay());
        event.registerBelowAll("superbwarfare_red_triangle", (IGuiOverlay)new RedTriangleOverlay());
        event.registerBelowAll("superbwarfare_handsome_frame", (IGuiOverlay)new HandsomeFrameOverlay());
        event.registerBelowAll("superbwarfare_spyglass_range", (IGuiOverlay)new SpyglassRangeOverlay());
        event.registerBelowAll("superbwarfare_tow", (IGuiOverlay)new TowOverlay());
        event.registerBelowAll("superbwarfare_mortar_info", (IGuiOverlay)new MortarInfoOverlay());
        event.registerBelowAll("superbwarfare_type_63_info", (IGuiOverlay)new Type63InfoOverlay());
    }

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        event.register((ItemLike)ModItems.CONTAINER.get(), (IItemDecorator)new ContainerItemDecorator());
        event.register((ItemLike)ModItems.LUCKY_CONTAINER.get(), (IItemDecorator)new LuckyContainerItemDecorator());
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        CuriosRendererRegistry.register((Item)((Item)ModItems.PARACHUTE.get()), ParachuteRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ParachuteModel.LAYER_LOCATION, ParachuteModel::createBodyLayer);
    }
}

