/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability.player;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.ModCapabilities;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.PlayerVariablesSyncMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;

@AutoRegisterCapability
public class PlayerVariable
implements INBTSerializable<CompoundTag> {
    public static ResourceLocation ID = Mod.loc("player_variables");
    private PlayerVariable old = null;
    public Map<Ammo, Integer> ammo = new HashMap<Ammo, Integer>();
    public boolean tacticalSprint = false;

    public void sync(Entity entity) {
        if (!entity.getCapability(ModCapabilities.PLAYER_VARIABLE).isPresent()) {
            return;
        }
        PlayerVariable newVariable = PlayerVariable.getOrDefault(entity);
        if (this.old != null && this.old.equals(newVariable)) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PlayerVariablesSyncMessage(entity.m_19879_(), this.compareAndUpdate()));
        }
    }

    public static PlayerVariable getOrDefault(Entity entity) {
        return (PlayerVariable)entity.getCapability(ModCapabilities.PLAYER_VARIABLE).orElse((Object)new PlayerVariable());
    }

    public static void modify(Entity entity, Consumer<PlayerVariable> consumer) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        PlayerVariable cap = (PlayerVariable)entity.getCapability(ModCapabilities.PLAYER_VARIABLE).orElse((Object)new PlayerVariable());
        cap.watch();
        consumer.accept(cap);
        cap.sync(entity);
    }

    public PlayerVariable watch() {
        this.old = this.copy();
        return this;
    }

    public Map<Byte, Integer> forceUpdate() {
        HashMap<Byte, Integer> map = new HashMap<Byte, Integer>();
        for (Ammo type : Ammo.values()) {
            map.put((byte)type.ordinal(), type.get(this));
        }
        map.put((byte)-1, this.tacticalSprint ? 1 : 0);
        return map;
    }

    public Map<Byte, Integer> compareAndUpdate() {
        HashMap<Byte, Integer> map = new HashMap<Byte, Integer>();
        PlayerVariable old = this.old == null ? new PlayerVariable() : this.old;
        for (Ammo type : Ammo.values()) {
            Integer oldCount = old.ammo.getOrDefault((Object)type, 0);
            int newCount = type.get(this);
            if (oldCount == newCount) continue;
            map.put((byte)type.ordinal(), newCount);
        }
        if (old.tacticalSprint != this.tacticalSprint) {
            map.put((byte)-1, this.tacticalSprint ? 1 : 0);
        }
        return map;
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Ammo type : Ammo.values()) {
            type.set(nbt, type.get(this));
        }
        nbt.m_128379_("TacticalSprint", this.tacticalSprint);
        return nbt;
    }

    public void readFromNBT(CompoundTag tag) {
        for (Ammo type : Ammo.values()) {
            type.set(this, type.get(tag));
        }
        this.tacticalSprint = tag.m_128471_("TacticalSprint");
    }

    public PlayerVariable copy() {
        PlayerVariable clone = new PlayerVariable();
        for (Ammo type : Ammo.values()) {
            type.set(clone, type.get(this));
        }
        clone.tacticalSprint = this.tacticalSprint;
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerVariable)) {
            return false;
        }
        PlayerVariable other = (PlayerVariable)obj;
        for (Ammo type : Ammo.values()) {
            if (type.get(this) == type.get(other)) continue;
            return false;
        }
        return this.tacticalSprint == other.tacticalSprint;
    }

    public CompoundTag serializeNBT() {
        return this.writeToNBT();
    }

    @ParametersAreNonnullByDefault
    public void deserializeNBT(CompoundTag nbt) {
        this.readFromNBT(nbt);
    }
}

