/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.entity.VehicleAssemblingTableBlockEntity;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.entity.vehicle.VehicleAssemblingTableVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.VehicleAssemblingTableBlockItem;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleAssemblingTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<BlockPart> BLOCK_PART = EnumProperty.m_61587_((String)"block_part", BlockPart.class);

    public VehicleAssemblingTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60999_().m_60955_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(BLOCK_PART, (Comparable)((Object)BlockPart.FLB)));
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"des.superbwarfare.vehicle_assembly_table").m_130940_(ChatFormatting.GRAY));
    }

    @ParametersAreNonnullByDefault
    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_(BLOCK_PART) == BlockPart.FLU || pState.m_61143_(BLOCK_PART) == BlockPart.FRU || pState.m_61143_(BLOCK_PART) == BlockPart.BLU || pState.m_61143_(BLOCK_PART) == BlockPart.BRU) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        }
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos blockPos;
        super.m_6402_(level, pos, state, placer, stack);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos initialPos = null;
        for (BlockPart part : BlockPart.values()) {
            blockPos = part.relativeNegative(pos, facing);
            if (!VehicleAssemblingTableBlockItem.canPlace(level, blockPos, facing, pos)) continue;
            initialPos = blockPos;
            break;
        }
        if (initialPos == null) {
            Mod.LOGGER.error("Unable to find valid position for vehicle assembling table at {}", (Object)pos);
            return;
        }
        for (BlockPart part : BlockPart.values()) {
            blockPos = part.relative(initialPos, facing);
            level.m_7731_(blockPos, (BlockState)state.m_61124_(BLOCK_PART, (Comparable)((Object)part)), 3);
            level.m_6289_(initialPos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, initialPos, 3);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos originalPos = ((BlockPart)((Object)state.m_61143_(BLOCK_PART))).relativeNegative(pos, facing);
        for (BlockPart part : BlockPart.values()) {
            BlockPos relativePos = part.relative(originalPos, facing);
            if (!relativePos.equals((Object)neighborPos) || neighborState.m_60734_() == this && neighborState.m_61143_(BLOCK_PART) == part) continue;
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BlockPart part = (BlockPart)((Object)state.m_61143_(BLOCK_PART));
            BlockPos originalPos = part.relativeNegative(pos, facing);
            for (BlockPart blockPart : BlockPart.values()) {
                BlockPos blockPos = blockPart.relative(originalPos, facing);
                BlockState blockState = level.m_8055_(blockPos);
                level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
                level.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @NotNull
    private static VehicleAssemblingTableVehicleEntity createVehicle(ServerLevel server, Direction facing, BlockPos originalPos) {
        float deg;
        VehicleAssemblingTableVehicleEntity vehicle = new VehicleAssemblingTableVehicleEntity((Level)server);
        int xOffset = switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.WEST, Direction.UP, Direction.DOWN, Direction.SOUTH -> 1;
            case Direction.NORTH, Direction.EAST -> 0;
        };
        int zOffset = switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.DOWN, Direction.SOUTH, Direction.EAST -> 0;
            case Direction.WEST, Direction.NORTH -> 1;
        };
        vehicle.m_6034_(originalPos.m_123341_() + xOffset, originalPos.m_123342_(), originalPos.m_123343_() + zOffset);
        vehicle.f_19859_ = deg = vehicle.m_7890_(switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.DOWN, Direction.SOUTH -> Rotation.NONE;
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            case Direction.NORTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
        });
        vehicle.m_146922_(deg);
        vehicle.m_20088_().m_135381_(VehicleEntity.SERVER_YAW, (Object)Float.valueOf(deg));
        return vehicle;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            Direction facing = (Direction)pState.m_61143_((Property)FACING);
            BlockPart part = (BlockPart)((Object)pState.m_61143_(BLOCK_PART));
            BlockPos originalPos = part.relativeNegative(pPos, facing);
            VehicleAssemblingTableVehicleEntity vehicle = VehicleAssemblingTableBlock.createVehicle(serverLevel, facing, originalPos);
            serverLevel.m_7967_((Entity)vehicle);
            for (BlockPart p : BlockPart.values()) {
                serverLevel.m_46961_(p.relative(originalPos, facing), false);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof VehicleAssemblingTableBlockEntity) {
            VehicleAssemblingTableBlockEntity blockEntity2 = (VehicleAssemblingTableBlockEntity)blockEntity;
            pPlayer.m_5893_((MenuProvider)blockEntity2);
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{BLOCK_PART});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new VehicleAssemblingTableBlockEntity(pPos, pState);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

