/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.gaboulibs.util;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AbilityUtils {
    public static EntityHitResult raycastEntities(Player player, double maxDistance) {
        Vec3 eyePosition = player.m_146892_();
        Vec3 viewVector = player.m_20252_(1.0f);
        Vec3 targetPosition = eyePosition.m_82549_(viewVector.m_82490_(maxDistance));
        BlockHitResult blockHit = player.m_9236_().m_45547_(new ClipContext(eyePosition, targetPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockDistance = blockHit.m_6662_() == HitResult.Type.BLOCK ? eyePosition.m_82554_(blockHit.m_82450_()) : maxDistance;
        EntityHitResult closestEntityHit = null;
        double closestDistance = blockDistance;
        AABB searchBox = player.m_20191_().m_82369_(viewVector.m_82490_(maxDistance)).m_82400_(1.0);
        List entities = player.m_9236_().m_6249_((Entity)player, searchBox, e -> e.m_6087_() && e instanceof LivingEntity);
        for (Entity entity : entities) {
            double dist;
            AABB box = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional intersection = box.m_82371_(eyePosition, targetPosition);
            if (!intersection.isPresent() || !((dist = eyePosition.m_82554_((Vec3)intersection.get())) < closestDistance)) continue;
            closestEntityHit = new EntityHitResult(entity, (Vec3)intersection.get());
            closestDistance = dist;
        }
        return closestEntityHit;
    }

    public static List<LivingEntity> raycastNearbyEntities(Player player, double maxDistance) {
        Vec3 eyePosition = player.m_146892_();
        Vec3 viewVector = player.m_20252_(1.0f);
        AABB box = player.m_20191_().m_82369_(viewVector.m_82490_(maxDistance)).m_82400_(1.5);
        return player.m_9236_().m_6443_(LivingEntity.class, box, entity -> entity != player && entity.m_6087_());
    }

    public static void knockbackNearbyEntities(Player player, float radius, double strength) {
        Level world = player.m_9236_();
        for (LivingEntity living : world.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), e -> e != player)) {
            double dx = living.m_20185_() - player.m_20185_();
            double dz = living.m_20189_() - player.m_20189_();
            double distance = Math.max(Math.sqrt(dx * dx + dz * dz), 0.001);
            living.m_20334_(dx / distance * strength, 0.1, dz / distance * strength);
            living.f_19864_ = true;
        }
    }

    public static void dashForward(Player player, double distance) {
        Vec3 look = player.m_20252_(1.0f);
        Vec3 current = player.m_20184_();
        player.m_20334_(look.f_82479_ * distance, current.f_82480_, look.f_82481_ * distance);
        player.f_19864_ = true;
    }

    public static void dropRandomItemFromInventory(Player player) {
        if (!player.m_150109_().m_7983_()) {
            Random random = new Random();
            int slot = random.nextInt(player.m_150109_().m_6643_());
            ItemStack stack = player.m_150109_().m_8020_(slot);
            if (!stack.m_41619_()) {
                ItemStack dropped = stack.m_41620_(1);
                player.m_36176_(dropped, false);
            }
        }
    }

    public static void healNearbyPlayers(Player player, float radius, float healAmount) {
        Level level = player.m_9236_();
        for (LivingEntity living : level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), e -> e instanceof Player)) {
            living.m_5634_(healAmount);
        }
    }

    public static void randomMorphNearby(Player player) {
        System.out.println("Morphing into a nearby entity");
    }

    public static void constrictNearby(Player player, float radius) {
        Level level = player.m_9236_();
        List entities = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), e -> e != player);
        for (LivingEntity living : entities) {
            living.m_20256_(Vec3.f_82478_);
            living.m_20242_(true);
            living.f_19864_ = true;
        }
    }

    public static void dashUpward(Player player, double power) {
        Vec3 current = player.m_20184_();
        player.m_20334_(current.f_82479_, power, current.f_82481_);
        player.f_19864_ = true;
    }

    public static void waterDash(Player player, double power) {
        if (player.m_20069_()) {
            Vec3 look = player.m_20252_(1.0f);
            Vec3 current = player.m_20184_();
            Vec3 added = new Vec3(look.f_82479_ * power, look.f_82480_ * 0.5, look.f_82481_ * power);
            player.m_20256_(current.m_82549_(added));
            player.f_19864_ = true;
        }
    }

    public static void shortTeleportForward(Player player, double distance) {
        Vec3 look = player.m_20252_(1.0f);
        Vec3 target = player.m_20182_().m_82549_(look.m_82490_(distance));
        player.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
    }

    public static void pullEntityTowardPlayer(Player player, LivingEntity target, double strength) {
        Vec3 direction = player.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        target.m_20334_(direction.f_82479_ * strength, 0.2, direction.f_82481_ * strength);
        target.f_19864_ = true;
    }

    public static void poisonNearbyEnemies(Player player, float radius, int durationTicks, int amplifier) {
        Level level = player.m_9236_();
        for (LivingEntity entity : level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)radius), e -> e != player)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, durationTicks, amplifier));
        }
    }

    public static BlockPos findNearbyJukebox(Level level, BlockPos origin) {
        double radius = 3.46;
        int blockRadius = (int)Math.ceil(radius);
        int originChunkX = origin.m_123341_() >> 4;
        int originChunkZ = origin.m_123343_() >> 4;
        int chunkRadius = (blockRadius >> 4) + 1;
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                LevelChunk chunk = level.m_6325_(originChunkX + dx, originChunkZ + dz);
                if (!(chunk instanceof LevelChunk)) continue;
                LevelChunk levelChunk = chunk;
                for (BlockEntity be : levelChunk.m_62954_().values()) {
                    JukeboxBlockEntity jukebox;
                    BlockPos pos;
                    if (!(be instanceof JukeboxBlockEntity) || !(pos = (jukebox = (JukeboxBlockEntity)be).m_58899_()).m_123314_((Vec3i)origin, radius)) continue;
                    return pos;
                }
            }
        }
        return null;
    }
}

