/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.entity.zipline;

import com.alrex.parcool.common.block.zipline.ZiplineHookTileEntity;
import com.alrex.parcool.common.block.zipline.ZiplineInfo;
import com.alrex.parcool.common.entity.EntityTypes;
import com.alrex.parcool.common.zipline.Zipline;
import com.alrex.parcool.common.zipline.ZiplineType;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ZiplineRopeEntity
extends Entity {
    private static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(ZiplineRopeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<BlockPos> DATA_END_POS = SynchedEntityData.m_135353_(ZiplineRopeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(ZiplineRopeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ZIP_TYPE = SynchedEntityData.m_135353_(ZiplineRopeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EntityDimensions size;
    private BlockPos zipline_start;
    private BlockPos zipline_end;
    private ZiplineType zip_type;
    private Zipline zipline;

    public ZiplineRopeEntity(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public ZiplineRopeEntity(Level world, BlockPos start, BlockPos end, ZiplineInfo info) {
        super((EntityType)EntityTypes.ZIPLINE_ROPE.get(), world);
        this.setStartPos(start);
        this.setEndPos(end);
        this.setColor(info.getColor());
        this.setZiplineType(info.getType());
        this.m_6034_((double)(end.m_123341_() + start.m_123341_()) / 2.0 + 0.5, Math.min(end.m_123342_(), start.m_123342_()), (double)(end.m_123343_() + start.m_123343_()) / 2.0 + 0.5);
        this.f_19794_ = true;
    }

    public Zipline getZipline() {
        BlockPos start = this.getStartPos();
        BlockPos end = this.getEndPos();
        ZiplineType type = this.getZiplineType();
        if (!(this.zipline != null && start.equals((Object)this.zipline_start) && end.equals((Object)this.zipline_end) && type.equals((Object)this.zip_type))) {
            Vec3 endPos;
            Vec3 startPos;
            this.zipline_start = start;
            this.zipline_end = end;
            this.zip_type = type;
            BlockEntity startEntity = this.m_9236_().m_7702_(start);
            BlockEntity endEntity = this.m_9236_().m_7702_(end);
            boolean delayInit = false;
            if (startEntity instanceof ZiplineHookTileEntity) {
                startPos = ((ZiplineHookTileEntity)startEntity).getActualZiplinePoint(end);
            } else {
                startPos = new Vec3((double)start.m_123341_() + 0.5, (double)start.m_123342_() + 0.5, (double)start.m_123343_() + 0.5);
                delayInit = true;
            }
            if (endEntity instanceof ZiplineHookTileEntity) {
                endPos = ((ZiplineHookTileEntity)endEntity).getActualZiplinePoint(start);
            } else {
                endPos = new Vec3((double)end.m_123341_() + 0.5, (double)end.m_123342_() + 0.5, (double)end.m_123343_() + 0.5);
                delayInit = true;
            }
            if (delayInit) {
                return type.getZipline(startPos, endPos);
            }
            this.zipline = type.getZipline(startPos, endPos);
        }
        return this.zipline;
    }

    public boolean m_6000_(double x, double y, double z) {
        double baseZOffset;
        double baseYOffset;
        BlockPos start = this.getStartPos();
        BlockPos end = this.getEndPos();
        if (start == BlockPos.f_121853_ && end == BlockPos.f_121853_) {
            return false;
        }
        double xOffset = end.m_123341_() - start.m_123341_();
        double yOffset = end.m_123342_() - start.m_123342_();
        double zOffset = end.m_123343_() - start.m_123343_();
        double baseXOffset = (double)start.m_123341_() - x;
        double t = -(xOffset * baseXOffset + yOffset * (baseYOffset = (double)start.m_123342_() - y) + zOffset * (baseZOffset = (double)start.m_123343_() - z)) / (xOffset * xOffset + yOffset * yOffset + zOffset * zOffset);
        Vec3 mostNearPoint = new Vec3(xOffset * t + (double)start.m_123341_(), yOffset * t + (double)start.m_123342_(), zOffset * t + (double)start.m_123343_());
        double distanceSqr = mostNearPoint.m_82531_(x, y, z);
        return distanceSqr < 13225.0;
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose p_213305_1_) {
        if (this.size == null) {
            return EntityDimensions.m_20398_((float)0.1f, (float)0.1f);
        }
        return this.size;
    }

    public void m_6478_(MoverType p_19973_, Vec3 p_19974_) {
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.m_20088_().m_135370_(DATA_START_POS);
    }

    public BlockPos getEndPos() {
        return (BlockPos)this.m_20088_().m_135370_(DATA_END_POS);
    }

    private void setStartPos(BlockPos start) {
        this.m_20088_().m_135381_(DATA_START_POS, (Object)start);
    }

    private void setEndPos(BlockPos end) {
        this.m_20088_().m_135381_(DATA_END_POS, (Object)end);
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR);
    }

    private void setColor(int color) {
        this.m_20088_().m_135381_(DATA_COLOR, (Object)color);
    }

    public ZiplineType getZiplineType() {
        return ZiplineType.values()[(Integer)this.m_20088_().m_135370_(DATA_ZIP_TYPE) % ZiplineType.values().length];
    }

    private void setZiplineType(ZiplineType type) {
        this.m_20088_().m_135381_(DATA_ZIP_TYPE, (Object)type.ordinal());
    }

    @Nonnull
    public InteractionResult m_6096_(Player player, InteractionHand p_19979_) {
        return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
        this.m_20088_().m_135372_(DATA_END_POS, (Object)BlockPos.f_121853_);
        this.m_20088_().m_135372_(DATA_COLOR, (Object)5013478);
        this.m_20088_().m_135372_(DATA_ZIP_TYPE, (Object)ZiplineType.STANDARD.ordinal());
    }

    public void m_7378_(@Nonnull CompoundTag compoundNBT) {
        this.setStartPos(new BlockPos(compoundNBT.m_128451_("Tile1_X"), compoundNBT.m_128451_("Tile1_Y"), compoundNBT.m_128451_("Tile1_Z")));
        this.setEndPos(new BlockPos(compoundNBT.m_128451_("Tile2_X"), compoundNBT.m_128451_("Tile2_Y"), compoundNBT.m_128451_("Tile2_Z")));
    }

    public void m_7380_(@Nonnull CompoundTag compoundNBT) {
        BlockPos startPos = this.getStartPos();
        BlockPos endPos = this.getEndPos();
        compoundNBT.m_128405_("Tile1_X", startPos.m_123341_());
        compoundNBT.m_128405_("Tile1_X", startPos.m_123342_());
        compoundNBT.m_128405_("Tile1_X", startPos.m_123343_());
        compoundNBT.m_128405_("Tile2_X", endPos.m_123341_());
        compoundNBT.m_128405_("Tile2_X", endPos.m_123342_());
        compoundNBT.m_128405_("Tile2_X", endPos.m_123343_());
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

