/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Equalizer;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import minecrafttransportsimulator.sound.IStreamDecoder;

public class MP3Decoder
implements IStreamDecoder {
    private final InputStream dataSourceStream;
    private final Bitstream bitstream;
    private final Decoder decoder;
    private final Equalizer equalizer;
    private final SampleBuffer decoderOutputBuffer;
    private final ByteBuffer decodedDataBuffer;
    private final boolean isStereo;
    private final int sampleRate;
    private Header currentFrameHeader;

    public MP3Decoder(InputStream dataSourceStream, Equalizer equalizer) {
        this.dataSourceStream = dataSourceStream;
        this.bitstream = new Bitstream(dataSourceStream);
        this.decoder = new Decoder();
        this.equalizer = equalizer;
        try {
            this.currentFrameHeader = this.bitstream.readFrame();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isStereo = this.currentFrameHeader.mode() != 3;
        this.sampleRate = this.currentFrameHeader.frequency();
        this.decoderOutputBuffer = new SampleBuffer(this.sampleRate, this.isStereo ? 2 : 1);
        this.decodedDataBuffer = ByteBuffer.allocateDirect(131072).order(ByteOrder.nativeOrder());
        this.decoder.setOutputBuffer(this.decoderOutputBuffer);
    }

    @Override
    public ByteBuffer readBlock() {
        int totalSamplesRead;
        int samplesRead;
        if (this.currentFrameHeader == null) {
            return null;
        }
        this.decoder.setEqualizer(this.equalizer);
        this.decodedDataBuffer.clear();
        ShortBuffer sampleBuffer = this.decodedDataBuffer.asShortBuffer();
        for (totalSamplesRead = 0; totalSamplesRead < 49152; totalSamplesRead += samplesRead) {
            try {
                this.decoder.decodeFrame(this.currentFrameHeader, this.bitstream);
                this.bitstream.closeFrame();
                samplesRead = this.decoderOutputBuffer.getBufferLength();
                sampleBuffer.put(this.decoderOutputBuffer.getBuffer(), 0, samplesRead);
                this.currentFrameHeader = this.bitstream.readFrame();
                if (this.currentFrameHeader != null) continue;
                break;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        this.decodedDataBuffer.rewind();
        this.decodedDataBuffer.limit(totalSamplesRead * 2);
        return this.isStereo ? IStreamDecoder.stereoToMono(this.decodedDataBuffer) : this.decodedDataBuffer;
    }

    @Override
    public void stop() {
        try {
            this.bitstream.close();
            this.dataSourceStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getSampleRate() {
        return this.sampleRate;
    }
}

