/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIHUD;
import minecrafttransportsimulator.guis.instances.GUIPanel;
import minecrafttransportsimulator.guis.instances.GUIRadio;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.items.instances.ItemPartSeat;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONCameraObject;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public final class PartSeat
extends APart {
    public boolean canControlGuns;
    private boolean riderChangingSeats;
    public final Point3D riderScale = new Point3D();
    public ItemPartGun activeGunItem;
    public int gunSequenceCooldown;
    public int gunGroupIndex;
    public int gunIndex;
    public final HashMap<ItemPartGun, List<PartGun>> gunGroups = new LinkedHashMap<ItemPartGun, List<PartGun>>();

    public PartSeat(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartSeat item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        if (data != null) {
            this.activeGunItem = (ItemPartGun)PackParser.getItem(data.getString("activeGunPackID"), data.getString("activeGunSystemName"), data.getString("activeGunSubName"));
        }
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (this.isActive) {
            if (this.vehicleOn == null || !this.vehicleOn.lockedVar.isActive || this.masterEntity.allParts.contains(player.getEntityRiding())) {
                if (this.rider != null) {
                    if (this.rider instanceof IWrapperPlayer) {
                        if (player != this.rider) {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_SEATTAKEN, new Object[0]));
                        }
                    } else if (!this.rider.leashTo(player)) {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_SEATTAKEN, new Object[0]));
                    }
                } else {
                    IWrapperEntity leashedEntity = player.getLeashedEntity();
                    if (leashedEntity != null) {
                        this.setRider(leashedEntity, true);
                    } else if (!player.isSneaking()) {
                        AEntityB_Existing entityPlayerRiding = player.getEntityRiding();
                        if (entityPlayerRiding != null) {
                            if (entityPlayerRiding instanceof PartSeat) {
                                ((PartSeat)entityPlayerRiding).riderChangingSeats = true;
                            }
                            entityPlayerRiding.removeRider();
                        }
                        this.setRider(player, !(entityPlayerRiding instanceof PartSeat) || ((PartSeat)entityPlayerRiding).vehicleOn != this.vehicleOn);
                    }
                }
            } else {
                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
            }
        }
        return true;
    }

    @Override
    public void update() {
        super.update();
        if (!this.canControlGuns && (this.activeGunItem != null || this.placementDefinition.canDisableGun)) {
            this.canControlGuns = true;
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        ArrayList<PartGun> gunList = new ArrayList<PartGun>();
        this.addLinkedPartsToList(gunList, PartGun.class);
        for (APart part : this.parts) {
            if (!(part instanceof PartGun)) continue;
            gunList.add((PartGun)part);
        }
        if (this.entityOn instanceof PartGun) {
            gunList.add((PartGun)this.entityOn);
        }
        this.gunGroups.clear();
        for (PartGun gun : gunList) {
            ItemPartGun gunItem = (ItemPartGun)gun.cachedItem;
            if (!this.gunGroups.containsKey(gunItem)) {
                this.gunGroups.put(gunItem, new ArrayList());
            }
            this.gunGroups.get(gunItem).add(gun);
        }
        if (!this.gunGroups.containsKey(this.activeGunItem)) {
            this.activeGunItem = null;
            this.gunIndex = 0;
        }
        this.gunGroupIndex = 0;
        if (((AJSONPartProvider)this.masterEntity.definition).rendering != null && ((AJSONPartProvider)this.masterEntity.definition).rendering.cameraObjects != null) {
            for (JSONCameraObject camera : ((AJSONPartProvider)this.masterEntity.definition).rendering.cameraObjects) {
                this.cameras.add(camera);
                this.cameraEntities.put(camera, this.masterEntity);
            }
        } else {
            for (APart part : this.masterEntity.allParts) {
                if (((JSONPart)part.definition).rendering == null || ((JSONPart)part.definition).rendering.cameraObjects == null) continue;
                for (JSONCameraObject camera : ((JSONPart)part.definition).rendering.cameraObjects) {
                    this.cameras.add(camera);
                    this.cameraEntities.put(camera, part);
                }
            }
        }
    }

    @Override
    public boolean setRider(IWrapperEntity rider, boolean facesForwards) {
        if (super.setRider(rider, facesForwards)) {
            if (this.vehicleOn != null && this.placementDefinition.isController) {
                ++this.vehicleOn.controllerCount;
                if (rider instanceof IWrapperPlayer && ((IWrapperPlayer)rider).isCreative() && !this.vehicleOn.isCreative) {
                    this.vehicleOn.isCreative = true;
                }
            }
            if (!(this.activeGunItem != null || this.placementDefinition.canDisableGun && rider instanceof IWrapperPlayer)) {
                this.setNextActiveGun();
            }
            if (this.riderIsClient && this.vehicleOn != null) {
                new GUIHUD(this.vehicleOn, this);
                if (this.placementDefinition.isController && ((Boolean)ConfigSystem.client.controlSettings.autostartEng.value).booleanValue() && this.vehicleOn.canPlayerStartEngines((IWrapperPlayer)rider) && !((JSONVehicle)this.vehicleOn.definition).motorized.overrideAutoStart) {
                    this.vehicleOn.engines.forEach(engine -> {
                        if (!((JSONVehicle)this.vehicleOn.definition).motorized.isAircraft) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.shiftNeutralVar));
                        }
                        InterfaceManager.packetInterface.sendToServer(new PacketPartEngine((PartEngine)engine, PacketPartEngine.Signal.AS_ON));
                    });
                    if (this.vehicleOn.parkingBrakeVar.isActive) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(this.vehicleOn.parkingBrakeVar));
                    }
                }
            }
            if (!this.world.isClient() && this.placementDefinition.interactableVariables != null) {
                this.placementDefinition.interactableVariables.forEach(variableKeys -> variableKeys.forEach(variableKey -> {
                    if (variableKey.contains("door")) {
                        this.entityOn.getOrCreateVariable((String)variableKey).setTo(0.0, true);
                    }
                }));
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeRider() {
        if (this.vehicleOn != null) {
            boolean otherController = false;
            boolean otherCreativeController = false;
            for (APart part : this.vehicleOn.allParts) {
                if (part == this || !(part.rider instanceof IWrapperPlayer) || !part.placementDefinition.isController) continue;
                otherController = true;
                if (!(this.rider instanceof IWrapperPlayer) || !((IWrapperPlayer)this.rider).isCreative()) continue;
                otherCreativeController = true;
                break;
            }
            if (!otherCreativeController) {
                this.vehicleOn.isCreative = false;
            }
            if (this.placementDefinition.isController) {
                --this.vehicleOn.controllerCount;
            }
            if (this.riderIsClient) {
                AGUIBase.closeIfOpen(GUIPanel.class);
                AGUIBase.closeIfOpen(GUIHUD.class);
                AGUIBase.closeIfOpen(GUIRadio.class);
                if (this.placementDefinition.isController && !otherController && ((Boolean)ConfigSystem.client.controlSettings.autostartEng.value).booleanValue() && !((JSONVehicle)this.vehicleOn.definition).motorized.overrideAutoStart) {
                    this.vehicleOn.engines.forEach(engine -> {
                        if (engine.magnetoVar.isActive) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.magnetoVar));
                        }
                        if (engine.electricStarterVar.isActive) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(engine.electricStarterVar));
                        }
                    });
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(this.vehicleOn.brakeVar, 0.0));
                    if (!this.vehicleOn.parkingBrakeVar.isActive) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(this.vehicleOn.parkingBrakeVar));
                    }
                }
            }
        }
        if (this.placementDefinition.canDisableGun) {
            this.activeGunItem = null;
        }
        if (this.placementDefinition.seatEffects != null) {
            for (JSONPotionEffect effect : this.placementDefinition.seatEffects) {
                this.rider.removePotionEffect(effect);
            }
        }
        if (!this.riderChangingSeats) {
            this.rider.setRiding(null);
            if (this.placementDefinition.dismountPos != null) {
                this.rider.setPosition(this.placementDefinition.dismountPos.copy().rotate(this.entityOn.orientation).add(this.entityOn.position), false);
            } else if (this.vehicleOn != null) {
                Point3D dismountPosition = this.position.copy().subtract(this.vehicleOn.position).reOrigin(this.vehicleOn.orientation);
                if (dismountPosition.x < 0.0) {
                    dismountPosition.add(-2.0, 0.0, 0.0).rotate(this.vehicleOn.orientation).add(this.vehicleOn.position);
                } else {
                    dismountPosition.add(2.0, 0.0, 0.0).rotate(this.vehicleOn.orientation).add(this.vehicleOn.position);
                }
                this.rider.setPosition(dismountPosition, false);
            } else {
                this.rider.setPosition(this.position, false);
            }
            this.rider.setOrientation(this.orientation);
            if (!this.world.isClient() && this.placementDefinition.interactableVariables != null) {
                this.placementDefinition.interactableVariables.forEach(variableKeys -> variableKeys.forEach(variableKey -> {
                    if (variableKey.contains("door")) {
                        this.entityOn.getOrCreateVariable((String)variableKey).setTo(1.0, true);
                    }
                }));
            }
        }
        this.riderChangingSeats = false;
        super.removeRider();
    }

    @Override
    public boolean updateRider() {
        if (super.updateRider()) {
            if (this.vehicleOn != null) {
                this.riderScale.set(this.scale.x / this.vehicleOn.scale.x, this.scale.y / this.vehicleOn.scale.y, this.scale.z / this.vehicleOn.scale.z);
            } else {
                this.riderScale.set(this.scale);
            }
            if (this.placementDefinition.seatEffects != null) {
                for (JSONPotionEffect effect : this.placementDefinition.seatEffects) {
                    this.rider.addPotionEffect(effect);
                }
            }
            if (this.world.isClient() && !InterfaceManager.clientInterface.isChatOpen() && this.riderIsClient) {
                ControlSystem.controlMultipart(this.masterEntity, this.placementDefinition.isController);
            }
            return true;
        }
        return false;
    }

    @Override
    public LanguageSystem.LanguageEntry checkForRemoval(IWrapperPlayer player) {
        if (this.rider != null) {
            return LanguageSystem.INTERACT_PARTREMOVE_RIDER;
        }
        return super.checkForRemoval(player);
    }

    @Override
    public boolean canBeClicked() {
        if (this.world.isClient() && this.vehicleOn != null) {
            IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
            for (APart part : this.vehicleOn.allParts) {
                if (!player.equals(part.rider) || part == this) continue;
                return true;
            }
        }
        if (this.riderIsClient) {
            return false;
        }
        return super.canBeClicked();
    }

    public void setNextActiveGun() {
        if (this.activeGunItem == null) {
            Iterator<ItemPartGun> iterator = this.gunGroups.keySet().iterator();
            if (iterator.hasNext()) {
                ItemPartGun gunItem;
                this.activeGunItem = gunItem = iterator.next();
                this.gunIndex = 0;
                return;
            }
        } else {
            this.activeGunItem = this.getNextActiveGun();
            this.gunGroupIndex = 0;
        }
    }

    private ItemPartGun getNextActiveGun() {
        boolean pastActiveGun = false;
        ItemPartGun firstPossibleGun = null;
        for (ItemPartGun gunItem : this.gunGroups.keySet()) {
            if (pastActiveGun) {
                return gunItem;
            }
            if (firstPossibleGun == null) {
                firstPossibleGun = gunItem;
            }
            if (gunItem != this.activeGunItem) continue;
            pastActiveGun = true;
            if (!((JSONPart)gunItem.definition).gun.fireSolo) continue;
            if (this.gunGroups.get(gunItem).size() <= ++this.gunIndex) {
                this.gunIndex = 0;
                pastActiveGun = true;
                continue;
            }
            return gunItem;
        }
        return this.placementDefinition.canDisableGun && this.activeGunItem != null ? null : firstPossibleGun;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "seat_occupied": {
                return new ComputedVariable(this, variable, partialTicks -> this.rider != null ? 1.0 : 0.0, false);
            }
            case "seat_occupied_client": {
                return new ComputedVariable(this, variable, partialTicks -> this.riderIsClient ? 1.0 : 0.0, false);
            }
            case "seat_rider_yaw": {
                return new ComputedVariable(this, variable, partialTicks -> this.rider != null ? (partialTicks != 0.0f ? this.prevRiderRelativeOrientation.angles.y + (this.riderRelativeOrientation.angles.y - this.prevRiderRelativeOrientation.angles.y) * (double)partialTicks : this.riderRelativeOrientation.angles.y) : 0.0, true);
            }
            case "seat_rider_pitch": {
                return new ComputedVariable(this, variable, partialTicks -> this.rider != null ? (partialTicks != 0.0f ? this.prevRiderRelativeOrientation.angles.x + (this.riderRelativeOrientation.angles.x - this.prevRiderRelativeOrientation.angles.x) * (double)partialTicks : this.riderRelativeOrientation.angles.x) : 0.0, true);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.activeGunItem != null) {
            data.setString("activeGunPackID", ((JSONPart)this.activeGunItem.definition).packID);
            data.setString("activeGunSystemName", ((JSONPart)this.activeGunItem.definition).systemName);
            data.setString("activeGunSubName", this.activeGunItem.subDefinition.subName);
        }
        return data;
    }
}

