/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityCameraChange;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public abstract class APart
extends AEntityF_Multipart<JSONPart> {
    public final JSONPartDefinition placementDefinition;
    public final int placementSlot;
    public final AEntityF_Multipart<?> entityOn;
    public final AEntityF_Multipart<?> masterEntity;
    public final EntityVehicleF_Physics vehicleOn;
    public final APart partOn;
    public final List<APart> linkedParts = new ArrayList<APart>();
    public boolean isInvisible = false;
    public boolean isActive = true;
    public boolean isPermanent = false;
    public final boolean isMoveable;
    public final boolean turnsWithSteer;
    public final boolean isSpare;
    public final boolean isMirrored;
    private boolean requestedForcedCamera;
    private final ComputedVariable newlyAddedVar;
    public final Point3D localOffset;
    public final RotationMatrix localOrientation;
    public final RotationMatrix zeroReferenceOrientation;
    public final RotationMatrix prevZeroReferenceOrientation;
    public final Point3D externalAnglesRotated = new Point3D();
    private final AnimationSwitchbox placementActiveSwitchbox;
    private final AnimationSwitchbox internalActiveSwitchbox;
    private final AnimationSwitchbox placementMovementSwitchbox;
    private final AnimationSwitchbox internalMovementSwitchbox;

    public APart(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, AItemPart item, IWrapperNBT data) {
        super(entityOn.world, placingPlayer, item, data);
        this.localOffset = placementDefinition.pos.copy();
        this.localOrientation = new RotationMatrix();
        this.zeroReferenceOrientation = new RotationMatrix();
        this.prevZeroReferenceOrientation = new RotationMatrix();
        if (placementDefinition.constantValues != null) {
            placementDefinition.constantValues.forEach((constantKey, constantValue) -> {
                ComputedVariable newVariable = new ComputedVariable(this, (String)constantKey);
                newVariable.setTo((double)constantValue, false);
                this.addVariable(newVariable);
            });
        }
        this.position.set(this.localOffset).rotate(entityOn.orientation).add(entityOn.position);
        this.prevPosition.set(this.position);
        this.orientation.set(entityOn.orientation);
        if (placementDefinition.rot != null) {
            this.orientation.multiply(placementDefinition.rot);
        }
        this.prevOrientation.set(this.orientation);
        this.scale.set(entityOn.scale);
        if (placementDefinition.partScale != null) {
            this.scale.multiply(placementDefinition.partScale);
        }
        this.prevScale.set(this.scale);
        if (placementDefinition.animations != null || placementDefinition.applyAfter != null) {
            ArrayList<JSONAnimationDefinition> animations = new ArrayList<JSONAnimationDefinition>();
            if (placementDefinition.animations != null) {
                animations.addAll(placementDefinition.animations);
            }
            this.placementMovementSwitchbox = new AnimationSwitchbox(entityOn, animations, placementDefinition.applyAfter);
        } else {
            this.placementMovementSwitchbox = null;
        }
        this.internalMovementSwitchbox = ((JSONPart)this.definition).generic.movementAnimations != null ? new AnimationSwitchbox(this, ((JSONPart)this.definition).generic.movementAnimations, null) : null;
        this.placementActiveSwitchbox = placementDefinition.activeAnimations != null ? new AnimationSwitchbox(entityOn, placementDefinition.activeAnimations, null) : null;
        this.internalActiveSwitchbox = ((JSONPart)this.definition).generic.activeAnimations != null ? new AnimationSwitchbox(this, ((JSONPart)this.definition).generic.activeAnimations, null) : null;
        this.entityOn = entityOn;
        AEntityF_Multipart<?> parentEntity = entityOn;
        while (parentEntity instanceof APart) {
            parentEntity = ((APart)parentEntity).entityOn;
        }
        this.masterEntity = parentEntity;
        this.vehicleOn = parentEntity instanceof EntityVehicleF_Physics ? (EntityVehicleF_Physics)parentEntity : null;
        this.partOn = entityOn instanceof APart ? (APart)entityOn : null;
        this.placementDefinition = placementDefinition;
        this.placementSlot = ((AJSONPartProvider)entityOn.definition).parts.indexOf(placementDefinition);
        this.isMoveable = this.placementMovementSwitchbox != null || this.internalMovementSwitchbox != null;
        this.turnsWithSteer = placementDefinition.turnsWithSteer || this.partOn != null && this.partOn.turnsWithSteer;
        this.isSpare = placementDefinition.isSpare || this.partOn != null && this.partOn.isSpare;
        this.isMirrored = placementDefinition.isMirrored || this.partOn != null && this.partOn.isMirrored;
        this.newlyAddedVar = new ComputedVariable(this, "newlyAdded", data);
        this.addVariable(this.newlyAddedVar);
        if (placingPlayer != null) {
            this.newlyAddedVar.setActive(true, false);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.ticksExisted == 5L) {
            this.newlyAddedVar.setActive(false, false);
        }
        this.world.beginProfiling("PartAlignment", true);
        this.isInvisible = this.partOn != null ? this.partOn.isInvisible : false;
        this.world.beginProfiling("CameraModeCheck", true);
        if (!this.requestedForcedCamera && this.placementDefinition.forceCameras && this.world.isClient() && this.activeCamera == null && InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON) {
            InterfaceManager.packetInterface.sendToServer(new PacketEntityCameraChange(this));
        } else if (this.requestedForcedCamera && this.activeCamera != null) {
            this.requestedForcedCamera = false;
        }
        this.world.beginProfiling("ActiveStateCheck", false);
        boolean bl = this.isActive = this.partOn != null ? this.partOn.isActive : true;
        if (this.isActive && this.placementActiveSwitchbox != null) {
            this.isActive = this.placementActiveSwitchbox.runSwitchbox(0.0f, false);
        }
        if (this.isActive && this.internalActiveSwitchbox != null) {
            this.isActive = this.internalActiveSwitchbox.runSwitchbox(0.0f, false);
        }
        if (!this.isActive && this.rider != null) {
            this.removeRider();
        }
        this.world.beginProfiling("BaseStateCheck", false);
        this.motion.set(this.entityOn.motion);
        this.position.set(this.entityOn.position);
        this.orientation.set(this.entityOn.orientation);
        this.localOffset.set(this.placementDefinition.pos);
        if (((JSONPart)this.definition).generic.slotOffset != null) {
            this.localOffset.add(((JSONPart)this.definition).generic.slotOffset);
        }
        this.isPermanent = this.placementDefinition.lockingVariables != null ? !this.isVariableListTrue(this.placementDefinition.lockingVariables) : this.placementDefinition.isPermanent;
        this.prevZeroReferenceOrientation.set(this.zeroReferenceOrientation);
        if (this.partOn != null) {
            this.zeroReferenceOrientation.set(this.partOn.zeroReferenceOrientation);
        } else {
            this.zeroReferenceOrientation.set(this.entityOn.orientation);
        }
        if (this.placementDefinition.rot != null) {
            this.zeroReferenceOrientation.multiply(this.placementDefinition.rot);
        }
        this.localOrientation.setToZero();
        this.world.beginProfiling("SwitchboxCheck", false);
        if (!this.isInvisible && this.placementMovementSwitchbox != null) {
            this.isInvisible = !this.placementMovementSwitchbox.runSwitchbox(0.0f, false);
            this.localOffset.transform(this.placementMovementSwitchbox.netMatrix);
            this.localOrientation.multiply(this.placementMovementSwitchbox.rotation);
            this.externalAnglesRotated.set(this.placementMovementSwitchbox.rotation.convertToAngles());
        } else {
            this.externalAnglesRotated.set(0.0, 0.0, 0.0);
        }
        this.world.beginProfiling("SwitchboxApply", false);
        if (this.placementDefinition.rot != null) {
            this.localOrientation.multiply(this.placementDefinition.rot);
        }
        this.scale.set(this.entityOn.scale);
        this.localOffset.multiply(this.scale);
        if (this.placementDefinition.partScale != null) {
            this.scale.multiply(this.placementDefinition.partScale);
        }
        if (this.internalMovementSwitchbox != null) {
            this.isInvisible = !this.internalMovementSwitchbox.runSwitchbox(0.0f, false) || this.isInvisible;
            this.localOffset.add(this.internalMovementSwitchbox.translation.multiply(this.scale).rotate(this.localOrientation));
            this.localOrientation.multiply(this.internalMovementSwitchbox.rotation);
        }
        this.world.beginProfiling("AlignmentApply", false);
        Point3D localPositionDelta = new Point3D().set(this.localOffset).rotate(this.orientation);
        this.position.add(localPositionDelta);
        this.orientation.multiply(this.localOrientation);
        if (this.partOn != null) {
            this.localOffset.reOrigin(this.partOn.localOrientation).add(this.partOn.localOffset);
        }
        this.boundingBox.widthRadius = this.getWidth() / 2.0 * this.scale.x;
        this.boundingBox.heightRadius = this.getHeight() / 2.0 * this.scale.y;
        this.boundingBox.depthRadius = this.getWidth() / 2.0 * this.scale.z;
        this.world.endProfiling();
        this.world.endProfiling();
    }

    @Override
    public AEntityA_Base.EntityAutoUpdateTime getUpdateTime() {
        return this.entityOn.getUpdateTime();
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return this.entityOn.requiresDeltaUpdates() || this.isMoveable || super.requiresDeltaUpdates();
    }

    @Override
    protected void updateCollisionBoxes(boolean requiresDeltaUpdates) {
        if (!this.isFake()) {
            super.updateCollisionBoxes(requiresDeltaUpdates);
            this.collisionBoxes.add(this.boundingBox);
        }
    }

    @Override
    public void attack(Damage damage) {
        if (!this.isPermanent && ((JSONPart)this.definition).generic.canBeRemovedByHand && damage.isHand) {
            IWrapperPlayer player = (IWrapperPlayer)damage.entityResponsible;
            if (this.vehicleOn != null && this.vehicleOn.lockedVar.isActive) {
                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
            } else {
                LanguageSystem.LanguageEntry partResult = this.checkForRemoval(player);
                if (partResult != null) {
                    player.sendPacket(new PacketPlayerChatMessage(player, partResult, new Object[0]));
                    return;
                }
                if (!player.getInventory().addStack(this.getStack())) {
                    this.world.spawnItemStack(this.getStack(), this.position, null);
                }
                this.entityOn.removePart(this, false, true);
            }
        } else {
            super.attack(damage);
            if (((JSONPart)this.definition).generic.forwardsDamageMultiplier != 0.0) {
                this.masterEntity.attack(new Damage(damage, ((JSONPart)this.definition).generic.forwardsDamageMultiplier, null));
            }
            if (this.outOfHealth && ((JSONPart)this.definition).generic.destroyable) {
                this.destroy(damage.box);
                this.world.spawnExplosion(this.position, 0.0, false, false);
            }
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.linkedParts.clear();
        this.addLinkedPartsToList(this.linkedParts, APart.class);
    }

    @Override
    public double getMass() {
        return super.getMass() + (double)((JSONPart)this.definition).generic.mass;
    }

    @Override
    public boolean shouldSavePosition() {
        return false;
    }

    @Override
    public boolean canBeClicked() {
        return this.entityOn.isVariableListTrue(this.placementDefinition.interactableVariables) && this.entityOn.canBeClicked();
    }

    public void updateTone(boolean recursive) {
        if (this.placementDefinition.toneIndex != 0) {
            String partTone = null;
            if (this.entityOn.subDefinition.partTones != null && this.entityOn.subDefinition.partTones.size() >= this.placementDefinition.toneIndex) {
                partTone = this.entityOn.subDefinition.partTones.get(this.placementDefinition.toneIndex - 1);
            }
            if (partTone == null && this.masterEntity.subDefinition.partTones != null && this.masterEntity.subDefinition.partTones.size() >= this.placementDefinition.toneIndex) {
                partTone = this.masterEntity.subDefinition.partTones.get(this.placementDefinition.toneIndex - 1);
            }
            if (partTone != null) {
                for (JSONSubDefinition subDefinition : ((JSONPart)this.definition).definitions) {
                    if (!subDefinition.subName.equals(partTone)) continue;
                    this.updateSubDefinition(partTone);
                    break;
                }
            }
        }
        if (recursive && !this.parts.isEmpty()) {
            for (APart part : this.parts) {
                part.updateTone(true);
            }
        }
    }

    public <PartClass extends APart> void addLinkedPartsToList(List<PartClass> partList, Class<PartClass> partClass) {
        if (this.placementDefinition.linkedParts != null) {
            Iterator<Object> iterator = this.placementDefinition.linkedParts.iterator();
            while (iterator.hasNext()) {
                int partIndex = iterator.next();
                APart partAtIndex = this.entityOn.partsInSlots.get(partIndex - 1);
                if (partClass.isInstance(partAtIndex)) {
                    partList.add((APart)partClass.cast(partAtIndex));
                }
                if (partAtIndex == null) continue;
                for (APart part : partAtIndex.allParts) {
                    if (!partClass.isInstance(part)) continue;
                    partList.add((APart)partClass.cast(part));
                }
            }
        }
        if (((JSONPart)this.definition).generic.forceAllLinks) {
            for (APart part : this.masterEntity.allParts) {
                if (part == this || !partClass.isInstance(part) || partList.contains(part)) continue;
                partList.add((APart)partClass.cast(part));
            }
        }
        for (APart part : this.entityOn.parts) {
            if (part == this || part.placementDefinition.linkedParts == null) continue;
            for (int partIndex : part.placementDefinition.linkedParts) {
                if (partIndex - 1 != this.placementSlot) continue;
                if (partClass.isInstance(part) && !partList.contains(part)) {
                    partList.add((APart)partClass.cast(part));
                    continue;
                }
                for (APart part2 : part.allParts) {
                    if (!partClass.isInstance(part2) || partList.contains(part2)) continue;
                    partList.add((APart)partClass.cast(part2));
                }
            }
        }
        for (APart part : this.masterEntity.allParts) {
            if (part == this || !((JSONPart)part.definition).generic.forceAllLinks || !partClass.isInstance(part) || partList.contains(part)) continue;
            partList.add((APart)partClass.cast(part));
        }
        if (this.partOn != null) {
            for (APart part : this.partOn.linkedParts) {
                if (!partClass.isInstance(part) || partList.contains(part)) continue;
                partList.add((APart)partClass.cast(part));
            }
        }
    }

    public boolean isInLiquid() {
        return this.world.isBlockLiquid(this.position);
    }

    public LanguageSystem.LanguageEntry checkForRemoval(IWrapperPlayer player) {
        for (APart childPart : this.parts) {
            if (childPart.isPermanent || childPart.placementDefinition.allowParentRemoval) continue;
            return LanguageSystem.INTERACT_PARTREMOVE_HASPARTS;
        }
        if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH) && ((JSONPart)this.definition).generic.mustBeRemovedByScrewdriver) {
            return LanguageSystem.INTERACT_PARTREMOVE_SCREWDRIVER;
        }
        if (player.isHoldingItemType(JSONItem.ItemComponentType.SCREWDRIVER) && !((JSONPart)this.definition).generic.mustBeRemovedByScrewdriver) {
            return LanguageSystem.INTERACT_PARTREMOVE_WRENCH;
        }
        return null;
    }

    public boolean isFake() {
        return false;
    }

    public double getWidth() {
        return ((JSONPart)this.definition).generic.width != 0.0f ? (double)((JSONPart)this.definition).generic.width : 0.75;
    }

    public double getHeight() {
        return ((JSONPart)this.definition).generic.height != 0.0f ? (double)((JSONPart)this.definition).generic.height : 0.75;
    }

    @Override
    public float getLightProvided() {
        return this.entityOn.getLightProvided();
    }

    @Override
    public boolean shouldRenderBeams() {
        return this.entityOn.shouldRenderBeams();
    }

    @Override
    public String getTexture() {
        if (this.subDefinition.useVehicleTexture) {
            if (this.vehicleOn != null) {
                return this.vehicleOn.getTexture();
            }
            if (((JSONPart)this.definition).generic.benchTexture != null) {
                return PackResourceLoader.getPackResource(this.definition, PackResourceLoader.ResourceType.PNG, ((JSONPart)this.definition).generic.benchTexture);
            }
            return null;
        }
        return super.getTexture();
    }

    @Override
    public boolean renderTextLit() {
        return this.entityOn.renderTextLit();
    }

    private void reinitVariable(String variable) {
        ComputedVariable computedVar = this.getOrCreateVariable(variable);
        if (variable.startsWith("!")) {
            computedVar.setFunctionTo(this.createComputedVariable((String)variable.substring((int)"!".length()), (boolean)true).invertedVariable);
        } else {
            computedVar.setFunctionTo(this.createComputedVariable(variable, true));
        }
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        if (this.entityOn == null) {
            return new ComputedVariable(this, variable, partialTicks -> {
                this.reinitVariable(variable);
                return 0.0;
            }, false);
        }
        if (variable.startsWith("vehicle_")) {
            if (this.vehicleOn != null) {
                return this.entityOn.createComputedVariable(variable.substring("vehicle_".length()), true);
            }
            return new ComputedVariable(false);
        }
        if (variable.startsWith("parent_")) {
            return this.entityOn.createComputedVariable(variable.substring("parent_".length()), true);
        }
        switch (variable) {
            case "part_present": {
                return new ComputedVariable(true);
            }
            case "part_ismirrored": {
                return new ComputedVariable(this.isMirrored);
            }
            case "part_isonfront": {
                return new ComputedVariable(this.placementDefinition.pos.z > 0.0);
            }
            case "part_isspare": {
                return new ComputedVariable(this.isSpare);
            }
            case "part_onvehicle": {
                return new ComputedVariable(this.vehicleOn != null);
            }
            case "part_added_vehicle": {
                return new ComputedVariable(this, variable, partialTicks -> this.vehicleOn != null && this.newlyAddedVar.isActive && this.ticksExisted == 2L ? 1.0 : 0.0, false);
            }
            case "part_removed_vehicle": {
                return new ComputedVariable(this, variable, partialTicks -> this.vehicleOn != null && !this.isValid ? 1.0 : 0.0, false);
            }
            case "part_added_ground": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityOn instanceof EntityPlacedPart && this.newlyAddedVar.isActive && this.ticksExisted == 2L ? 1.0 : 0.0, false);
            }
            case "part_removed_ground": {
                return new ComputedVariable(this, variable, partialTicks -> this.entityOn instanceof EntityPlacedPart && !this.isValid ? 1.0 : 0.0, false);
            }
        }
        ComputedVariable computedVariable = super.createComputedVariable(variable, false);
        if (computedVariable == null) {
            AEntityF_Multipart<?> testEntity = this.entityOn;
            while (testEntity != null) {
                if (testEntity.containsVariable(variable)) {
                    return testEntity.getOrCreateVariable(variable);
                }
                computedVariable = testEntity.createComputedVariable(variable, false);
                if (computedVariable == null && testEntity instanceof APart) {
                    testEntity = ((APart)testEntity).entityOn;
                    continue;
                }
                testEntity = null;
            }
            if (computedVariable != null) {
                return computedVariable;
            }
            if (createDefaultIfNotPresent) {
                ComputedVariable newVariable = new ComputedVariable(this, variable, null);
                this.addVariable(newVariable);
                return newVariable;
            }
            return null;
        }
        return computedVariable;
    }

    @Override
    public int getWorldLightValue() {
        return this.masterEntity.worldLightValue;
    }

    @Override
    public boolean disableRendering() {
        return super.disableRendering() || this.isFake() || this.isInvisible;
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        if (this.canBeClicked()) {
            super.renderBoundingBoxes(transform);
        }
    }
}

