/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import com.google.common.collect.Streams;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import mcinterface1201.ABuilderEntityBase;
import mcinterface1201.BuilderBlock;
import mcinterface1201.BuilderEntityExisting;
import mcinterface1201.BuilderEntityLinkedSeat;
import mcinterface1201.BuilderEntityRenderForwarder;
import mcinterface1201.BuilderTileEntity;
import mcinterface1201.WrapperEntity;
import mcinterface1201.WrapperItemStack;
import mcinterface1201.WrapperNBT;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.mixin.common.BiomeMixin;
import mcinterface1201.mixin.common.ConcretePowderBlockMixin;
import mcinterface1201.mixin.common.DimensionDataStorageMixin;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataRequest;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataUpdate;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class WrapperWorld
extends AWrapperWorld {
    private static final Map<Level, WrapperWorld> worldWrappers = new HashMap<Level, WrapperWorld>();
    private final Map<UUID, BuilderEntityExisting> playerServerGunBuilders = new HashMap<UUID, BuilderEntityExisting>();
    private final Map<UUID, Integer> ticksSincePlayerJoin = new HashMap<UUID, Integer>();
    private static Map<UUID, BuilderEntityRenderForwarder> playerFollowers = new HashMap<UUID, BuilderEntityRenderForwarder>();
    private final List<AABB> mutableCollidingAABBs = new ArrayList<AABB>();
    private final Set<BlockPos> knownAirBlocks = new HashSet<BlockPos>();
    protected final Level world;
    private final IWrapperNBT savedData;
    private static HashMap<TagKey<Block>, ABlockBase.BlockMaterial> blockTagMap = new HashMap();
    private static HashMap<TagKey<Fluid>, ABlockBase.BlockMaterial> fluidTagMap = new HashMap();

    public static WrapperWorld getWrapperFor(Level world) {
        if (world != null) {
            WrapperWorld wrapper = worldWrappers.get(world);
            if (wrapper == null || world != wrapper.world) {
                wrapper = new WrapperWorld(world);
                worldWrappers.put(world, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    private WrapperWorld(Level world) {
        this.world = world;
        if (world.f_46443_) {
            this.savedData = InterfaceManager.coreInterface.getNewNBTWrapper();
            InterfaceManager.packetInterface.sendToServer(new PacketWorldSavedDataRequest(InterfaceManager.clientInterface.getClientPlayer()));
        } else {
            try {
                this.savedData = this.getDataFile().exists() ? new WrapperNBT(NbtIo.m_128939_((InputStream)Files.newInputStream(this.getDataFile().toPath(), new OpenOption[0]))) : InterfaceManager.coreInterface.getNewNBTWrapper();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not load saved data from disk!  This will result in data loss if we continue!");
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public AWrapperWorld getWorld() {
        return this;
    }

    @Override
    public boolean isClient() {
        return this.world.f_46443_;
    }

    @Override
    public long getTime() {
        return this.world.m_46468_() % 24000L;
    }

    @Override
    public String getName() {
        return this.world.m_46472_().m_135782_().m_135815_();
    }

    @Override
    public long getMaxHeight() {
        return this.world.m_141928_();
    }

    @Override
    public void beginProfiling(String name, boolean subProfile) {
        if (subProfile) {
            this.world.m_46473_().m_6180_(name);
        } else {
            this.world.m_46473_().m_6182_(name);
        }
    }

    @Override
    public void endProfiling() {
        this.world.m_46473_().m_7238_();
    }

    @Override
    public IWrapperNBT getData(String name) {
        if (name.isEmpty()) {
            return this.savedData;
        }
        return this.savedData.getData(name);
    }

    @Override
    public void setData(String name, IWrapperNBT value) {
        this.savedData.setData(name, value);
        if (!this.isClient()) {
            try {
                NbtIo.m_128947_((CompoundTag)((WrapperNBT)this.savedData).tag, (OutputStream)Files.newOutputStream(this.getDataFile().toPath(), new OpenOption[0]));
                InterfaceManager.packetInterface.sendToAllClients(new PacketWorldSavedDataUpdate(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not save data to disk!  This will result in data loss if we continue!");
            }
        }
    }

    @Override
    public File getDataFile() {
        return new File(((DimensionDataStorageMixin)((ServerLevel)this.world).m_8895_()).getDataFolder(), "mtsdata.dat");
    }

    @Override
    public WrapperEntity getExternalEntity(UUID entityID) {
        if (this.world instanceof ServerLevel) {
            return WrapperEntity.getWrapperFor(((ServerLevel)this.world).m_8791_(entityID));
        }
        for (Entity entity : ((ClientLevel)this.world).m_104735_()) {
            if (!entity.m_20148_().equals(entityID)) continue;
            return WrapperEntity.getWrapperFor(entity);
        }
        return null;
    }

    @Override
    public List<IWrapperEntity> getEntitiesWithin(BoundingBox box) {
        ArrayList<IWrapperEntity> entities = new ArrayList<IWrapperEntity>();
        for (LivingEntity entity : this.world.m_45976_(LivingEntity.class, WrapperWorld.convert(box))) {
            entities.add(WrapperEntity.getWrapperFor((Entity)entity));
        }
        return entities;
    }

    @Override
    public List<IWrapperPlayer> getPlayersWithin(BoundingBox box) {
        ArrayList<IWrapperPlayer> players = new ArrayList<IWrapperPlayer>();
        for (Player player : this.world.m_45976_(Player.class, WrapperWorld.convert(box))) {
            players.add(WrapperPlayer.getWrapperFor(player));
        }
        return players;
    }

    @Override
    public List<IWrapperEntity> getEntitiesHostile(IWrapperEntity lookingEntity, double radius) {
        ArrayList<IWrapperEntity> entities = new ArrayList<IWrapperEntity>();
        Entity mcLooker = ((WrapperEntity)lookingEntity).entity;
        for (Entity entity : this.world.m_45933_(mcLooker, mcLooker.m_20191_().m_82400_(radius))) {
            if (!(entity instanceof Mob) || !entity.m_6084_() || entity instanceof LivingEntity && ((LivingEntity)entity).f_20919_ != 0) continue;
            entities.add(WrapperEntity.getWrapperFor(entity));
        }
        return entities;
    }

    @Override
    public void spawnEntity(AEntityB_Existing entity) {
        this.spawnEntityInternal(entity);
    }

    protected BuilderEntityExisting spawnEntityInternal(AEntityB_Existing entity) {
        BuilderEntityExisting builder = new BuilderEntityExisting((EntityType<? extends BuilderEntityExisting>)((EntityType)BuilderEntityExisting.E_TYPE2.get()), ((WrapperWorld)entity.world).world);
        builder.loadedFromSavedNBT = true;
        builder.m_6034_(entity.position.x, entity.position.y, entity.position.z);
        builder.entity = entity;
        this.world.m_7967_((Entity)builder);
        this.addEntity(entity);
        return builder;
    }

    @Override
    public List<IWrapperEntity> attackEntities(Damage damage, Point3D motion, boolean generateList) {
        AABB mcBox = WrapperWorld.convert(damage.box);
        if (motion != null) {
            mcBox = mcBox.m_82377_(motion.x, motion.y, motion.z);
        }
        List collidedEntities = this.world.m_45976_(Entity.class, mcBox);
        Vec3 start = null;
        Vec3 end = null;
        ArrayList<IWrapperEntity> hitEntities = new ArrayList<IWrapperEntity>();
        if (motion != null) {
            Point3D startPoint = damage.box.globalCenter;
            Point3D endPoint = damage.box.globalCenter.copy().add(motion);
            start = new Vec3(startPoint.x, startPoint.y, startPoint.z);
            end = new Vec3(endPoint.x, endPoint.y, endPoint.z);
        }
        for (Entity mcEntityCollided : collidedEntities) {
            Entity mcRidingEntity;
            if (mcEntityCollided instanceof ABuilderEntityBase) continue;
            if (damage.damgeSource != null && (mcRidingEntity = mcEntityCollided.m_20202_()) instanceof BuilderEntityLinkedSeat) {
                AEntityB_Existing internalRidingEntity = ((BuilderEntityLinkedSeat)mcRidingEntity).entity;
                if (damage.damgeSource == internalRidingEntity) continue;
                if (internalRidingEntity instanceof APart) {
                    APart ridingPart = (APart)internalRidingEntity;
                    if (ridingPart.masterEntity.allParts.contains(damage.damgeSource)) continue;
                }
            }
            if (motion != null && !mcEntityCollided.m_20191_().m_82371_(start, end).isPresent()) continue;
            hitEntities.add(WrapperEntity.getWrapperFor(mcEntityCollided));
        }
        if (generateList) {
            return hitEntities;
        }
        for (IWrapperEntity entity : hitEntities) {
            entity.attack(damage);
        }
        return null;
    }

    @Override
    public void loadEntities(BoundingBox box, AEntityE_Interactable<?> entityToLoad) {
        block0: for (LivingEntity entity : this.world.m_45976_(LivingEntity.class, WrapperWorld.convert(box))) {
            if (entity.m_20202_() != null || entity instanceof Monster) continue;
            if (entityToLoad instanceof EntityVehicleF_Physics) {
                for (APart part : ((EntityVehicleF_Physics)entityToLoad).allParts) {
                    if (!(part instanceof PartSeat) || part.rider != null || part.placementDefinition.isController) continue;
                    part.setRider(new WrapperEntity((Entity)entity), true);
                    continue block0;
                }
                continue;
            }
            if (entityToLoad.rider != null) continue;
            entityToLoad.setRider(new WrapperEntity((Entity)entity), true);
            break;
        }
    }

    @Override
    public void populateItemStackEntities(Map<IWrapperEntity, IWrapperItemStack> map, BoundingBox box) {
        for (ItemEntity mcEntity : this.world.m_45976_(ItemEntity.class, WrapperWorld.convert(box))) {
            WrapperEntity entity = WrapperEntity.getWrapperFor((Entity)mcEntity);
            if (map.containsKey(entity)) continue;
            map.put(entity, new WrapperItemStack(mcEntity.m_32055_()));
        }
    }

    @Override
    public void removeItemStackEntity(IWrapperEntity entity) {
        ((WrapperEntity)entity).entity.m_6074_();
    }

    @Override
    public boolean isInsideBorder(Point3D position) {
        return this.world.m_6857_().m_61937_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z));
    }

    @Override
    public boolean chunkLoaded(Point3D position) {
        return this.world.m_46749_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z));
    }

    @Override
    public ABlockBase getBlock(Point3D position) {
        Block block = this.world.m_8055_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z)).m_60734_();
        return block instanceof BuilderBlock ? ((BuilderBlock)block).block : null;
    }

    @Override
    public String getBlockName(Point3D position) {
        return ForgeRegistries.BLOCKS.getKey((Object)this.world.m_8055_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z)).m_60734_()).toString();
    }

    @Override
    public float getBlockHardness(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        float hardness = this.world.m_8055_(pos).m_60800_((BlockGetter)this.world, pos);
        if (hardness < 0.0f) {
            hardness = Float.MAX_VALUE;
        }
        return hardness;
    }

    @Override
    public float getBlockSlipperiness(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        BlockState state = this.world.m_8055_(pos);
        return state.m_60734_().getFriction(state, (LevelReader)this.world, pos, null);
    }

    @Override
    public ABlockBase.BlockMaterial getBlockMaterial(Point3D position) {
        BlockPos pos;
        if (blockTagMap.isEmpty()) {
            blockTagMap.put((TagKey<Block>)BlockTags.f_144274_, ABlockBase.BlockMaterial.DIRT);
            blockTagMap.put((TagKey<Block>)BlockTags.f_13047_, ABlockBase.BlockMaterial.ICE);
            blockTagMap.put((TagKey<Block>)BlockTags.f_13035_, ABlockBase.BlockMaterial.LEAVES);
            blockTagMap.put((TagKey<Block>)BlockTags.f_13029_, ABlockBase.BlockMaterial.SAND);
            blockTagMap.put((TagKey<Block>)BlockTags.f_144279_, ABlockBase.BlockMaterial.SNOW);
            blockTagMap.put((TagKey<Block>)BlockTags.f_13090_, ABlockBase.BlockMaterial.WOOD);
            blockTagMap.put((TagKey<Block>)BlockTags.f_13089_, ABlockBase.BlockMaterial.WOOL);
            fluidTagMap.put((TagKey<Fluid>)FluidTags.f_13132_, ABlockBase.BlockMaterial.LAVA);
            fluidTagMap.put((TagKey<Fluid>)FluidTags.f_13131_, ABlockBase.BlockMaterial.WATER);
        }
        if (this.world.m_46859_(pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z))) {
            return null;
        }
        BlockState state = this.world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof GrassBlock) {
            return ABlockBase.BlockMaterial.GRASS;
        }
        if (block instanceof AbstractGlassBlock) {
            return ABlockBase.BlockMaterial.GLASS;
        }
        if (block instanceof GravelBlock) {
            return ABlockBase.BlockMaterial.GRAVEL;
        }
        for (TagKey tagKey : Streams.concat((Stream[])new Stream[]{state.m_204343_(), state.m_60819_().m_205075_()}).toList()) {
            ABlockBase.BlockMaterial material = blockTagMap.get(tagKey);
            if (material == null) continue;
            return material;
        }
        return ABlockBase.BlockMaterial.NORMAL;
    }

    @Override
    public ColorRGB getBlockColor(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        BlockState state = this.world.m_8055_(pos);
        MapColor mcColor = state.m_284242_((BlockGetter)this.world, pos);
        return new ColorRGB(mcColor.f_283871_);
    }

    @Override
    public List<IWrapperItemStack> getBlockDrops(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        BlockState state = this.world.m_8055_(pos);
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.world), (BlockPos)pos, (BlockEntity)this.world.m_7702_(pos));
        ArrayList<IWrapperItemStack> convertedList = new ArrayList<IWrapperItemStack>();
        for (ItemStack stack : drops) {
            convertedList.add(new WrapperItemStack(stack.m_41777_()));
        }
        return convertedList;
    }

    @Override
    public minecrafttransportsimulator.baseclasses.BlockHitResult getBlockHit(Point3D position, Point3D delta) {
        BlockPos blockPos;
        Vec3 start = new Vec3(position.x, position.y, position.z);
        BlockHitResult trace = this.world.m_45547_(new ClipContext(start, start.m_82520_(delta.x, delta.y, delta.z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (trace.m_6662_() != HitResult.Type.MISS && (blockPos = trace.m_82425_()) != null) {
            Vec3 pos = trace.m_82450_();
            return new minecrafttransportsimulator.baseclasses.BlockHitResult(new Point3D(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), new Point3D(pos.f_82479_, pos.f_82480_, pos.f_82481_), ABlockBase.Axis.valueOf(trace.m_82434_().name()));
        }
        return null;
    }

    @Override
    public boolean isBlockSolid(Point3D position, ABlockBase.Axis axis) {
        if (axis.blockBased) {
            BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
            BlockState state = this.world.m_8055_(pos);
            Block offsetMCBlock = state.m_60734_();
            Direction facing = Direction.valueOf((String)axis.name());
            return offsetMCBlock != null && !offsetMCBlock.equals(Blocks.f_50375_) && state.m_60783_((BlockGetter)this.world, pos, facing);
        }
        return false;
    }

    @Override
    public boolean isBlockLiquid(Point3D position) {
        return this.world.m_8055_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z)).m_278721_();
    }

    @Override
    public boolean isBlockBelowBottomSlab(Point3D position) {
        BlockState state = this.world.m_8055_(BlockPos.m_274561_((double)position.x, (double)(position.y - 1.0), (double)position.z));
        return state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM;
    }

    @Override
    public boolean isBlockAboveTopSlab(Point3D position) {
        BlockState state = this.world.m_8055_(BlockPos.m_274561_((double)position.x, (double)(position.y + 1.0), (double)position.z));
        return state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP;
    }

    @Override
    public double getHeight(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        boolean bottomSlab = false;
        while (pos.m_123342_() > this.world.m_141937_()) {
            if (!this.world.m_46859_(pos)) {
                BlockState state = this.world.m_8055_(pos);
                bottomSlab = state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM;
                pos = pos.m_7494_();
                break;
            }
            pos = pos.m_7495_();
        }
        return bottomSlab ? position.y - ((double)pos.m_123342_() - 0.5) : position.y - (double)pos.m_123342_();
    }

    @Override
    public void updateBoundingBoxCollisions(BoundingBox box, Point3D collisionMotion, boolean ignoreIfGreater) {
        AABB mcBox = WrapperWorld.convert(box);
        VoxelShape mcShape = Shapes.m_83064_((AABB)mcBox);
        box.collidingBlockPositions.clear();
        this.mutableCollidingAABBs.clear();
        int i = (int)Math.floor(mcBox.f_82288_);
        while ((double)i < Math.ceil(mcBox.f_82291_)) {
            int j = (int)Math.floor(mcBox.f_82289_);
            while ((double)j < Math.ceil(mcBox.f_82292_)) {
                int k = (int)Math.floor(mcBox.f_82290_);
                while ((double)k < Math.ceil(mcBox.f_82293_)) {
                    BlockPos pos = BlockPos.m_274561_((double)i, (double)j, (double)k);
                    if (!this.world.m_46859_(pos)) {
                        BlockState state = this.world.m_8055_(pos);
                        VoxelShape collisionShape = state.m_60812_((BlockGetter)this.world, pos).m_83216_((double)i, (double)j, (double)k);
                        if (!collisionShape.m_83281_() && Shapes.m_83157_((VoxelShape)mcShape, (VoxelShape)collisionShape, (BooleanOp)BooleanOp.f_82689_) && !state.m_204336_(BlockTags.f_13035_)) {
                            this.mutableCollidingAABBs.addAll(collisionShape.m_83299_());
                            box.collidingBlockPositions.add(new Point3D(i, j, k));
                        }
                        if (box.collidesWithLiquids && state.m_278721_()) {
                            this.mutableCollidingAABBs.add(Shapes.m_83144_().m_83215_().m_82338_(pos));
                            box.collidingBlockPositions.add(new Point3D(i, j, k));
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        box.currentCollisionDepth.set(0.0, 0.0, 0.0);
        for (AABB colBox : this.mutableCollidingAABBs) {
            double boxCollisionDepth;
            double boxCollisionDepth2;
            double boxCollisionDepth3;
            if (collisionMotion.x > 0.0) {
                double boxCollisionDepth4 = mcBox.f_82291_ - colBox.f_82288_;
                if (box.currentCollisionDepth.x < boxCollisionDepth4) {
                    box.currentCollisionDepth.x = boxCollisionDepth4;
                }
            } else if (collisionMotion.x < 0.0 && box.currentCollisionDepth.x > (boxCollisionDepth3 = -(colBox.f_82291_ - mcBox.f_82288_))) {
                box.currentCollisionDepth.x = boxCollisionDepth3;
            }
            if (collisionMotion.y > 0.0) {
                double boxCollisionDepth5 = mcBox.f_82292_ - colBox.f_82289_;
                if (box.currentCollisionDepth.y < boxCollisionDepth5) {
                    box.currentCollisionDepth.y = boxCollisionDepth5;
                }
            } else if (collisionMotion.y < 0.0 && box.currentCollisionDepth.y > (boxCollisionDepth2 = -(colBox.f_82292_ - mcBox.f_82289_))) {
                box.currentCollisionDepth.y = boxCollisionDepth2;
            }
            if (collisionMotion.z > 0.0) {
                double boxCollisionDepth6 = mcBox.f_82293_ - colBox.f_82290_;
                if (!(box.currentCollisionDepth.z < boxCollisionDepth6)) continue;
                box.currentCollisionDepth.z = boxCollisionDepth6;
                continue;
            }
            if (!(collisionMotion.z < 0.0) || !(box.currentCollisionDepth.z > (boxCollisionDepth = -(colBox.f_82293_ - mcBox.f_82290_)))) continue;
            box.currentCollisionDepth.z = boxCollisionDepth;
        }
        if (ignoreIfGreater) {
            if (collisionMotion.x > 0.0 && box.currentCollisionDepth.x > collisionMotion.x) {
                box.currentCollisionDepth.x = collisionMotion.x;
            } else if (collisionMotion.x < 0.0 && box.currentCollisionDepth.x < collisionMotion.x) {
                box.currentCollisionDepth.x = collisionMotion.x;
            }
            if (collisionMotion.y > 0.0 && box.currentCollisionDepth.y > collisionMotion.y) {
                box.currentCollisionDepth.y = collisionMotion.y;
            } else if (collisionMotion.y < 0.0 && box.currentCollisionDepth.y < collisionMotion.y) {
                box.currentCollisionDepth.y = collisionMotion.y;
            }
            if (collisionMotion.z > 0.0 && box.currentCollisionDepth.z > collisionMotion.z) {
                box.currentCollisionDepth.z = collisionMotion.z;
            } else if (collisionMotion.z < 0.0 && box.currentCollisionDepth.z < collisionMotion.z) {
                box.currentCollisionDepth.z = collisionMotion.z;
            }
        }
        if (box.currentCollisionDepth.isZero()) {
            box.collidingBlockPositions.clear();
        }
    }

    @Override
    public boolean checkForCollisions(BoundingBox box, Point3D offset, boolean clearCache, boolean breakLeaves) {
        if (clearCache) {
            this.knownAirBlocks.clear();
        }
        this.mutableCollidingAABBs.clear();
        AABB mcBox = WrapperWorld.convertWithOffset(box, offset.x, offset.y, offset.z);
        VoxelShape mcShape = Shapes.m_83064_((AABB)mcBox);
        int i = (int)Math.floor(mcBox.f_82288_);
        while ((double)i < Math.ceil(mcBox.f_82291_)) {
            int j = (int)Math.floor(mcBox.f_82289_);
            while ((double)j < Math.ceil(mcBox.f_82292_)) {
                int k = (int)Math.floor(mcBox.f_82290_);
                while ((double)k < Math.ceil(mcBox.f_82293_)) {
                    BlockPos pos = BlockPos.m_274561_((double)i, (double)j, (double)k);
                    if (!this.knownAirBlocks.contains(pos) && this.world.m_46749_(pos)) {
                        BlockState state = this.world.m_8055_(pos);
                        VoxelShape collisionShape = state.m_60812_((BlockGetter)this.world, pos).m_83216_((double)i, (double)j, (double)k);
                        if (!state.m_204336_(BlockTags.f_13035_)) {
                            if (collisionShape != null && !collisionShape.m_83281_() && Shapes.m_83157_((VoxelShape)mcShape, (VoxelShape)collisionShape, (BooleanOp)BooleanOp.f_82689_)) {
                                return true;
                            }
                            this.knownAirBlocks.add(pos);
                            if (box.collidesWithLiquids && state.m_278721_() && mcBox.m_82381_(Shapes.m_83144_().m_83215_().m_82338_(pos))) {
                                return true;
                            }
                        } else if (breakLeaves) {
                            this.world.m_46961_(pos, false);
                        } else {
                            this.knownAirBlocks.add(pos);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getRedstonePower(Point3D position) {
        return this.world.m_277086_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z));
    }

    @Override
    public float getRainStrength(Point3D position) {
        return this.world.m_46758_(BlockPos.m_274561_((double)position.x, (double)(position.y + 1.0), (double)position.z)) ? this.world.m_46722_(1.0f) + this.world.m_46661_(1.0f) : 0.0f;
    }

    @Override
    public float getTemperature(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        return ((BiomeMixin)this.world.m_204166_(pos).m_203334_()).invoke_getTemperature(pos);
    }

    @Override
    public <TileEntityType extends ATileEntityBase<JSONDefinition>, JSONDefinition extends AJSONMultiModelProvider> boolean setBlock(ABlockBase block, Point3D position, IWrapperPlayer playerWrapper, ABlockBase.Axis axis) {
        if (!this.world.f_46443_) {
            BuilderBlock wrapper = BuilderBlock.blockMap.get(block);
            BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
            if (playerWrapper != null) {
                BlockState newState;
                Player mcPlayer = ((WrapperPlayer)playerWrapper).player;
                WrapperItemStack stack = (WrapperItemStack)playerWrapper.getHeldStack();
                AItemBase item = stack.getItem();
                Direction facing = Direction.valueOf((String)axis.name());
                if (!this.world.m_46859_(pos)) {
                    pos = pos.m_121945_(facing);
                    position.add(facing.m_122429_(), facing.m_122430_(), facing.m_122431_());
                }
                if (item != null && this.world.m_7966_(mcPlayer, pos) && this.world.m_46859_(pos) && this.world.m_7731_(pos, newState = wrapper.m_49966_(), 11)) {
                    if (block instanceof ABlockBaseTileEntity) {
                        BuilderTileEntity builderTile = (BuilderTileEntity)this.world.m_7702_(pos);
                        IWrapperNBT data = stack.getData();
                        if (data != null) {
                            data.deleteAllUUIDTags();
                        }
                        builderTile.setTileEntity(((ABlockBaseTileEntity)block).createTileEntity(this, position, playerWrapper, (AItemSubTyped)item, data));
                        this.addEntity(builderTile.tileEntity);
                    }
                    stack.add(-1);
                    return true;
                }
            } else {
                BlockState newState = wrapper.m_49966_();
                return this.world.m_7731_(pos, newState, 11);
            }
        }
        return false;
    }

    @Override
    public <TileEntityType extends ATileEntityBase<?>> TileEntityType getTileEntity(Point3D position) {
        BlockEntity tile = this.world.m_7702_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z));
        return (TileEntityType)(tile instanceof BuilderTileEntity ? ((BuilderTileEntity)tile).tileEntity : null);
    }

    @Override
    public void markTileEntityChanged(Point3D position) {
        this.world.m_7702_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z)).m_6596_();
    }

    @Override
    public float getLightBrightness(Point3D position, boolean calculateBlock) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        float darkenFactor = (float)(15 * this.world.m_7445_()) / 11.0f;
        float sunLight = ((float)this.world.m_45517_(LightLayer.SKY, pos) - darkenFactor) / 15.0f;
        float blockLight = calculateBlock ? (float)this.world.m_45517_(LightLayer.BLOCK, pos) / 15.0f : 0.0f;
        return Math.max(sunLight, blockLight);
    }

    @Override
    public void updateLightBrightness(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        this.world.m_5518_().m_7174_(pos);
    }

    @Override
    public void destroyBlock(Point3D position, boolean spawnDrops) {
        this.world.m_46961_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z), spawnDrops);
    }

    @Override
    public boolean isAir(Point3D position) {
        return this.world.m_46859_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z));
    }

    @Override
    public boolean isFire(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        return this.world.m_8055_(pos).m_204336_(BlockTags.f_13076_);
    }

    @Override
    public void setToFire(Point3D position, ABlockBase.Axis side) {
        BlockPos blockpos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z).m_121945_(Direction.valueOf((String)side.name()));
        if (this.world.m_46859_(blockpos)) {
            this.world.m_46597_(blockpos, Blocks.f_50083_.m_49966_());
        }
    }

    @Override
    public void extinguish(Point3D position, ABlockBase.Axis side) {
        BlockPos blockpos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z).m_121945_(Direction.valueOf((String)side.name()));
        if (this.world.m_8055_(blockpos).m_204336_(BlockTags.f_13076_)) {
            this.world.m_7471_(blockpos, false);
        }
    }

    @Override
    public boolean placeBlock(Point3D position, IWrapperItemStack stack) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        if (this.world.m_46859_(pos)) {
            Block mcBlock;
            ItemStack mcStack = ((WrapperItemStack)stack).stack.m_41777_();
            Item mcItem = mcStack.m_41720_();
            Block block = mcBlock = mcItem instanceof BlockItem ? ((BlockItem)mcItem).m_40614_() : null;
            if (!(mcItem.m_41472_() || mcItem instanceof StandingAndWallBlockItem || mcBlock instanceof PistonBaseBlock || mcBlock instanceof LanternBlock || mcBlock instanceof LadderBlock || mcStack.m_41661_(new UseOnContext(this.world, null, InteractionHand.MAIN_HAND, mcStack, new BlockHitResult(new Vec3(position.x, position.y, position.z), Direction.UP, pos, true))) != InteractionResult.CONSUME)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean fertilizeBlock(Point3D position, IWrapperItemStack stack) {
        BonemealableBlock growable;
        BlockPos cropPos;
        BlockState cropState;
        Block cropBlock;
        ItemStack mcStack = ((WrapperItemStack)stack).stack;
        if (mcStack.m_41720_() == Items.f_42499_ && !this.world.f_46443_ && (cropBlock = (cropState = this.world.m_8055_(cropPos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z))).m_60734_()) instanceof BonemealableBlock && (growable = (BonemealableBlock)cropState.m_60734_()).m_7370_((LevelReader)this.world, cropPos, cropState, this.world.f_46443_)) {
            growable.m_214148_((ServerLevel)this.world, this.world.f_46441_, cropPos, cropState);
            return true;
        }
        return false;
    }

    @Override
    public List<IWrapperItemStack> harvestBlock(Point3D position) {
        ArrayList<IWrapperItemStack> cropDrops;
        block5: {
            BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
            BlockState state = this.world.m_8055_(pos);
            cropDrops = new ArrayList<IWrapperItemStack>();
            if ((!(state.m_60734_() instanceof CropBlock) || !((CropBlock)state.m_60734_()).m_52307_(state)) && !(state.m_60734_() instanceof BushBlock)) break block5;
            Block harvestedBlock = state.m_60734_();
            this.world.m_5594_(null, pos, harvestedBlock.getSoundType(state, (LevelReader)this.world, pos, null).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!this.world.f_46443_) {
                List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.world), (BlockPos)pos, (BlockEntity)this.world.m_7702_(pos));
                this.world.m_7471_(pos, false);
                if (harvestedBlock instanceof CropBlock) {
                    for (ItemStack drop : drops) {
                        cropDrops.add(new WrapperItemStack(drop.m_41777_()));
                    }
                } else {
                    for (ItemStack stack : drops) {
                        if (stack.m_41613_() <= 0) continue;
                        this.world.m_7967_((Entity)new ItemEntity(this.world, position.x, position.y, position.z, stack));
                    }
                }
            }
        }
        return cropDrops;
    }

    @Override
    public boolean plantBlock(Point3D position, IWrapperItemStack stack) {
        Block block;
        Item item = ((WrapperItemStack)stack).stack.m_41720_();
        if (item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof IPlantable) {
            BlockPos cropPos;
            IPlantable plantable = (IPlantable)block;
            BlockPos farmlandPos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
            BlockState farmlandState = this.world.m_8055_(farmlandPos);
            Block farmlandBlock = farmlandState.m_60734_();
            if (farmlandBlock instanceof FarmBlock && this.world.m_46859_(cropPos = farmlandPos.m_7494_())) {
                BlockState plantState = plantable.getPlant((BlockGetter)this.world, cropPos);
                if (farmlandBlock.canSustainPlant(farmlandState, (BlockGetter)this.world, farmlandPos, Direction.UP, plantable)) {
                    this.world.m_7731_(cropPos, plantState, 11);
                    this.world.m_5594_(null, farmlandPos, plantState.m_60734_().getSoundType(plantState, (LevelReader)this.world, farmlandPos, null).m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean plowBlock(Point3D position) {
        BlockState newState;
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        BlockState oldState = this.world.m_8055_(pos);
        Block block = oldState.m_60734_();
        if (block == Blocks.f_50440_ || block == Blocks.f_152481_ || block == Blocks.f_50493_) {
            newState = Blocks.f_50093_.m_49966_();
        } else if (block.equals(Blocks.f_50546_)) {
            newState = Blocks.f_50493_.m_49966_();
        } else {
            return false;
        }
        this.world.m_7731_(pos, newState, 11);
        this.world.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    @Override
    public boolean removeSnow(Point3D position) {
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        BlockState state = this.world.m_8055_(pos);
        if (state.m_204336_(BlockTags.f_144279_)) {
            this.world.m_7471_(pos, false);
            this.world.m_5594_(null, pos, SoundEvents.f_12474_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean hydrateBlock(Point3D position) {
        int moisture;
        BlockPos pos = BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z);
        BlockState state = this.world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block == Blocks.f_49991_) {
            if (this.world.m_6425_(pos).m_76170_()) {
                this.world.m_46597_(pos, Blocks.f_50080_.m_49966_());
                return true;
            }
            this.world.m_46597_(pos, Blocks.f_50652_.m_49966_());
            return true;
        }
        if (block instanceof ConcretePowderBlock) {
            this.world.m_46597_(pos, ((ConcretePowderBlockMixin)block).getConcrete());
            return true;
        }
        if (block == Blocks.f_50093_ && (moisture = ((Integer)state.m_61143_((Property)FarmBlock.f_53243_)).intValue()) < 7) {
            this.world.m_46597_(pos, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)));
            return true;
        }
        return false;
    }

    @Override
    public boolean insertStack(Point3D position, ABlockBase.Axis axis, IWrapperItemStack stack) {
        IItemHandler itemHandler;
        Direction facing = Direction.valueOf((String)axis.name());
        BlockEntity tile = this.world.m_7702_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z).m_121945_(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null)) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack remainingStack = itemHandler.insertItem(i, ((WrapperItemStack)stack).stack, true);
                if (remainingStack.m_41613_() >= stack.getSize()) continue;
                IWrapperItemStack stackToInsert = stack.split(1);
                itemHandler.insertItem(i, ((WrapperItemStack)stackToInsert).stack, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public WrapperItemStack extractStack(Point3D position, ABlockBase.Axis axis) {
        IItemHandler itemHandler;
        Direction facing = Direction.valueOf((String)axis.name());
        BlockEntity tile = this.world.m_7702_(BlockPos.m_274561_((double)position.x, (double)position.y, (double)position.z).m_121945_(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null)) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack extractedStack = itemHandler.extractItem(i, 1, false);
                if (extractedStack.m_41619_()) continue;
                return new WrapperItemStack(extractedStack);
            }
        }
        return null;
    }

    @Override
    public void spawnItemStack(IWrapperItemStack stack, Point3D point, Point3D optionalMotion) {
        ItemEntity item;
        if (optionalMotion != null) {
            item = new ItemEntity(this.world, point.x, point.y, point.z, ((WrapperItemStack)stack).stack);
            item.m_20256_(new Vec3(optionalMotion.x, optionalMotion.y, optionalMotion.z));
        } else {
            item = new ItemEntity(this.world, point.x, point.y + 1.0, point.z, ((WrapperItemStack)stack).stack);
        }
        this.world.m_7967_((Entity)item);
    }

    @Override
    public void spawnExplosion(Point3D location, double strength, boolean flames, boolean damageBlocks) {
        this.world.m_255391_(null, location.x, location.y, location.z, (float)strength, flames, damageBlocks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    public static AABB convert(BoundingBox box) {
        return new AABB(box.globalCenter.x - box.widthRadius, box.globalCenter.y - box.heightRadius, box.globalCenter.z - box.depthRadius, box.globalCenter.x + box.widthRadius, box.globalCenter.y + box.heightRadius, box.globalCenter.z + box.depthRadius);
    }

    public static AABB convertWithOffset(BoundingBox box, double x, double y, double z) {
        return new AABB(x + box.globalCenter.x - box.widthRadius, y + box.globalCenter.y - box.heightRadius, z + box.globalCenter.z - box.depthRadius, x + box.globalCenter.x + box.widthRadius, y + box.globalCenter.y + box.heightRadius, z + box.globalCenter.z + box.depthRadius);
    }

    @SubscribeEvent
    public void onIVWorldTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.level.equals(this.world)) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                this.tickAll(true);
                for (Player mcPlayer : event.level.m_6907_()) {
                    BuilderEntityRenderForwarder followerBuilder;
                    UUID playerUUID = mcPlayer.m_20148_();
                    BuilderEntityExisting gunBuilder = this.playerServerGunBuilders.get(playerUUID);
                    if (gunBuilder != null) {
                        if (gunBuilder.m_9236_() != mcPlayer.m_9236_() || !mcPlayer.m_6084_() || !gunBuilder.entity.isValid || gunBuilder.idleTickCounter == 20) {
                            gunBuilder.m_146870_();
                            this.playerServerGunBuilders.remove(playerUUID);
                            this.ticksSincePlayerJoin.remove(playerUUID);
                        } else {
                            ++gunBuilder.idleTickCounter;
                        }
                    }
                    if ((followerBuilder = playerFollowers.get(playerUUID)) != null) {
                        if (followerBuilder.m_9236_() != mcPlayer.m_9236_() || followerBuilder.playerFollowing != mcPlayer || !mcPlayer.m_6084_() || !followerBuilder.m_6084_() || followerBuilder.idleTickCounter == 20) {
                            followerBuilder.m_146870_();
                            playerFollowers.remove(playerUUID);
                            this.ticksSincePlayerJoin.remove(playerUUID);
                            followerBuilder = null;
                        } else {
                            ++followerBuilder.idleTickCounter;
                        }
                    }
                    if (!mcPlayer.m_6084_() || gunBuilder != null && followerBuilder != null) continue;
                    int totalTicksWaited = 0;
                    if (this.ticksSincePlayerJoin.containsKey(playerUUID)) {
                        totalTicksWaited = this.ticksSincePlayerJoin.get(playerUUID);
                    }
                    if (++totalTicksWaited == 60) {
                        WrapperPlayer playerWrapper = WrapperPlayer.getWrapperFor(mcPlayer);
                        if (gunBuilder == null) {
                            EntityPlayerGun entity = new EntityPlayerGun((AWrapperWorld)this, playerWrapper, null);
                            this.playerServerGunBuilders.put(playerUUID, this.spawnEntityInternal(entity));
                        }
                        if (followerBuilder == null) {
                            followerBuilder = new BuilderEntityRenderForwarder(mcPlayer);
                            followerBuilder.loadedFromSavedNBT = true;
                            playerFollowers.put(playerUUID, followerBuilder);
                            this.world.m_7967_((Entity)followerBuilder);
                        }
                        if (!((Boolean)ConfigSystem.settings.general.giveManualsOnJoin.value).booleanValue() || ((List)ConfigSystem.settings.general.joinedPlayers.value).contains(playerUUID)) continue;
                        playerWrapper.getInventory().addStack(((AItemBase)PackParser.getItem("mts", "handbook_car")).getNewStack(null));
                        playerWrapper.getInventory().addStack(((AItemBase)PackParser.getItem("mts", "handbook_plane")).getNewStack(null));
                        ((List)ConfigSystem.settings.general.joinedPlayers.value).add(playerUUID);
                        ConfigSystem.saveToDisk();
                        continue;
                    }
                    this.ticksSincePlayerJoin.put(playerUUID, totalTicksWaited);
                }
            } else {
                this.tickAll(false);
            }
        }
    }

    @SubscribeEvent
    public void onIVWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel() == this.world) {
            for (AEntityA_Base entity : this.allEntities) {
                entity.remove();
            }
            worldWrappers.remove(this.world);
        }
    }
}

