/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import mcinterface1201.BuilderTileEntity;
import mcinterface1201.WrapperItemStack;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class BuilderTileEntityInventoryContainer
extends BuilderTileEntity
implements IItemHandler {
    protected static RegistryObject<BlockEntityType<BuilderTileEntityInventoryContainer>> TE_TYPE2;
    private EntityInventoryContainer inventory;

    public BuilderTileEntityInventoryContainer(BlockPos pos, BlockState state) {
        super((BlockEntityType)TE_TYPE2.get(), pos, state);
    }

    @Override
    protected void setTileEntity(ATileEntityBase<?> tile) {
        super.setTileEntity(tile);
        this.inventory = ((ITileEntityInventoryProvider)((Object)tile)).getInventory();
    }

    public int getSlots() {
        return this.inventory.getSize();
    }

    public ItemStack getStackInSlot(int index) {
        return ((WrapperItemStack)this.inventory.getStack((int)index)).stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.m_41613_() < amount) {
            amount = stack.m_41613_();
        }
        ItemStack extracted = stack.m_41777_();
        extracted.m_41764_(amount);
        if (!simulate) {
            stack.m_41764_(stack.m_41613_() - amount);
            this.inventory.setStack(new WrapperItemStack(stack), slot);
        }
        return extracted;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int amount;
        ItemStack existingStack = this.getStackInSlot(slot);
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack) && (amount = existingStack.m_41741_() - existingStack.m_41613_()) != 0) {
            if (amount > stack.m_41613_()) {
                amount = stack.m_41613_();
            }
            ItemStack remainderStack = stack.m_41777_();
            remainderStack.m_41764_(remainderStack.m_41613_() - amount);
            if (!simulate) {
                existingStack.m_41764_(existingStack.m_41613_() + amount);
                this.inventory.setStack(new WrapperItemStack(existingStack), slot);
            }
            return remainderStack;
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && (facing == Direction.UP || facing == Direction.DOWN)) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }
}

