/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import mcinterface1201.BuilderTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.RegistryObject;

public class BuilderTileEntityEnergyCharger
extends BuilderTileEntity
implements IEnergyStorage {
    protected static RegistryObject<BlockEntityType<BuilderTileEntityEnergyCharger>> TE_TYPE2;
    private ITileEntityEnergyCharger charger;
    private static final int MAX_BUFFER = 1000;
    private int buffer;

    public BuilderTileEntityEnergyCharger(BlockPos pos, BlockState state) {
        super((BlockEntityType)TE_TYPE2.get(), pos, state);
    }

    @Override
    protected void setTileEntity(ATileEntityBase<?> tile) {
        super.setTileEntity(tile);
        this.charger = (ITileEntityEnergyCharger)((Object)tile);
    }

    @Override
    public void tick() {
        double amountToCharge;
        super.tick();
        if (!this.f_58857_.f_46443_ && this.charger != null && this.buffer > 0 && (amountToCharge = this.charger.getChargeAmount()) != 0.0) {
            int amountToRemoveFromBuffer = (int)(amountToCharge / (Double)ConfigSystem.settings.general.rfToElectricityFactor.value);
            if (amountToRemoveFromBuffer > this.buffer) {
                amountToRemoveFromBuffer = this.buffer;
                amountToCharge = (double)amountToRemoveFromBuffer * (Double)ConfigSystem.settings.general.rfToElectricityFactor.value;
            }
            this.charger.chargeEnergy(amountToCharge);
            this.buffer -= amountToRemoveFromBuffer;
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.buffer == 1000) {
            return 0;
        }
        int amountToStore = 1000 - this.buffer;
        if (amountToStore > maxReceive) {
            amountToStore = maxReceive;
        }
        if (!simulate) {
            this.buffer += amountToStore;
        }
        return amountToStore;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.buffer;
    }

    public int getMaxEnergyStored() {
        return 1000;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ENERGY && facing != null) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }
}

