/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1201.BuilderTileEntity;
import mcinterface1201.IBuilderItemInterface;
import mcinterface1201.InterfaceCore;
import mcinterface1201.WrapperNBT;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BuilderItem
extends Item
implements IBuilderItemInterface {
    protected static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mts");
    protected static final Map<AItemBase, BuilderItem> itemMap = new LinkedHashMap<AItemBase, BuilderItem>();
    private final AItemBase item;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public BuilderItem(Item.Properties properties, AItemBase item) {
        super(properties);
        this.item = item;
        itemMap.put(item, this);
        if (item instanceof AItemPack) {
            AItemPack packItem = (AItemPack)item;
            if (((AJSONItem)packItem.definition).general.oreDict != null) {
                String lowerCaseOre = ((AJSONItem)packItem.definition).general.oreDict.toLowerCase(Locale.ROOT);
                List<BuilderItem> items = InterfaceCore.taggedItems.get(lowerCaseOre);
                if (items == null) {
                    items = new ArrayList<BuilderItem>();
                    InterfaceCore.taggedItems.put(lowerCaseOre, items);
                }
                items.add(this);
            }
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (item instanceof ItemItem && ((JSONItem)((ItemItem)item).definition).weapon != null) {
            ItemItem weapon = (ItemItem)item;
            if (((JSONItem)weapon.definition).weapon.attackDamage != 0.0) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", ((JSONItem)weapon.definition).weapon.attackDamage - 1.0, AttributeModifier.Operation.ADDITION));
            }
            if (((JSONItem)weapon.definition).weapon.attackCooldown != 0.0) {
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", 20.0 / ((JSONItem)weapon.definition).weapon.attackCooldown - 4.0, AttributeModifier.Operation.ADDITION));
            }
        }
        this.defaultModifiers = builder.build();
    }

    @Override
    public AItemBase getWrappedItem() {
        return this.item;
    }

    protected String m_41467_() {
        return this.item.getItemName();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltipLines, TooltipFlag flagIn) {
        ArrayList<String> textLines = new ArrayList<String>();
        if (stack.m_41782_()) {
            this.item.addTooltipLines(textLines, new WrapperNBT(stack.m_41783_()));
        } else {
            this.item.addTooltipLines(textLines, InterfaceManager.coreInterface.getNewNBTWrapper());
        }
        textLines.forEach(line -> tooltipLines.add((Component)Component.m_237113_((String)line)));
    }

    public int m_8105_(ItemStack stack) {
        return this.item instanceof IItemFood ? ((IItemFood)((Object)this.item)).getTimeToEat() : 0;
    }

    public UseAnim m_6164_(ItemStack stack) {
        IItemFood food;
        if (this.item instanceof IItemFood && (food = (IItemFood)((Object)this.item)).getTimeToEat() > 0) {
            return food.isDrink() ? UseAnim.DRINK : UseAnim.EAT;
        }
        return UseAnim.NONE;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43724_() == InteractionHand.MAIN_HAND) {
            if (this.item.onBlockClicked(WrapperWorld.getWrapperFor(context.m_43725_()), WrapperPlayer.getWrapperFor(context.m_43723_()), new Point3D(context.m_8083_().m_123341_(), context.m_8083_().m_123342_(), context.m_8083_().m_123343_()), ABlockBase.Axis.valueOf(context.m_43719_().name()))) {
                return InteractionResult.SUCCESS;
            }
            if (context.m_43723_() != null && context.m_43723_().m_6047_()) {
                BlockEntity tile;
                if (!context.m_43725_().f_46443_ && (tile = context.m_43725_().m_7702_(context.m_8083_())) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
                    return ((BuilderTileEntity)tile).tileEntity.interact(WrapperPlayer.getWrapperFor(context.m_43723_())) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
                }
                return InteractionResult.FAIL;
            }
            return this.item instanceof IItemFood && ((IItemFood)((Object)this.item)).getTimeToEat() > 0 ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            if (this.item instanceof IItemFood && ((IItemFood)((Object)this.item)).getTimeToEat() > 0 && player.m_36391_(true) || this.item instanceof ItemPartGun && ((JSONPart)((ItemPartGun)this.item).definition).gun.handHeld) {
                player.m_6672_(hand);
            }
            return this.item.onUsed(WrapperWorld.getWrapperFor(world), WrapperPlayer.getWrapperFor(player)) ? InteractionResultHolder.m_19090_((Object)player.m_21120_(hand)) : InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (this.item instanceof IItemFood) {
            if (entityLiving instanceof Player) {
                IItemFood food = (IItemFood)((Object)this.item);
                Player player = (Player)entityLiving;
                player.m_36324_().m_38707_(food.getHungerAmount(), food.getSaturationAmount());
                List<JSONPotionEffect> effects = food.getEffects();
                if (!world.f_46443_ && effects != null) {
                    for (JSONPotionEffect effect : effects) {
                        Potion potion = Potion.m_43489_((String)effect.name);
                        if (potion != null) {
                            potion.m_43488_().forEach(mcEffect -> entityLiving.m_7292_(new MobEffectInstance(mcEffect.m_19544_(), effect.duration, effect.amplifier, false, true)));
                            continue;
                        }
                        throw new NullPointerException("Potion " + effect.name + " does not exist.");
                    }
                }
                world.m_6263_(player, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
                }
            }
            stack.m_41774_(1);
        }
        return stack;
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return this.item.canBreakBlocks();
    }
}

