/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mcinterface1201.ABuilderEntityBase;
import mcinterface1201.WrapperAABBCollective;
import mcinterface1201.WrapperNBT;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class BuilderEntityExisting
extends ABuilderEntityBase {
    public static RegistryObject<EntityType<BuilderEntityExisting>> E_TYPE2;
    private EntityDimensions mutableDims = new EntityDimensions(1.0f, 1.0f, false);
    protected static final Map<String, IItemEntityProvider.IItemEntityFactory> entityMap;
    protected AEntityB_Existing entity;
    private static Point3D lastExplosionPosition;
    public WrapperAABBCollective collisionBoxes;
    private WrapperAABBCollective interactAttackBoxes;

    public BuilderEntityExisting(EntityType<? extends BuilderEntityExisting> eType, Level world) {
        super(eType, world);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.entity != null) {
            if (!this.entity.isValid) {
                this.m_146870_();
            } else {
                this.m_6034_(this.entity.position.x, this.entity.position.y, this.entity.position.z);
                if (!this.m_9236_().f_46443_) {
                    BlockPos pos = this.m_20183_();
                    if (this.m_9236_().m_151570_(pos) ? this.m_20182_().f_82480_ < 0.0 : !this.m_9236_().m_6857_().m_61937_(pos)) {
                        this.m_146870_();
                        return;
                    }
                }
                if (this.entity instanceof AEntityE_Interactable) {
                    AEntityE_Interactable interactable = (AEntityE_Interactable)this.entity;
                    this.entity.world.beginProfiling("CollisionOverhead", true);
                    this.collisionBoxes = new WrapperAABBCollective(interactable, true);
                    this.m_20011_(this.collisionBoxes);
                    this.interactAttackBoxes = new WrapperAABBCollective(interactable, false);
                    if (this.entity instanceof EntityVehicleF_Physics && interactable.ticksExisted > 1L && interactable.ticksExisted % 20L == 0L) {
                        this.mutableDims = new EntityDimensions((float)Math.max(interactable.encompassingBox.widthRadius * 2.0, interactable.encompassingBox.depthRadius * 2.0), (float)interactable.encompassingBox.heightRadius * 2.0f, false);
                        double maxEntityRadius = this.m_9236_().getMaxEntityRadius();
                        if (maxEntityRadius < interactable.encompassingBox.widthRadius || maxEntityRadius < interactable.encompassingBox.heightRadius || maxEntityRadius < interactable.encompassingBox.depthRadius) {
                            maxEntityRadius = Math.max(Math.max(interactable.encompassingBox.widthRadius, interactable.encompassingBox.depthRadius), interactable.encompassingBox.heightRadius);
                            if (maxEntityRadius < 150.0) {
                                this.m_9236_().increaseMaxEntityRadius(maxEntityRadius);
                            } else {
                                InterfaceManager.coreInterface.logError("Attempted to set the world entity max size to way too big of a number (" + maxEntityRadius + ") for " + String.valueOf(this.entity) + "  Removing entity from world as this is likely a pack error that will cause lots of TPS loss!");
                                this.m_146870_();
                            }
                        }
                    }
                    this.entity.world.endProfiling();
                }
            }
        } else if (!this.loadedFromSavedNBT && this.loadFromSavedNBT) {
            WrapperWorld worldWrapper = WrapperWorld.getWrapperFor(this.m_9236_());
            try {
                WrapperNBT data = new WrapperNBT(this.lastLoadedNBT);
                this.entity = entityMap.get(this.lastLoadedNBT.m_128461_("entityid")).restoreEntityFromData(worldWrapper, data);
                this.entity.world.addEntity(this.entity);
                if (this.entity instanceof AEntityF_Multipart) {
                    ((AEntityF_Multipart)this.entity).addPartsPostAddition(null, data);
                }
                this.loadedFromSavedNBT = true;
                this.lastLoadedNBT = null;
            }
            catch (Exception e) {
                InterfaceManager.coreInterface.logError("Failed to load entity on builder from saved NBT.  Did a pack change?");
                InterfaceManager.coreInterface.logError(e.getMessage());
                this.m_146870_();
            }
        }
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.mutableDims;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)ConfigSystem.settings.damage.allowExternalDamage.value).booleanValue() && !this.m_9236_().f_46443_ && this.entity instanceof AEntityF_Multipart) {
            WrapperPlayer playerSource;
            AEntityF_Multipart multipart = (AEntityF_Multipart)this.entity;
            if (multipart instanceof EntityVehicleF_Physics) {
                amount = (float)((double)amount * ConfigSystem.externalDamageOverrides.overrides.get(((AJSONPartProvider)multipart.definition).packID).get(((AJSONPartProvider)multipart.definition).systemName));
            }
            Entity attacker = source.m_7640_();
            Entity trueSource = source.m_7639_();
            WrapperPlayer wrapperPlayer = playerSource = trueSource instanceof Player ? WrapperPlayer.getWrapperFor((Player)trueSource) : null;
            if (lastExplosionPosition != null && source.m_269533_(DamageTypeTags.f_268415_)) {
                BoundingBox explosiveBounds = new BoundingBox(lastExplosionPosition, amount, amount, amount);
                for (BoundingBox box : this.interactAttackBoxes.getBoxes()) {
                    if (!box.intersects(explosiveBounds)) continue;
                    multipart.attack(new Damage(amount, box, null, playerSource, null).setExplosive());
                }
                lastExplosionPosition = null;
            } else if (attacker != null) {
                Point3D endPosition;
                Collection<BoundingBoxHitResult> hitResults;
                Vec3 attackerMcPos = attacker.m_20182_();
                Point3D attackerPosition = new Point3D(attackerMcPos.f_82479_, attackerMcPos.f_82480_, attackerMcPos.f_82481_);
                for (BoundingBox box : this.interactAttackBoxes.getBoxes()) {
                    if (!box.isPointInside(attackerPosition, null)) continue;
                    multipart.attack(new Damage(amount, box, null, playerSource, null));
                    return true;
                }
                Vec3 mcMovement = attacker.m_20184_();
                if (mcMovement.m_82556_() != 0.0 && (hitResults = multipart.getHitBoxes(attackerPosition, endPosition = attackerPosition.copy().add(mcMovement.f_82479_, mcMovement.f_82480_, mcMovement.f_82481_), new BoundingBox(attackerPosition, endPosition), false)) != null) {
                    multipart.attackProjectile(new Damage(amount, null, null, playerSource, null), null, hitResults);
                }
            }
        }
        return true;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return this.entity instanceof EntityVehicleF_Physics || this.entity instanceof EntityPlacedPart;
    }

    @Override
    public CompoundTag m_20240_(CompoundTag tag) {
        super.m_20240_(tag);
        if (this.entity != null) {
            this.entity.save(new WrapperNBT(tag));
            tag.m_128359_("entityid", this.entity.getClass().getSimpleName());
        }
        return tag;
    }

    @SubscribeEvent
    public static void onIVExplode(ExplosionEvent.Detonate event) {
        if (!event.getLevel().f_46443_) {
            lastExplosionPosition = new Point3D(event.getExplosion().getPosition().f_82479_, event.getExplosion().getPosition().f_82480_, event.getExplosion().getPosition().f_82481_);
        }
    }

    static {
        entityMap = new HashMap<String, IItemEntityProvider.IItemEntityFactory>();
    }
}

