/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.screen.widget;

import draylar.identity.Identity;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.network.impl.FavoritePackets;
import draylar.identity.network.impl.SwapPackets;
import draylar.identity.screen.IdentityScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;

public class EntityWidget<T extends LivingEntity>
extends AbstractButton {
    public static int VERTICAL_OFFSET = 30;
    private static int BASE_Y_OFFSET = 10;
    private IdentityType<T> type;
    private T entity;
    private int size;
    private boolean active;
    private boolean starred;
    private IdentityScreen parent;

    public EntityWidget(int x, int y, int width, int height, IdentityType<T> type, T entity, IdentityScreen parent, boolean starred, boolean current) {
        super(x, y, width, height, Component.m_130674_((String)""));
        this.type = type;
        this.entity = entity;
        this.parent = parent;
        this.starred = starred;
        this.active = current;
        float baseSizeFactor = 25.0f / Math.max(entity.m_20205_(), entity.m_20206_());
        double scaleFactor = parent.getScaleFactor();
        int guiScale = parent.getGuiScale();
        double finalScale = scaleFactor / (double)(guiScale == 0 ? 1 : guiScale);
        this.size = Math.max(1, (int)((double)baseSizeFactor * finalScale));
        entity.m_146915_(true);
        this.m_257544_(Tooltip.m_257550_((Component)entity.m_5446_()));
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }

    public boolean m_6375_(double mx, double my, int button) {
        boolean hit;
        boolean bl = hit = mx >= (double)this.m_252754_() && mx < (double)(this.m_252754_() + this.m_5711_()) && my >= (double)this.m_252907_() && my < (double)(this.m_252907_() + this.m_93694_());
        if (hit) {
            if (button == 0) {
                SwapPackets.sendSwapRequest(this.type);
                this.parent.disableAll();
                this.active = true;
            } else if (button == 1) {
                this.starred = !this.starred;
                FavoritePackets.sendFavoriteRequest(this.type, this.starred);
            }
        }
        return super.m_6375_(mx, my, button);
    }

    public Component getHoverName() {
        return this.entity.m_5446_();
    }

    public void m_88315_(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        int rawGui = this.parent.getGuiScale();
        int clampedGui = rawGui == 0 ? 3 : Math.min(rawGui, 5);
        float baseSizePerBlock = 25.0f / Math.max(this.entity.m_20205_(), this.entity.m_20206_());
        double windowScale = this.parent.getScaleFactor();
        double effectiveScale = windowScale / (double)clampedGui;
        int size = Math.max(1, (int)((double)baseSizePerBlock * effectiveScale));
        int pixelHeight = (int)(this.entity.m_20206_() * (float)size);
        int slotCX = this.m_252754_() + this.m_5711_() / 2;
        int slotCY = this.m_252907_() + this.m_93694_() / 2;
        int bottomY = slotCY + pixelHeight / 2;
        try {
            InventoryScreen.m_274545_((GuiGraphics)ctx, (int)slotCX, (int)bottomY, (int)size, (float)-10.0f, (float)-10.0f, this.entity);
        }
        catch (Exception e) {
            Identity.LOGGER.warn("Failed to render " + this.type.getEntityType().m_20675_(), (Throwable)e);
        }
        if (this.starred) {
            ctx.m_280163_(Identity.id("textures/gui/star.png"), this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 15, 15, 15, 15);
        }
        if (this.active) {
            ctx.m_280411_(Identity.id("textures/gui/selected.png"), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0.0f, 0.0f, 48, 32, 48, 32);
        }
    }

    protected void m_87963_(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
    }

    public void m_5691_() {
    }

    public void setActive(boolean a) {
        this.active = a;
    }

    public void dispose() {
        if (this.entity != null) {
            try {
                this.entity.m_146870_();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.entity = null;
        }
        this.type = null;
        this.parent = null;
    }
}

