/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.registry;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import draylar.identity.api.PlayerHostility;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.registry.IdentityEntityTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;

public class IdentityEventHandlers {
    public static void initialize() {
        IdentityEventHandlers.registerHostilityUpdateHandler();
        IdentityEventHandlers.registerRavagerRidingHandler();
    }

    public static void registerHostilityUpdateHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            if (!player.m_9236_().f_46443_ && entity instanceof Monster) {
                PlayerHostility.set(player, IdentityConfig.getInstance().hostilityTime());
            }
            return EventResult.pass();
        });
    }

    public static void registerRavagerRidingHandler() {
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            LivingEntity identity;
            if (entity instanceof Ravager && (identity = PlayerIdentity.getIdentity(player)) != null && (identity.m_6095_().m_204039_(IdentityEntityTags.RAVAGER_RIDING) || SafeTagManager.isCustomRavagerRiding(identity.m_6095_()))) {
                player.m_20329_(entity);
            }
            return EventResult.pass();
        });
    }
}

