/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.profession;

import draylar.identity.api.PlayerIdentity;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.impl.VillagerIdentitiesPackets;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.state.BlockState;

public final class ProfessionLifecycle {
    private ProfessionLifecycle() {
    }

    public static void tickValidate(ServerPlayer player, int tickCount) {
        if (tickCount % 40 != 0) {
            return;
        }
        Map<String, CompoundTag> map = ((PlayerDataProvider)player).getVillagerIdentities();
        Iterator<Map.Entry<String, CompoundTag>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            long posLong;
            String prof;
            Map.Entry<String, CompoundTag> e = it.next();
            CompoundTag tag = e.getValue();
            if (tag == null || (prof = tag.m_128461_("ProfessionId")) == null || prof.isEmpty()) continue;
            String dim = tag.m_128461_("WorkstationDim");
            long l = posLong = tag.m_128441_("WorkstationPos") ? tag.m_128454_("WorkstationPos") : Long.MIN_VALUE;
            if (dim == null || dim.isEmpty() || posLong == Long.MIN_VALUE) {
                ProfessionLifecycle.removeAndNotify(player, it, e.getKey(), prof);
                continue;
            }
            ServerLevel world = player.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dim)));
            if (world == null) {
                ProfessionLifecycle.removeAndNotify(player, it, e.getKey(), prof);
                continue;
            }
            BlockPos pos = BlockPos.m_122022_((long)posLong);
            if (world.m_46859_(pos)) {
                ProfessionLifecycle.removeAndNotify(player, it, e.getKey(), prof);
                continue;
            }
            if (!PoiTypes.m_218075_((BlockState)world.m_8055_(pos)).isEmpty()) continue;
            ProfessionLifecycle.removeAndNotify(player, it, e.getKey(), prof);
        }
    }

    private static void removeAndNotify(ServerPlayer player, Iterator<Map.Entry<String, CompoundTag>> iterator, String key, String prof) {
        iterator.remove();
        PlayerDataProvider data = (PlayerDataProvider)player;
        if (key.equals(data.getActiveVillagerKey())) {
            data.setActiveVillagerKey(null);
        }
        player.m_5661_((Component)Component.m_237110_((String)"identity.profession.block_destroyed", (Object[])new Object[]{key, Component.m_237113_((String)prof)}), false);
        PlayerIdentity.sync(player);
        VillagerIdentitiesPackets.sendSync(player);
    }
}

