/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network.impl;

import dev.architectury.networking.NetworkManager;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.NetworkHandler;
import draylar.identity.network.impl.VillagerIdentitiesPackets;
import io.netty.buffer.Unpooled;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class VillagerProfessionPackets {
    public static void openScreen(ServerPlayer player, ResourceLocation professionId, BlockPos pos, ResourceLocation worldId, String existingName, String existingProfessionId) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130085_(professionId);
        packet.m_130064_(pos);
        packet.m_130085_(worldId);
        packet.writeBoolean(existingName != null);
        if (existingName != null) {
            packet.m_130070_(existingName);
            packet.m_130070_(existingProfessionId == null ? "" : existingProfessionId);
        }
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)NetworkHandler.OPEN_PROFESSION_SCREEN, (FriendlyByteBuf)packet);
    }

    public static void sendSetProfession(ResourceLocation professionId, String name, boolean reset, BlockPos pos, ResourceLocation worldId, String originalName) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130085_(professionId);
        packet.m_130070_(name);
        packet.writeBoolean(reset);
        packet.m_130064_(pos);
        packet.m_130085_(worldId);
        packet.writeBoolean(originalName != null);
        if (originalName != null) {
            packet.m_130070_(originalName);
        }
        NetworkManager.sendToServer((ResourceLocation)NetworkHandler.SET_PROFESSION, (FriendlyByteBuf)packet);
    }

    public static void registerServerHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)NetworkHandler.SET_PROFESSION, (buf, context) -> {
            ResourceLocation professionId = buf.m_130281_();
            String name = buf.m_130277_();
            boolean reset = buf.readBoolean();
            BlockPos pos = buf.m_130135_();
            ResourceLocation worldId = buf.m_130281_();
            boolean hasOriginal = buf.readBoolean();
            String originalName = hasOriginal ? buf.m_130277_() : null;
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            context.getPlayer().m_20194_().execute(() -> VillagerProfessionPackets.handleServerRequest(player, professionId, name, reset, pos, worldId, originalName));
        });
    }

    private static void handleServerRequest(ServerPlayer player, ResourceLocation professionId, String rawName, boolean reset, BlockPos pos, ResourceLocation worldId, String originalName) {
        PlayerDataProvider data = (PlayerDataProvider)player;
        Map<String, CompoundTag> map = data.getVillagerIdentities();
        long workstationPos = pos.m_121878_();
        String trimmedName = rawName.trim();
        String existingKey = null;
        if (originalName != null && map.containsKey(originalName) && VillagerProfessionPackets.matchesWorkstation(map.get(originalName), worldId, workstationPos)) {
            existingKey = originalName;
        }
        if (existingKey == null) {
            for (Map.Entry<String, CompoundTag> entry : map.entrySet()) {
                if (!VillagerProfessionPackets.matchesWorkstation(entry.getValue(), worldId, workstationPos)) continue;
                existingKey = entry.getKey();
                break;
            }
        }
        if (reset) {
            if (existingKey != null) {
                data.removeVillagerIdentity(existingKey);
                player.m_5661_((Component)Component.m_237110_((String)"identity.profession.removed", (Object[])new Object[]{existingKey}), false);
                PlayerIdentity.sync(player);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"identity.profession.none"), false);
            }
            return;
        }
        if (trimmedName.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"identity.profession.require_name"), false);
            return;
        }
        if (map.containsKey(trimmedName) && (existingKey == null || !existingKey.equals(trimmedName))) {
            player.m_5661_((Component)Component.m_237110_((String)"identity.profession.name_conflict", (Object[])new Object[]{trimmedName}), false);
            return;
        }
        ServerLevel world = player.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)worldId));
        if (world == null || !world.m_46472_().equals(player.m_9236_().m_46472_())) {
            player.m_5661_((Component)Component.m_237115_((String)"identity.profession.invalid_world"), false);
            return;
        }
        if (PoiTypes.m_218075_((BlockState)world.m_8055_(pos)).isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"identity.profession.invalid_workstation"), false);
            return;
        }
        LivingEntity livingEntity = PlayerIdentity.getIdentity((Player)player);
        if (!(livingEntity instanceof Villager)) {
            player.m_5661_((Component)Component.m_237115_((String)"identity.profession.missing_identity"), false);
            return;
        }
        Villager villager = (Villager)livingEntity;
        CompoundTag tag = new CompoundTag();
        VillagerProfession profession = BuiltInRegistries.f_256735_.m_6612_(professionId).orElse(VillagerProfession.f_35585_);
        villager.m_34375_(new VillagerData(villager.m_7141_().m_35560_(), profession, villager.m_7141_().m_35576_()));
        villager.m_20240_(tag);
        tag.m_128359_("ProfessionId", professionId.toString());
        tag.m_128359_("WorkstationDim", worldId.toString());
        tag.m_128356_("WorkstationPos", workstationPos);
        tag.m_128359_("IdentityName", trimmedName);
        data.setVillagerIdentity(trimmedName, tag);
        if (existingKey != null && !existingKey.equals(trimmedName)) {
            data.removeVillagerIdentity(existingKey);
        }
        String activeKey = data.getActiveVillagerKey();
        if (existingKey != null && existingKey.equals(activeKey)) {
            data.setActiveVillagerKey(trimmedName);
        } else if (existingKey == null) {
            data.setActiveVillagerKey(trimmedName);
        }
        MutableComponent professionText = Component.m_237113_((String)professionId.toString());
        player.m_5661_((Component)Component.m_237110_((String)(existingKey != null ? "identity.profession.updated" : "identity.profession.saved"), (Object[])new Object[]{trimmedName, professionText}), false);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 10, 0.5, 0.5, 0.5, 0.0);
        PlayerIdentity.sync(player);
        VillagerIdentitiesPackets.sendSync(player);
    }

    private static boolean matchesWorkstation(CompoundTag tag, ResourceLocation worldId, long workstationPos) {
        if (tag == null) {
            return false;
        }
        String dim = tag.m_128461_("WorkstationDim");
        long storedPos = tag.m_128441_("WorkstationPos") ? tag.m_128454_("WorkstationPos") : Long.MIN_VALUE;
        return !dim.isEmpty() && storedPos != Long.MIN_VALUE && worldId.toString().equals(dim) && storedPos == workstationPos;
    }
}

