/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.network.impl;

import dev.architectury.networking.NetworkManager;
import draylar.identity.Identity;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.network.ClientNetworking;
import draylar.identity.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import net.Gabou.gaboulibs.util.CompatUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SwapPackets {
    public static void registerIdentityRequestPacketHandler() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)NetworkHandler.IDENTITY_REQUEST, (buf, context) -> {
            boolean validType = buf.readBoolean();
            if (validType) {
                EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(buf.m_130281_());
                int variant = buf.readInt();
                context.getPlayer().m_20194_().execute(() -> {
                    if (IdentityConfig.getInstance().enableSwaps() || context.getPlayer().m_20310_(3) || IdentityConfig.getInstance().allowedSwappers().stream().anyMatch(p -> p.equalsIgnoreCase(context.getPlayer().m_36316_().getName()))) {
                        if (CompatUtils.isBlacklistedEntityType((String)entityType.toString())) {
                            PlayerIdentity.updateIdentity((ServerPlayer)context.getPlayer(), null, null);
                            ((PlayerDataProvider)context.getPlayer()).setActiveVillagerKey(null);
                        } else if (entityType.equals(EntityType.f_20532_)) {
                            PlayerIdentity.updateIdentity((ServerPlayer)context.getPlayer(), null, null);
                            ((PlayerDataProvider)context.getPlayer()).setActiveVillagerKey(null);
                        } else {
                            @Nullable IdentityType<Z> type = IdentityType.from(entityType, variant);
                            if (type != null) {
                                try {
                                    Object created;
                                    String selectedVillagerKey = null;
                                    if (entityType.equals(EntityType.f_20492_) && variant >= 1000000) {
                                        int index = variant - 1000000;
                                        PlayerDataProvider data = (PlayerDataProvider)context.getPlayer();
                                        ArrayList<String> keys = new ArrayList<String>(data.getVillagerIdentities().keySet());
                                        Collections.sort(keys);
                                        if (index >= 0 && index < keys.size()) {
                                            String key = (String)keys.get(index);
                                            CompoundTag tag = data.getVillagerIdentities().get(key);
                                            CompoundTag copy = tag.m_6426_();
                                            copy.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_20492_).toString());
                                            created = (LivingEntity)EntityType.m_20645_((CompoundTag)copy, (Level)context.getPlayer().m_9236_(), it -> it);
                                            selectedVillagerKey = key;
                                        } else {
                                            created = type.create(context.getPlayer().m_9236_());
                                        }
                                    } else {
                                        created = type.create(context.getPlayer().m_9236_());
                                    }
                                    PlayerIdentity.updateIdentity((ServerPlayer)context.getPlayer(), type, created);
                                    ((PlayerDataProvider)context.getPlayer()).setActiveVillagerKey(selectedVillagerKey);
                                }
                                catch (Exception e) {
                                    CompatUtils.markIncompatibleEntityType((String)entityType.toString());
                                    Identity.LOGGER.warn("Failed to create identity " + entityType.m_20675_(), (Throwable)e);
                                }
                            }
                        }
                        context.getPlayer().m_6210_();
                    }
                });
            } else {
                context.getPlayer().m_20194_().execute(() -> {
                    if (IdentityConfig.getInstance().enableSwaps() || context.getPlayer().m_20310_(3) || IdentityConfig.getInstance().allowedSwappers().stream().anyMatch(p -> p.equalsIgnoreCase(context.getPlayer().m_36316_().getName()))) {
                        PlayerIdentity.updateIdentity((ServerPlayer)context.getPlayer(), null, null);
                        ((PlayerDataProvider)context.getPlayer()).setActiveVillagerKey(null);
                    }
                    context.getPlayer().m_6210_();
                });
            }
        });
    }

    public static void sendSwapRequest(@Nullable IdentityType<?> type) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeBoolean(type != null);
        if (type != null) {
            packet.m_130085_(BuiltInRegistries.f_256780_.m_7981_(type.getEntityType()));
            packet.writeInt(type.getVariantData());
        }
        NetworkManager.sendToServer((ResourceLocation)ClientNetworking.IDENTITY_REQUEST, (FriendlyByteBuf)packet);
    }
}

