/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin.player;

import draylar.identity.Identity;
import draylar.identity.api.FlightHelper;
import draylar.identity.api.IdentityTickHandler;
import draylar.identity.api.IdentityTickHandlers;
import draylar.identity.api.PlayerAbilities;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.profession.ProfessionLifecycle;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityTickMixin
extends LivingEntity {
    private PlayerEntityTickMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        IdentityTickHandler<?> handler;
        @Nullable LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity != null && (handler = IdentityTickHandlers.getHandlers().get(identity.m_6095_())) != null) {
            handler.tick((Player)this, identity);
        }
        if (!this.m_9236_().f_46443_) {
            PlayerDataProvider data = (PlayerDataProvider)((Object)this);
            data.setRemainingHostilityTime(Math.max(0, data.getRemainingHostilityTime() - 1));
            ServerPlayer player = (ServerPlayer)this;
            PlayerAbilities.setCooldown((Player)player, Math.max(0, data.getAbilityCooldown() - 1));
            PlayerAbilities.sync(player);
            boolean shouldAllowFlight = Identity.hasFlyingPermissions(player);
            if (shouldAllowFlight != player.m_150110_().f_35936_) {
                if (shouldAllowFlight) {
                    FlightHelper.grantFlightTo(player);
                    player.m_150110_().m_35943_(IdentityConfig.getInstance().flySpeed());
                } else {
                    FlightHelper.revokeFlight(player);
                    player.m_150110_().m_35943_(0.05f);
                }
                player.m_6885_();
            }
            ProfessionLifecycle.tickValidate(player, player.f_19797_);
        }
    }
}

