/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin.player;

import dev.architectury.event.EventResult;
import draylar.identity.Identity;
import draylar.identity.api.FlightHelper;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.event.IdentitySwapCallback;
import draylar.identity.api.platform.IdentityConfig;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.impl.DimensionsRefresher;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.mixin.EntityTrackerAccessor;
import draylar.identity.mixin.ThreadedAnvilChunkStorageAccessor;
import draylar.identity.registry.IdentityEntityTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityDataMixin
extends LivingEntity
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    private final Set<IdentityType<?>> unlocked = new HashSet();
    @Unique
    private final Set<IdentityType<?>> favorites = new HashSet();
    @Unique
    private int remainingTime = 0;
    @Unique
    private int abilityCooldown = 0;
    @Unique
    private LivingEntity identity = null;
    @Unique
    private IdentityType<?> identityType = null;
    @Unique
    private final Map<String, CompoundTag> villagerIdentities = new HashMap<String, CompoundTag>();
    @Unique
    @Nullable
    private String activeVillagerKey = null;

    @Shadow
    public abstract void m_5496_(SoundEvent var1, float var2, float var3);

    private PlayerEntityDataMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        String storedKey;
        this.unlocked.clear();
        ListTag unlockedIdList = tag.m_128437_("UnlockedMorphs", 8);
        unlockedIdList.forEach(entityRegistryID -> {
            ResourceLocation id = new ResourceLocation(entityRegistryID.m_7916_());
            if (BuiltInRegistries.f_256780_.m_7804_(id)) {
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(id);
                this.unlocked.add(new IdentityType<EntityType>(type));
            }
        });
        ListTag unlockedIdentityList = tag.m_128437_("UnlockedIdentities", 10);
        unlockedIdentityList.forEach(compound -> {
            IdentityType<?> type = IdentityType.from((CompoundTag)compound);
            if (type != null) {
                this.unlocked.add(type);
            }
        });
        this.favorites.clear();
        ListTag favoriteIdList = tag.m_128437_("FavoriteIdentities", 8);
        favoriteIdList.forEach(registryID -> {
            ResourceLocation id = new ResourceLocation(registryID.m_7916_());
            if (BuiltInRegistries.f_256780_.m_7804_(id)) {
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(id);
                this.favorites.add(new IdentityType<EntityType>(type));
            }
        });
        ListTag favoriteTypeList = tag.m_128437_("FavoriteIdentitiesV2", 8);
        favoriteTypeList.forEach(compound -> {
            IdentityType<?> type = IdentityType.from((CompoundTag)compound);
            if (type != null) {
                this.favorites.add(type);
            }
        });
        this.abilityCooldown = tag.m_128451_(ABILITY_COOLDOWN_KEY);
        this.remainingTime = tag.m_128451_("RemainingHostilityTime");
        this.readCurrentIdentity(tag.m_128469_("CurrentIdentity"));
        if (this.identity != null) {
            ((Player)this).m_274367_(this.identity.m_274421_());
        } else {
            ((Player)this).m_274367_(0.6f);
        }
        this.villagerIdentities.clear();
        CompoundTag villagerTag = tag.m_128469_("VillagerIdentities");
        for (String key : villagerTag.m_128431_()) {
            this.villagerIdentities.put(key, villagerTag.m_128469_(key));
        }
        this.activeVillagerKey = tag.m_128425_("ActiveVillagerKey", 8) ? ((storedKey = tag.m_128461_("ActiveVillagerKey")).isEmpty() ? null : storedKey) : null;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        ListTag idList = new ListTag();
        this.unlocked.forEach(identity -> idList.add((Object)identity.writeCompound()));
        tag.m_128365_("UnlockedIdentities", (Tag)idList);
        idList = new ListTag();
        this.favorites.forEach(entityId -> idList.add((Object)entityId.writeCompound()));
        tag.m_128365_("FavoriteIdentitiesV2", (Tag)idList);
        tag.m_128405_(ABILITY_COOLDOWN_KEY, this.abilityCooldown);
        tag.m_128405_("RemainingHostilityTime", this.remainingTime);
        tag.m_128365_("CurrentIdentity", (Tag)this.writeCurrentIdentity(new CompoundTag()));
        CompoundTag villagerTag = new CompoundTag();
        this.villagerIdentities.forEach((key, value) -> villagerTag.m_128365_(key, (Tag)value.m_6426_()));
        tag.m_128365_("VillagerIdentities", (Tag)villagerTag);
        if (this.activeVillagerKey != null && !this.activeVillagerKey.isEmpty()) {
            tag.m_128359_("ActiveVillagerKey", this.activeVillagerKey);
        }
    }

    @Unique
    private CompoundTag writeCurrentIdentity(CompoundTag tag) {
        CompoundTag entityTag = new CompoundTag();
        if (this.identity != null) {
            this.identity.m_20240_(entityTag);
            if (this.identityType != null) {
                this.identityType.writeEntityNbt(entityTag);
            }
        }
        tag.m_128359_("id", this.identity == null ? "minecraft:empty" : BuiltInRegistries.f_256780_.m_7981_((Object)this.identity.m_6095_()).toString());
        tag.m_128365_("EntityData", (Tag)entityTag);
        return tag;
    }

    @Unique
    public void readCurrentIdentity(CompoundTag tag) {
        CompoundTag entityTag;
        Optional type = EntityType.m_20637_((CompoundTag)tag);
        if (tag.m_128461_("id").equals("minecraft:empty")) {
            this.identity = null;
            ((DimensionsRefresher)((Object)this)).identity_refreshDimensions();
        } else if (type.isPresent() && (entityTag = tag.m_128469_("EntityData")) != null) {
            if (this.identity == null || !((EntityType)type.get()).equals(this.identity.m_6095_())) {
                this.identity = (LivingEntity)((EntityType)type.get()).m_20615_(this.m_9236_());
                ((DimensionsRefresher)((Object)this)).identity_refreshDimensions();
            }
            this.identity.m_20258_(entityTag);
            this.identityType = IdentityType.fromEntityNbt(tag);
        }
    }

    @Override
    @Unique
    public Set<IdentityType<?>> getUnlocked() {
        return this.unlocked;
    }

    @Override
    public void setUnlocked(Set<IdentityType<?>> unlocked) {
        this.unlocked.clear();
        this.unlocked.addAll(unlocked);
    }

    @Override
    @Unique
    public Set<IdentityType<?>> getFavorites() {
        return this.favorites;
    }

    @Override
    public void setFavorites(Set<IdentityType<?>> favorites) {
        this.favorites.clear();
        this.favorites.addAll(favorites);
    }

    @Override
    @Unique
    public int getRemainingHostilityTime() {
        return this.remainingTime;
    }

    @Override
    @Unique
    public void setRemainingHostilityTime(int max) {
        this.remainingTime = max;
    }

    @Override
    @Unique
    public int getAbilityCooldown() {
        return this.abilityCooldown;
    }

    @Override
    @Unique
    public void setAbilityCooldown(int abilityCooldown) {
        this.abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    public LivingEntity getIdentity() {
        return this.identity;
    }

    @Override
    public IdentityType<?> getIdentityType() {
        return this.identityType;
    }

    @Override
    public void setIdentityType(@Nullable IdentityType<?> type) {
        this.identityType = type;
    }

    @Override
    public Map<String, CompoundTag> getVillagerIdentities() {
        return this.villagerIdentities;
    }

    @Override
    public void setVillagerIdentity(String key, CompoundTag identity) {
        if (identity == null) {
            this.villagerIdentities.remove(key);
        } else {
            this.villagerIdentities.put(key, identity);
        }
    }

    @Override
    public void removeVillagerIdentity(String key) {
        this.villagerIdentities.remove(key);
        if (this.activeVillagerKey != null && this.activeVillagerKey.equals(key)) {
            this.activeVillagerKey = null;
        }
    }

    @Override
    @Nullable
    public String getActiveVillagerKey() {
        return this.activeVillagerKey;
    }

    @Override
    public void setActiveVillagerKey(@Nullable String key) {
        this.activeVillagerKey = key;
    }

    @Override
    @Unique
    public void setIdentity(LivingEntity identity) {
        this.identity = identity;
        if (!(identity instanceof Villager)) {
            this.activeVillagerKey = null;
        }
    }

    @Override
    @Unique
    public boolean updateIdentity(@Nullable LivingEntity identity) {
        double newMax;
        double oldMax;
        Player player = (Player)this;
        EventResult result = ((IdentitySwapCallback)IdentitySwapCallback.EVENT.invoker()).swap((ServerPlayer)player, identity);
        if (result.isFalse()) {
            return false;
        }
        this.identity = identity;
        if (!(identity instanceof Villager)) {
            this.activeVillagerKey = null;
        }
        ((DimensionsRefresher)player).identity_refreshDimensions();
        if (identity != null) {
            player.m_274367_(identity.m_274421_());
        } else {
            player.m_274367_(0.6f);
        }
        if (identity != null && IdentityConfig.getInstance().scalingHealth()) {
            oldMax = player.m_21051_(Attributes.f_22276_).m_22115_();
            newMax = Math.min((float)IdentityConfig.getInstance().maxHealth(), identity.m_21233_());
            this.identity$scaleHealth(player, oldMax, newMax);
        }
        if (identity == null && IdentityConfig.getInstance().scalingHealth()) {
            oldMax = player.m_21051_(Attributes.f_22276_).m_22115_();
            newMax = 20.0;
            this.identity$scaleHealth(player, oldMax, newMax);
        }
        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
        if (Identity.hasFlyingPermissions((ServerPlayer)player)) {
            FlightHelper.grantFlightTo(serverPlayerEntity);
            player.m_150110_().m_35943_(IdentityConfig.getInstance().flySpeed());
            player.m_6885_();
        } else {
            FlightHelper.revokeFlight(serverPlayerEntity);
            player.m_150110_().m_35943_(0.05f);
            player.m_6885_();
        }
        if (player.m_20202_() instanceof Ravager) {
            if (identity == null) {
                player.m_8127_();
            } else if (!identity.m_6095_().m_204039_(IdentityEntityTags.RAVAGER_RIDING) || SafeTagManager.isCustomRavagerRiding(identity.m_6095_())) {
                player.m_8127_();
            }
        }
        if (!player.m_9236_().f_46443_) {
            PlayerIdentity.sync((ServerPlayer)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((ServerLevel)player.m_9236_()).m_7726_().f_8325_).getEntityTrackers();
            Object tracking = trackers.get(player.m_19879_());
            ((EntityTrackerAccessor)tracking).getListeners().forEach(listener -> PlayerIdentity.sync((ServerPlayer)player, listener.m_142253_()));
        }
        return true;
    }

    @Unique
    private void identity$scaleHealth(Player player, double oldMax, double newMax) {
        double currentHealth = player.m_21223_();
        double ratio = oldMax > 0.0 ? currentHealth / oldMax : 1.0;
        double scaledHealth = Mth.m_14008_((double)(ratio * newMax), (double)1.0, (double)newMax);
        player.m_21051_(Attributes.f_22276_).m_22100_(newMax);
        player.m_21153_((float)scaledHealth);
    }
}

