/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.api.PlayerIdentity;
import draylar.identity.impl.PlayerDataProvider;
import draylar.identity.mixin.accessor.VillagerEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerEntityMixin {
    @Shadow
    protected abstract void m_35518_();

    @Inject(method={"interactMob"}, at={@At(value="HEAD")}, cancellable=true)
    private void onInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        LivingEntity identity = PlayerIdentity.getIdentity(player);
        if (identity != null && identity.m_21222_()) {
            this.m_35518_();
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            return;
        }
        if (!player.m_9236_().f_46443_) {
            PlayerDataProvider data;
            String activeKey;
            Villager villager = (Villager)this;
            ServerPlayer owner = null;
            for (ServerPlayer sp : villager.m_20194_().m_6846_().m_11314_()) {
                if (PlayerIdentity.getIdentity((Player)sp) != villager) continue;
                owner = sp;
                break;
            }
            if (owner != null && (activeKey = (data = (PlayerDataProvider)owner).getActiveVillagerKey()) != null && data.getVillagerIdentities().containsKey(activeKey)) {
                boolean invalid;
                CompoundTag tag = data.getVillagerIdentities().get(activeKey);
                String dim = tag.m_128461_("WorkstationDim");
                long posLong = tag.m_128441_("WorkstationPos") ? tag.m_128454_("WorkstationPos") : Long.MIN_VALUE;
                boolean bl = invalid = dim == null || dim.isEmpty() || posLong == Long.MIN_VALUE;
                if (!invalid) {
                    ServerLevel world = owner.m_20194_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dim)));
                    if (world == null) {
                        invalid = true;
                    } else {
                        BlockPos pos = BlockPos.m_122022_((long)posLong);
                        if (world.m_46859_(pos) || PoiTypes.m_218075_((BlockState)world.m_8055_(pos)).isEmpty()) {
                            invalid = true;
                        }
                    }
                }
                if (invalid) {
                    this.m_35518_();
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        sp.m_5661_((Component)Component.m_237115_((String)"identity.profession.invalid_workstation"), true);
                    }
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }

    @Inject(method={"afterUsing"}, at={@At(value="TAIL")})
    private void onTrade(MerchantOffer offer, CallbackInfo ci) {
        PlayerDataProvider data;
        String activeKey;
        Villager villager = (Villager)this;
        ServerPlayer owner = null;
        for (ServerPlayer player : villager.m_20194_().m_6846_().m_11314_()) {
            if (PlayerIdentity.getIdentity((Player)player) != villager) continue;
            owner = player;
            break;
        }
        if (owner != null && (activeKey = (data = (PlayerDataProvider)owner).getActiveVillagerKey()) != null && data.getVillagerIdentities().containsKey(activeKey)) {
            CompoundTag existing = data.getVillagerIdentities().get(activeKey);
            CompoundTag updated = new CompoundTag();
            villager.m_20240_(updated);
            updated.m_128359_("ProfessionId", BuiltInRegistries.f_256735_.m_7981_((Object)villager.m_7141_().m_35571_()).toString());
            if (existing.m_128441_("WorkstationDim")) {
                updated.m_128359_("WorkstationDim", existing.m_128461_("WorkstationDim"));
            }
            if (existing.m_128441_("WorkstationPos")) {
                updated.m_128356_("WorkstationPos", existing.m_128454_("WorkstationPos"));
            }
            updated.m_128359_("IdentityName", activeKey);
            data.setVillagerIdentity(activeKey, updated);
            PlayerIdentity.sync(owner);
            VillagerEntityAccessor accessor = (VillagerEntityAccessor)villager;
            if (((VillagerEntityAccessor)villager).callGetNextLevelExperience()) {
                accessor.callLevelUp();
            }
        }
    }
}

