/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.mixin.accessor.EntityShadowAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class ShadowMixin {
    @Unique
    private static Entity identity_shadowEntity;

    @Inject(method={"renderShadow"}, at={@At(value="HEAD")})
    private static void storeContext(PoseStack matrices, MultiBufferSource vertexConsumers, Entity entity, float opacity, float tickDelta, LevelReader world, float radius, CallbackInfo ci) {
        identity_shadowEntity = entity;
    }

    @ModifyVariable(method={"renderShadow"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;lerp(DDD)D", ordinal=0), index=7)
    private static float adjustShadowSize(float originalSize) {
        Player player;
        LivingEntity identity;
        Entity entity = identity_shadowEntity;
        if (entity instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)entity)) != null) {
            EntityRenderer r = Minecraft.m_91087_().m_91290_().m_114382_((Entity)identity);
            float shadowRadius = ((EntityShadowAccessor)r).getShadowRadius();
            float mod = identity.m_6162_() ? 0.5f : 1.0f;
            return shadowRadius * mod;
        }
        return originalSize;
    }
}

