/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import com.mojang.authlib.GameProfile;
import draylar.identity.Identity;
import draylar.identity.api.FlightHelper;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.PlayerUnlocks;
import draylar.identity.api.platform.IdentityConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player {
    @Shadow
    public abstract boolean m_7500_();

    @Shadow
    public abstract boolean m_5833_();

    @Shadow
    public abstract void m_5661_(Component var1, boolean var2);

    public ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void revokeIdentityOnDeath(DamageSource source, CallbackInfo ci) {
        LivingEntity entity;
        if (IdentityConfig.getInstance().revokeIdentityOnDeath() && !this.m_7500_() && !this.m_5833_() && (entity = PlayerIdentity.getIdentity(this)) != null) {
            EntityType type = entity.m_6095_();
            PlayerUnlocks.revoke((ServerPlayer)this, PlayerIdentity.getIdentityType(this));
            PlayerIdentity.updateIdentity((ServerPlayer)this, null, null);
            if (IdentityConfig.getInstance().overlayIdentityRevokes()) {
                this.m_5661_((Component)Component.m_237110_((String)"identity.revoke_entity", (Object[])new Object[]{type.m_20675_()}), true);
            }
        }
    }

    @Inject(method={"onSpawn()V"}, at={@At(value="HEAD")})
    private void onSpawn(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        this.m_6210_();
        if (Identity.hasFlyingPermissions(player) && !FlightHelper.hasFlight(player)) {
            FlightHelper.grantFlightTo(player);
            this.m_150110_().m_35943_(IdentityConfig.getInstance().flySpeed());
            this.m_6885_();
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="RETURN")})
    private void identity$handleDeath(DamageSource source, CallbackInfo ci) {
        ServerPlayerEntityMixin serverPlayerEntityMixin = this;
        if (serverPlayerEntityMixin instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerEntityMixin;
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="RETURN")})
    private void identity$restoreAfterRespawn(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        PlayerIdentity.sync((ServerPlayer)this);
    }

    @Inject(method={"changeGameMode"}, at={@At(value="TAIL")})
    private void identity$onGameModeChange(GameType newMode, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player = (ServerPlayer)this;
        if (Identity.hasFlyingPermissions(player)) {
            FlightHelper.grantFlightTo(player);
            this.m_150110_().m_35943_(IdentityConfig.getInstance().flySpeed());
        } else if (!player.m_7500_() && !player.m_5833_()) {
            FlightHelper.revokeFlight(player);
            this.m_150110_().m_35943_(0.05f);
        }
        this.m_6885_();
    }
}

