/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.api.PlayerIdentity;
import draylar.identity.impl.SonicBoomUser;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerSonicBoomMixin
extends LivingEntity
implements SonicBoomUser {
    @Unique
    private int identity$ability_wardenBoomDelay = -1;

    private PlayerSonicBoomMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public void identity$ability_startSonicBoom() {
        @Nullable LivingEntity identity = PlayerIdentity.getIdentity((Player)this);
        if (identity instanceof Warden) {
            this.m_9236_().m_7605_((Entity)this, (byte)62);
            this.identity$ability_wardenBoomDelay = 40;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215772_, SoundSource.PLAYERS, 3.0f, 1.0f);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickSonicBoom(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            this.identity$ability_wardenBoomDelay = Math.max(-1, this.identity$ability_wardenBoomDelay - 1);
            if (this.identity$ability_wardenBoomDelay == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 3.0f, 1.0f);
                float heightOffset = 1.6f;
                int distance = 16;
                Vec3 target = this.m_20182_().m_82549_(this.m_20154_().m_82490_((double)distance));
                Vec3 source = this.m_20182_().m_82520_(0.0, (double)heightOffset, 0.0);
                Vec3 offsetToTarget = target.m_82546_(source);
                Vec3 normalized = offsetToTarget.m_82541_();
                HashSet hit = new HashSet();
                for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)offsetToTarget.m_82553_()) + 7; ++particleIndex) {
                    Vec3 particlePos = source.m_82549_(normalized.m_82490_((double)particleIndex));
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_235902_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    hit.addAll(this.m_9236_().m_6443_(LivingEntity.class, new AABB(new BlockPos((int)particlePos.m_7096_(), (int)particlePos.m_7098_(), (int)particlePos.m_7094_())).m_82400_(2.0), it -> !(it instanceof Wolf)));
                }
                hit.remove((Player)this);
                for (Entity hitTarget : hit) {
                    if (!(hitTarget instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)hitTarget;
                    living.m_6469_(this.m_269291_().m_269285_((Entity)((Player)this)), 10.0f);
                    double vertical = 0.5 * (1.0 - living.m_21133_(Attributes.f_22278_));
                    double horizontal = 2.5 * (1.0 - living.m_21133_(Attributes.f_22278_));
                    living.m_5997_(normalized.m_7096_() * horizontal, normalized.m_7098_() * vertical, normalized.m_7094_() * horizontal);
                }
            }
        }
    }
}

