/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.Identity;
import draylar.identity.api.IdentityGranting;
import draylar.identity.api.PlayerIdentity;
import draylar.identity.api.SafeTagManager;
import draylar.identity.api.variant.IdentityType;
import draylar.identity.compat.LivingEntityCompatAccessor;
import draylar.identity.impl.NearbySongAccessor;
import draylar.identity.registry.IdentityEntityTags;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements NearbySongAccessor {
    @Unique
    private boolean nearbySongPlaying = false;

    @Shadow
    protected abstract int m_7305_(int var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    protected LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"onDeath"}, at={@At(value="RETURN")})
    private void onDeath(DamageSource source, CallbackInfo ci) {
        Entity attacker = source.m_7639_();
        @Nullable IdentityType<LivingEntity> thisType = IdentityType.from((LivingEntity)this);
        if (attacker instanceof Player && thisType != null) {
            IdentityGranting.grantByAttack((Player)attacker, thisType);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void identity$preventAirRegenForAquatic(CallbackInfo ci) {
        Player player;
        LivingEntity identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && Identity.identity$isAquatic(identity = PlayerIdentity.getIdentity(player = (Player)livingEntityMixin)) && !player.m_5842_()) {
            player.m_20301_(Math.min(player.m_20146_(), player.m_6062_()));
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z", ordinal=0))
    private boolean slowFall(LivingEntity livingEntity, MobEffect effect) {
        EntityType type;
        Player player;
        LivingEntity identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)livingEntityMixin)) != null && !this.m_6144_() && ((type = identity.m_6095_()).m_204039_(IdentityEntityTags.SLOW_FALLING) || SafeTagManager.isCustomSlowFalling(type))) {
            return true;
        }
        return this.m_21023_(MobEffects.f_19591_);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void identity$suffocateAquaticIdentities(CallbackInfo ci) {
        Player player;
        LivingEntity identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && Identity.identity$isAquatic(identity = PlayerIdentity.getIdentity(player = (Player)livingEntityMixin))) {
            boolean inWater = player.m_20069_();
            boolean inBubbleColumn = player.m_9236_().m_8055_(player.m_20183_()).m_60713_(Blocks.f_50628_);
            int air = player.m_20146_();
            if (!inWater && !inBubbleColumn) {
                if (player.f_19797_ % 40 == 0) {
                    if (air > 0) {
                        player.m_20301_(Math.max(air - 15, 0));
                    } else {
                        player.m_20301_(-1);
                        player.m_6469_(player.m_269291_().m_269063_(), 2.0f);
                    }
                }
            } else if (air < player.m_6062_()) {
                player.m_20301_(player.m_6062_());
            }
        }
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getNextAirOnLand(I)I"))
    private int identity$cancelAirRegenOnLand(LivingEntity instance, int air) {
        Player player;
        LivingEntity identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && Identity.identity$isAquatic(identity = PlayerIdentity.getIdentity(player = (Player)livingEntityMixin)) && !player.m_20069_() && !player.m_9236_().m_8055_(player.m_20183_()).m_60713_(Blocks.f_50628_)) {
            return air;
        }
        return ((LivingEntityCompatAccessor)instance).identity$getNextAirOnLand(air);
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)livingEntityMixin)) != null) {
            boolean takesFallDamage = identity.m_142535_(fallDistance, damageMultiplier, damageSource);
            int damageAmount = ((LivingEntityCompatAccessor)identity).callComputeFallDamage(fallDistance, damageMultiplier);
            if (takesFallDamage && damageAmount > 0) {
                LivingEntity.Fallsounds fallSounds = identity.m_196493_();
                this.m_5496_(damageAmount > 4 ? fallSounds.f_196627_() : fallSounds.f_196626_(), 1.0f, 1.0f);
                ((LivingEntityCompatAccessor)identity).callPlayBlockFallSound();
                this.m_6469_(this.m_269291_().m_268989_(), damageAmount);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hasStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnHasNightVision(MobEffect effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            LivingEntity identity;
            Player player = (Player)livingEntityMixin;
            if (effect.equals(MobEffects.f_19611_) && (identity = PlayerIdentity.getIdentity(player)) instanceof Bat) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"getStatusEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnNightVisionInstance(MobEffect effect, CallbackInfoReturnable<MobEffectInstance> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            LivingEntity identity;
            Player player = (Player)livingEntityMixin;
            if (effect.equals(MobEffects.f_19611_) && (identity = PlayerIdentity.getIdentity(player)) instanceof Bat) {
                cir.setReturnValue((Object)new MobEffectInstance(MobEffects.f_19611_, 100000, 0, false, false));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEyeHeight"}, cancellable=true)
    public void getEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            try {
                LivingEntity identity = PlayerIdentity.getIdentity(player);
                if (identity != null) {
                    cir.setReturnValue((Object)Float.valueOf(((LivingEntityCompatAccessor)identity).callGetEyeHeight(pose, dimensions)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"hurtByWater"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_hurtByWater(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity entity;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (entity = PlayerIdentity.getIdentity(player = (Player)livingEntity)) != null) {
            cir.setReturnValue((Object)entity.m_6126_());
        }
    }

    @Inject(method={"canBreatheInWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void identity_canBreatheInWater(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity identity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)livingEntityMixin)) != null) {
            if (Identity.identity$isAquatic(identity)) {
                cir.setReturnValue((Object)true);
            } else if (identity.m_6095_().m_204039_(IdentityEntityTags.UNDROWNABLE) || SafeTagManager.isCustomUndrownable(identity.m_6095_())) {
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"setNearbySongPlaying"}, at={@At(value="RETURN")})
    @OnlyIn(value=Dist.CLIENT)
    protected void identity_setNearbySongPlaying(BlockPos songPosition, boolean playing, CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean identity_isNearbySongPlaying() {
        return this.nearbySongPlaying;
    }

    @Inject(method={"isUndead"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_isUndead(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity identity;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)livingEntity)) != null) {
            cir.setReturnValue((Object)identity.m_21222_());
        }
    }

    @Inject(method={"canWalkOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_canWalkOnFluid(FluidState state, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity identity;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)livingEntity)) != null && identity.m_6095_().m_204039_(IdentityEntityTags.LAVA_WALKING) && state.m_205070_(FluidTags.f_13132_)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isClimbing"}, at={@At(value="HEAD")}, cancellable=true)
    protected void identity_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity identity;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)livingEntity)) instanceof Spider) {
            cir.setReturnValue((Object)this.f_19862_);
        }
    }
}

