/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.mixin;

import draylar.identity.api.PlayerIdentity;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LivingEntity.class})
public abstract class ClientLivingEntityMixin {
    @Unique
    private boolean identity$isAquatic(LivingEntity identity) {
        if (identity == null) {
            return false;
        }
        MobCategory group = identity.m_6095_().m_20674_();
        return switch (group) {
            case MobCategory.WATER_CREATURE, MobCategory.WATER_AMBIENT, MobCategory.UNDERGROUND_WATER_CREATURE -> true;
            default -> false;
        };
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void identity$handleAquaticMovement(Vec3 movementInput, CallbackInfo ci) {
        Player player;
        LivingEntity identity;
        ClientLivingEntityMixin clientLivingEntityMixin = this;
        if (clientLivingEntityMixin instanceof Player && (identity = PlayerIdentity.getIdentity(player = (Player)clientLivingEntityMixin)) != null && this.identity$isAquatic(identity)) {
            boolean inWater = player.m_20069_();
            boolean inBubbleColumn = player.m_9236_().m_8055_(player.m_20183_()).m_60713_(Blocks.f_50628_);
            if (inWater || inBubbleColumn) {
                double speedMultiplier = identity.m_6095_() == EntityType.f_20559_ ? 0.4 : 0.25;
                Vec3 input = movementInput;
                if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
                    input = input.m_82520_(0.0, -1.0, 0.0);
                }
                if (Minecraft.m_91087_().f_91066_.f_92090_.m_90857_()) {
                    input = input.m_82520_(0.0, 1.0, 0.0);
                }
                Vec3 look = player.m_20252_(1.0f);
                Vec3 up = new Vec3(0.0, 1.0, 0.0);
                Vec3 right = up.m_82537_(look).m_82541_();
                Vec3 adjustedUp = right.m_82537_(look).m_82541_();
                Vec3 worldInput = right.m_82490_(input.f_82479_).m_82549_(adjustedUp.m_82490_(input.f_82480_)).m_82549_(look.m_82490_(input.f_82481_));
                if (worldInput.m_82556_() > 1.0E-4) {
                    player.m_20256_(worldInput.m_82541_().m_82490_(speedMultiplier));
                }
            }
        }
    }
}

