/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.forge.util;

import com.github.alexthe666.alexsmobs.entity.EntityCockroach;
import com.github.alexthe666.alexsmobs.item.ItemMaraca;
import draylar.identity.api.PlayerIdentity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Unique;

public class CockroachDanceManager {
    private static final Map<UUID, Integer> DANCE_TICKS = new HashMap<UUID, Integer>();

    public static void forceDance(ServerPlayer player, int ticks) {
        DANCE_TICKS.put(player.m_20148_(), ticks);
    }

    public static void tick(ServerPlayer player) {
        LivingEntity identity = PlayerIdentity.getIdentity((Player)player);
        if (!(identity instanceof EntityCockroach)) {
            DANCE_TICKS.remove(player.m_20148_());
            return;
        }
        EntityCockroach cockroach = (EntityCockroach)identity;
        UUID id = player.m_20148_();
        int remaining = DANCE_TICKS.getOrDefault(id, 0);
        if (player.m_9236_().m_8055_(player.m_20183_().m_7495_()).m_60713_(Blocks.f_50131_)) {
            remaining = 200;
        }
        ServerLevel world = (ServerLevel)cockroach.m_9236_();
        if (remaining > 0) {
            DANCE_TICKS.put(id, remaining - 1);
            if (player.m_21205_().m_41720_() instanceof ItemMaraca || player.m_21206_().m_41720_() instanceof ItemMaraca) {
                world.m_7605_((Entity)player, (byte)69);
                cockroach.setMaracas(true);
                CockroachDanceManager.tellOthersImPlayingLaCucaracha(player);
            } else {
                world.m_7605_((Entity)player, (byte)67);
                cockroach.setMaracas(false);
                CockroachDanceManager.identity$tellOtherCockroachesToStopDancing(cockroach, player);
            }
            cockroach.setDancing(true);
            cockroach.prevDanceProgress = cockroach.danceProgress;
            if (cockroach.danceProgress < 5.0f) {
                cockroach.danceProgress += 1.0f;
            }
            if (!cockroach.m_20096_() || cockroach.m_217043_().m_188503_(200) == 0) {
                cockroach.randomWingFlapTick = 5 + cockroach.m_217043_().m_188503_(15);
            }
            if (cockroach.randomWingFlapTick > 0) {
                --cockroach.randomWingFlapTick;
            }
            cockroach.m_8119_();
        } else if (DANCE_TICKS.containsKey(id)) {
            DANCE_TICKS.remove(id);
            world.m_7605_((Entity)player, (byte)68);
            cockroach.setNearestMusician(null);
            cockroach.setMaracas(false);
            CockroachDanceManager.identity$tellOtherCockroachesToStopDancing(cockroach, player);
            cockroach.setDancing(false);
            cockroach.prevDanceProgress = cockroach.danceProgress;
            if (cockroach.danceProgress > 0.0f) {
                cockroach.danceProgress -= 1.0f;
            }
        }
    }

    private static void tellOthersImPlayingLaCucaracha(ServerPlayer identity) {
        for (EntityCockroach roach : identity.m_9236_().m_6443_(EntityCockroach.class, CockroachDanceManager.getMusicianDistance(identity), EntitySelector.f_20408_)) {
            if (roach.hasMaracas()) continue;
            roach.setNearestMusician(identity.m_20148_());
        }
    }

    private static AABB getMusicianDistance(ServerPlayer identity) {
        return identity.m_20191_().m_82377_(10.0, 10.0, 10.0);
    }

    @Unique
    private static void identity$tellOtherCockroachesToStopDancing(EntityCockroach cockroach, ServerPlayer player) {
        for (EntityCockroach roach : player.m_9236_().m_6443_(EntityCockroach.class, CockroachDanceManager.getMusicianDistance(player), EntitySelector.f_20402_)) {
            if (roach == cockroach) continue;
            try {
                if (!roach.hasMaracas() || roach.getNearestMusician().m_20148_() != player.m_20148_()) continue;
                roach.setMaracas(false);
                roach.setDancing(false);
                roach.m_6818_(player.m_20183_(), false);
            }
            catch (NullPointerException e) {
                roach.setDancing(false);
                roach.m_6818_(player.m_20183_(), false);
            }
        }
    }
}

