/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.forge.config;

import draylar.identity.forge.IdentityForge;
import draylar.identity.forge.config.ConfigLoader;
import draylar.identity.forge.config.EntityListEditorScreen;
import draylar.identity.forge.config.EntityPickerScreen;
import draylar.identity.forge.config.IdentityForgeConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class IdentityForgeConfigScreen
extends Screen {
    private final Screen parent;
    private final List<LabelEntry> labels = new ArrayList<LabelEntry>();
    private final List<WidgetEntry> widgets = new ArrayList<WidgetEntry>();
    private int contentHeight;
    private int scroll;
    private int viewportTop = 20;
    private int viewportBottom;
    private EditBox hostilityTimeBox;
    private EditBox advancementsRequiredForFlightBox;
    private EditBox maxHealthBox;
    private EditBox allowedSwappersBox;
    private EditBox endermanTeleportBox;
    private EditBox flySpeedBox;
    private EditBox requiredKillsBox;
    private EditBox forcedIdentityBox;
    private Button doneButton;

    public IdentityForgeConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Identity Config"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.m_169413_();
        this.labels.clear();
        this.widgets.clear();
        this.scroll = 0;
        IdentityForgeConfig config = IdentityForge.CONFIG;
        int centerX = this.f_96543_ / 2;
        this.viewportTop = 20;
        this.viewportBottom = this.f_96544_ - 40;
        List<ResourceLocation> ids = BuiltInRegistries.f_256780_.m_6566_().stream().sorted(Comparator.comparing(ResourceLocation::toString)).collect(Collectors.toList());
        int y = this.viewportTop;
        y = this.addEntitySection(centerX, y, "Extra Aquatic Entities", ids, config.extraAquaticEntities());
        y = this.addEntitySection(centerX, y, "Removed Aquatic Entities", ids, config.removedAquaticEntities());
        y = this.addEntitySection(centerX, y, "Extra Flying Entities", ids, config.extraFlyingEntities());
        y = this.addEntitySection(centerX, y, "Removed Flying Entities", ids, config.removedFlyingEntities());
        y = this.addBoolean(centerX, y, "Overlay Identity Unlocks", config.overlayIdentityUnlocks, v -> {
            config.overlayIdentityUnlocks = v;
        });
        y = this.addBoolean(centerX, y, "Overlay Identity Revokes", config.overlayIdentityRevokes, v -> {
            config.overlayIdentityRevokes = v;
        });
        y = this.addBoolean(centerX, y, "Revoke Identity On Death", config.revokeIdentityOnDeath, v -> {
            config.revokeIdentityOnDeath = v;
        });
        y = this.addBoolean(centerX, y, "Identities Equip Items", config.identitiesEquipItems, v -> {
            config.identitiesEquipItems = v;
        });
        y = this.addBoolean(centerX, y, "Identities Equip Armor", config.identitiesEquipArmor, v -> {
            config.identitiesEquipArmor = v;
        });
        y = this.addBoolean(centerX, y, "Render Own Name Tag", config.renderOwnNameTag, v -> {
            config.renderOwnNameTag = v;
        });
        y = this.addBoolean(centerX, y, "Hostiles Ignore Hostile Identity Player", config.hostilesIgnoreHostileIdentityPlayer, v -> {
            config.hostilesIgnoreHostileIdentityPlayer = v;
        });
        y = this.addBoolean(centerX, y, "Hostiles Forget New Hostile Identity Player", config.hostilesForgetNewHostileIdentityPlayer, v -> {
            config.hostilesForgetNewHostileIdentityPlayer = v;
        });
        y = this.addBoolean(centerX, y, "Wolves Attack Identity Prey", config.wolvesAttackIdentityPrey, v -> {
            config.wolvesAttackIdentityPrey = v;
        });
        y = this.addBoolean(centerX, y, "Owned Wolves Attack Identity Prey", config.ownedWolvesAttackIdentityPrey, v -> {
            config.ownedWolvesAttackIdentityPrey = v;
        });
        y = this.addBoolean(centerX, y, "Villagers Run From Identities", config.villagersRunFromIdentities, v -> {
            config.villagersRunFromIdentities = v;
        });
        y = this.addBoolean(centerX, y, "Foxes Attack Identity Prey", config.foxesAttackIdentityPrey, v -> {
            config.foxesAttackIdentityPrey = v;
        });
        y = this.addBoolean(centerX, y, "Use Identity Sounds", config.useIdentitySounds, v -> {
            config.useIdentitySounds = v;
        });
        y = this.addBoolean(centerX, y, "Play Ambient Sounds", config.playAmbientSounds, v -> {
            config.playAmbientSounds = v;
        });
        y = this.addBoolean(centerX, y, "Hear Self Ambient", config.hearSelfAmbient, v -> {
            config.hearSelfAmbient = v;
        });
        y = this.addBoolean(centerX, y, "Enable Flight", config.enableFlight, v -> {
            config.enableFlight = v;
        });
        y = this.addBoolean(centerX, y, "Scaling Health", config.scalingHealth, v -> {
            config.scalingHealth = v;
        });
        y = this.addBoolean(centerX, y, "Enable Client Swap Menu", config.enableClientSwapMenu, v -> {
            config.enableClientSwapMenu = v;
        });
        y = this.addBoolean(centerX, y, "Enable Swaps", config.enableSwaps, v -> {
            config.enableSwaps = v;
        });
        y = this.addBoolean(centerX, y, "Show Player Nametag", config.showPlayerNametag, v -> {
            config.showPlayerNametag = v;
        });
        y = this.addBoolean(centerX, y, "Force Change New", config.forceChangeNew, v -> {
            config.forceChangeNew = v;
        });
        y = this.addBoolean(centerX, y, "Force Change Always", config.forceChangeAlways, v -> {
            config.forceChangeAlways = v;
        });
        y = this.addBoolean(centerX, y, "Log Commands", config.logCommands, v -> {
            config.logCommands = v;
        });
        y = this.addBoolean(centerX, y, "Kill For Identity", config.killForIdentity, v -> {
            config.killForIdentity = v;
        });
        y = this.addBoolean(centerX, y, "Warden Is Blinded", config.wardenIsBlinded, v -> {
            config.wardenIsBlinded = v;
        });
        y = this.addBoolean(centerX, y, "Warden Blinds Nearby", config.wardenBlindsNearby, v -> {
            config.wardenBlindsNearby = v;
        });
        this.hostilityTimeBox = this.addIntField(centerX, y, "Hostility Time", config.hostilityTime);
        this.advancementsRequiredForFlightBox = this.addListField(centerX, y += 40, "Advancements Required For Flight", config.advancementsRequiredForFlight());
        this.maxHealthBox = this.addIntField(centerX, y += 40, "Max Health", config.maxHealth);
        this.allowedSwappersBox = this.addListField(centerX, y += 40, "Allowed Swappers", config.allowedSwappers());
        this.endermanTeleportBox = this.addIntField(centerX, y += 40, "Enderman Teleport Distance", config.endermanAbilityTeleportDistance);
        this.flySpeedBox = this.addFloatField(centerX, y += 40, "Fly Speed", config.flySpeed);
        this.requiredKillsBox = this.addIntField(centerX, y += 40, "Required Kills For Identity", config.requiredKillsForIdentity);
        this.forcedIdentityBox = this.addStringField(centerX, y += 40, "Forced Identity", config.forcedIdentity == null ? "" : config.forcedIdentity);
        this.contentHeight = y += 40;
        this.updateWidgetPositions();
        this.doneButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
            this.saveChanges();
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(centerX - 100, this.f_96544_ - 28, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
    }

    private int addEntitySection(int centerX, int y, String label, List<ResourceLocation> ids, List<String> target) {
        this.labels.add(new LabelEntry(label, centerX - 100, y));
        EditBox display = new EditBox(this.f_96547_, centerX - 100, y + 10, 200, 20, (Component)Component.m_237119_());
        display.m_94144_(String.join((CharSequence)",", target));
        display.m_94186_(false);
        this.addEntry(display, y + 10);
        this.addEntry(Button.m_253074_((Component)Component.m_237113_((String)"Select\u2026"), b -> {
            if (this.f_96541_ == null) {
                return;
            }
            this.f_96541_.m_91152_((Screen)new EntityPickerScreen(this, picked -> {
                String s = picked.toString();
                if (!target.contains(s)) {
                    target.add(s);
                    display.m_94144_(String.join((CharSequence)",", target));
                }
            }));
        }).m_252987_(centerX - 100, y + 40, 98, 20).m_253136_(), y + 40);
        this.addEntry(Button.m_253074_((Component)Component.m_237113_((String)"Manage\u2026"), b -> {
            if (this.f_96541_ == null) {
                return;
            }
            this.f_96541_.m_91152_((Screen)new EntityListEditorScreen(this, target, () -> display.m_94144_(String.join((CharSequence)",", target))));
        }).m_252987_(centerX + 2, y + 40, 98, 20).m_253136_(), y + 40);
        return y + 70;
    }

    private int addBoolean(int centerX, int y, String label, boolean initial, Consumer<Boolean> setter) {
        Button toggle = Button.m_253074_((Component)Component.m_237113_((String)(label + ": " + (initial ? "ON" : "OFF"))), btn -> {
            boolean newVal = !IdentityForgeConfigScreen.labelTextIsOn(btn.m_6035_().getString());
            setter.accept(newVal);
            btn.m_93666_((Component)Component.m_237113_((String)(label + ": " + (newVal ? "ON" : "OFF"))));
        }).m_252987_(centerX - 100, y, 200, 20).m_253136_();
        this.addEntry(toggle, y);
        return y + 24;
    }

    private static boolean labelTextIsOn(String s) {
        int i = s.lastIndexOf(58);
        if (i < 0 || i + 2 >= s.length()) {
            return false;
        }
        return s.substring(i + 2).equalsIgnoreCase("ON");
    }

    private EditBox addIntField(int centerX, int y, String label, int value) {
        this.labels.add(new LabelEntry(label, centerX - 100, y));
        EditBox box = new EditBox(this.f_96547_, centerX - 100, y + 10, 200, 20, (Component)Component.m_237119_());
        box.m_94144_(Integer.toString(value));
        box.m_94153_(s -> s.matches("-?\\d*"));
        return this.addEntry(box, y + 10);
    }

    private EditBox addFloatField(int centerX, int y, String label, float value) {
        this.labels.add(new LabelEntry(label, centerX - 100, y));
        EditBox box = new EditBox(this.f_96547_, centerX - 100, y + 10, 200, 20, (Component)Component.m_237119_());
        box.m_94144_(Float.toString(value));
        return this.addEntry(box, y + 10);
    }

    private EditBox addStringField(int centerX, int y, String label, String value) {
        this.labels.add(new LabelEntry(label, centerX - 100, y));
        EditBox box = new EditBox(this.f_96547_, centerX - 100, y + 10, 200, 20, (Component)Component.m_237119_());
        box.m_94144_(value);
        return this.addEntry(box, y + 10);
    }

    private EditBox addListField(int centerX, int y, String label, List<String> list) {
        this.labels.add(new LabelEntry(label, centerX - 100, y));
        EditBox box = new EditBox(this.f_96547_, centerX - 100, y + 10, 200, 20, (Component)Component.m_237119_());
        box.m_94144_(String.join((CharSequence)",", list));
        return this.addEntry(box, y + 10);
    }

    private <T extends AbstractWidget> T addEntry(T widget, int y) {
        this.widgets.add(new WidgetEntry(widget, y));
        return (T)((AbstractWidget)this.m_142416_((GuiEventListener)widget));
    }

    private void updateWidgetPositions() {
        for (WidgetEntry entry : this.widgets) {
            entry.widget.m_253211_(entry.baseY - this.scroll);
        }
    }

    private void saveChanges() {
        IdentityForgeConfig config = IdentityForge.CONFIG;
        config.hostilityTime = this.parseInt(this.hostilityTimeBox.m_94155_(), config.hostilityTime);
        config.advancementsRequiredForFlight().clear();
        IdentityForgeConfigScreen.splitAndAdd(this.advancementsRequiredForFlightBox.m_94155_(), config.advancementsRequiredForFlight());
        config.maxHealth = this.parseInt(this.maxHealthBox.m_94155_(), config.maxHealth);
        config.allowedSwappers().clear();
        IdentityForgeConfigScreen.splitAndAdd(this.allowedSwappersBox.m_94155_(), config.allowedSwappers());
        config.endermanAbilityTeleportDistance = this.parseInt(this.endermanTeleportBox.m_94155_(), config.endermanAbilityTeleportDistance);
        config.flySpeed = this.parseFloat(this.flySpeedBox.m_94155_(), config.flySpeed);
        config.requiredKillsForIdentity = this.parseInt(this.requiredKillsBox.m_94155_(), config.requiredKillsForIdentity);
        config.forcedIdentity = this.forcedIdentityBox.m_94155_().isEmpty() ? null : this.forcedIdentityBox.m_94155_();
        ConfigLoader.save(config);
    }

    private static void splitAndAdd(String csv, List<String> out) {
        if (csv == null || csv.isEmpty()) {
            return;
        }
        for (String s : csv.split(",")) {
            String t = s.trim();
            if (t.isEmpty()) continue;
            out.add(t);
        }
    }

    private int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception ignored) {
            return def;
        }
    }

    private float parseFloat(String s, float def) {
        try {
            return Float.parseFloat(s.trim());
        }
        catch (Exception ignored) {
            return def;
        }
    }

    public void m_88315_(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        this.m_280273_(ctx);
        ctx.m_280588_(0, this.viewportTop, this.f_96543_, this.viewportBottom);
        for (LabelEntry label : this.labels) {
            int ly = label.y - this.scroll;
            if (ly + 10 <= this.viewportTop || ly >= this.viewportBottom) continue;
            ctx.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)label.text), label.x, ly, 0xFFFFFF, false);
        }
        for (WidgetEntry entry : this.widgets) {
            int wy = entry.widget.m_252907_();
            if (wy + entry.widget.m_93694_() <= this.viewportTop || wy >= this.viewportBottom) continue;
            entry.widget.m_88315_(ctx, mouseX, mouseY, delta);
        }
        ctx.m_280618_();
        if (this.doneButton != null) {
            this.doneButton.m_88315_(ctx, mouseX, mouseY, delta);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (mouseY >= (double)this.viewportTop && mouseY <= (double)this.viewportBottom) {
            int maxScroll = Math.max(this.contentHeight - (this.viewportBottom - this.viewportTop), 0);
            this.scroll = Mth.m_14045_((int)(this.scroll - (int)(amount * 20.0)), (int)0, (int)maxScroll);
            this.updateWidgetPositions();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseY >= (double)this.viewportTop && mouseY <= (double)this.viewportBottom) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        return this.doneButton != null && this.doneButton.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (mouseY >= (double)this.viewportTop && mouseY <= (double)this.viewportBottom) {
            return super.m_6348_(mouseX, mouseY, button);
        }
        return this.doneButton != null && this.doneButton.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (mouseY >= (double)this.viewportTop && mouseY <= (double)this.viewportBottom) {
            return super.m_7979_(mouseX, mouseY, button, dx, dy);
        }
        return false;
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public boolean m_7043_() {
        return true;
    }

    private static class LabelEntry {
        final String text;
        final int x;
        final int y;

        LabelEntry(String text, int x, int y) {
            this.text = text;
            this.x = x;
            this.y = y;
        }
    }

    private static class WidgetEntry {
        final AbstractWidget widget;
        final int baseY;

        WidgetEntry(AbstractWidget widget, int baseY) {
            this.widget = widget;
            this.baseY = baseY;
        }
    }
}

