/*
 * Decompiled with CFR 0.152.
 */
package draylar.identity.api.variant;

import draylar.identity.Identity;
import draylar.identity.api.variant.TypeProvider;
import draylar.identity.impl.variant.AxolotlTypeProvider;
import draylar.identity.impl.variant.CatTypeProvider;
import draylar.identity.impl.variant.FoxTypeProvider;
import draylar.identity.impl.variant.FrogTypeProvider;
import draylar.identity.impl.variant.ParrotTypeProvider;
import draylar.identity.impl.variant.SheepTypeProvider;
import draylar.identity.impl.variant.SlimeTypeProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.Gabou.gaboulibs.util.CompatUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class IdentityType<T extends LivingEntity> {
    private static final List<EntityType<? extends LivingEntity>> LIVING_TYPE_CASH = new ArrayList<EntityType<? extends LivingEntity>>();
    private static final Map<EntityType<? extends LivingEntity>, TypeProvider<?>> VARIANT_BY_TYPE = new LinkedHashMap();
    private final EntityType<T> type;
    private final int variantData;

    public IdentityType(EntityType<T> type) {
        this.type = type;
        this.variantData = this.getDefaultVariantData(type);
    }

    private int getDefaultVariantData(EntityType<T> type) {
        if (VARIANT_BY_TYPE.containsKey(type)) {
            return VARIANT_BY_TYPE.get(type).getFallbackData();
        }
        return -1;
    }

    public IdentityType(EntityType<T> type, int variantData) {
        this.type = type;
        this.variantData = variantData;
    }

    public IdentityType(T entity) {
        this.type = entity.m_6095_();
        @Nullable TypeProvider<?> provider = VARIANT_BY_TYPE.get(this.type);
        this.variantData = provider != null ? provider.getVariantData(entity) : this.getDefaultVariantData(this.type);
    }

    @Nullable
    public static <Z extends LivingEntity> IdentityType<Z> from(Z entity) {
        if (entity == null) {
            return null;
        }
        EntityType type = entity.m_6095_();
        if (VARIANT_BY_TYPE.containsKey(type)) {
            TypeProvider<?> typeProvider = VARIANT_BY_TYPE.get(type);
            return typeProvider.create(type, entity);
        }
        return new IdentityType<EntityType>(entity.m_6095_());
    }

    @Nullable
    public static IdentityType<?> from(CompoundTag compound) {
        ResourceLocation id = new ResourceLocation(compound.m_128461_("EntityID"));
        if (!BuiltInRegistries.f_256780_.m_7804_(id)) {
            return null;
        }
        return new IdentityType((EntityType)BuiltInRegistries.f_256780_.m_7745_(id), compound.m_128441_("Variant") ? compound.m_128451_("Variant") : -1);
    }

    public static List<IdentityType<?>> getAllTypes(Level world) {
        if (LIVING_TYPE_CASH.isEmpty()) {
            for (EntityType type : BuiltInRegistries.f_256780_) {
                ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)type);
                if (CompatUtils.isBlacklistedEntityType((String)id.toString())) continue;
                try {
                    Entity instance = type.m_20615_(world);
                    if (!(instance instanceof LivingEntity)) continue;
                    LIVING_TYPE_CASH.add((EntityType<? extends LivingEntity>)type);
                }
                catch (Throwable t) {
                    CompatUtils.markIncompatibleEntityType((String)id.toString());
                    Identity.LOGGER.warn("Skipping incompatible identity type {} during cache.", (Object)type, (Object)t);
                }
            }
        }
        ArrayList types = new ArrayList();
        for (EntityType<? extends LivingEntity> type : LIVING_TYPE_CASH) {
            if (VARIANT_BY_TYPE.containsKey(type)) {
                TypeProvider<?> variant = VARIANT_BY_TYPE.get(type);
                for (int i = 0; i <= variant.getRange(); ++i) {
                    types.add(new IdentityType<LivingEntity>(type, i));
                }
                continue;
            }
            types.add(new IdentityType<EntityType<? extends LivingEntity>>(type));
        }
        return types;
    }

    @Nullable
    public static <Z extends LivingEntity> IdentityType<Z> from(EntityType<?> entityType, int variant) {
        if (VARIANT_BY_TYPE.containsKey(entityType)) {
            TypeProvider<?> provider = VARIANT_BY_TYPE.get(entityType);
            if (variant < -1 || variant > provider.getRange()) {
                return null;
            }
        }
        return new IdentityType(entityType, variant);
    }

    public CompoundTag writeCompound() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("EntityID", BuiltInRegistries.f_256780_.m_7981_(this.type).toString());
        compound.m_128405_("Variant", this.variantData);
        return compound;
    }

    public EntityType<? extends LivingEntity> getEntityType() {
        return this.type;
    }

    public T create(Level world) {
        TypeProvider<?> typeProvider = VARIANT_BY_TYPE.get(this.type);
        if (typeProvider != null) {
            return (T)typeProvider.create(this.type, world, this.variantData);
        }
        return (T)((LivingEntity)this.type.m_20615_(world));
    }

    public int getVariantData() {
        return this.variantData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityType that = (IdentityType)o;
        return this.variantData == that.variantData && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.variantData);
    }

    public void writeEntityNbt(CompoundTag tag) {
        CompoundTag inner = this.writeCompound();
        tag.m_128365_("IdentityType", (Tag)inner);
    }

    public static IdentityType<?> fromEntityNbt(CompoundTag tag) {
        return IdentityType.from(tag.m_128469_("IdentityType"));
    }

    public Component createTooltipText(T entity) {
        TypeProvider<?> provider = VARIANT_BY_TYPE.get(this.type);
        if (provider != null) {
            return provider.modifyText(entity, Component.m_237115_((String)this.type.m_20675_()));
        }
        return Component.m_237115_((String)this.type.m_20675_());
    }

    static {
        VARIANT_BY_TYPE.put((EntityType<? extends LivingEntity>)EntityType.f_20520_, new SheepTypeProvider());
        VARIANT_BY_TYPE.put((EntityType<? extends LivingEntity>)EntityType.f_147039_, new AxolotlTypeProvider());
        VARIANT_BY_TYPE.put((EntityType<? extends LivingEntity>)EntityType.f_20508_, new ParrotTypeProvider());
        VARIANT_BY_TYPE.put((EntityType<? extends LivingEntity>)EntityType.f_20452_, new FoxTypeProvider());
        VARIANT_BY_TYPE.put((EntityType<? extends LivingEntity>)EntityType.f_20553_, new CatTypeProvider());
        VARIANT_BY_TYPE.put((EntityType<? extends LivingEntity>)EntityType.f_20526_, new SlimeTypeProvider());
        VARIANT_BY_TYPE.put((EntityType<? extends LivingEntity>)EntityType.f_217012_, new FrogTypeProvider());
    }
}

